/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.BatchConvertFastaQdataMiSeq;
import fileOperation.OneMatch;
import fileOperation.ParseFastaByHapType;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;
import misc.SystemCommand;

public class CrossMatchEndSeq4 {
    static int MIN_SCORE = 35;
    static String LABEL = "000000";
    private static final int MIN_NUM_PAIRS_OUTPUT = 10;

    public static void main(String[] args) throws Exception {
        File backBones = new File(args[0]);
        File miseqDir = new File(args[1]);
        File output = new File(args[2]);
        File fastaqRoot = new File(args[3]);
        File assemblyRoot = new File(args[4]);
        boolean doAssemble = new Boolean(args[5]);
        boolean isPairedReads = new Boolean(args[6]);
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append("Coord\t").append("prob\t").append("total count\t").append("exon 2 count(F,R)\t").append("average mismatch\t").append("average score\t").append("exon 3 count(F,R)\t").append("average mismatch\t").append("average score\t").append("exon 4 count(F,R)\t").append("average mismatch\t").append("average score\n");
        Map<String, String> types = CrossMatchEndSeq4.getAllTypes(backBones);
        File[] fileArray = miseqDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("fa")) {
                System.out.println(file.getName().substring(0, file.getName().length() - 9));
                File fastaq = new File(fastaqRoot, String.valueOf(file.getName().substring(0, file.getName().length() - 9)) + ".fq");
                File assemblyDir = new File(assemblyRoot, file.getName().substring(0, file.getName().length() - 9));
                CrossMatchEndSeq4.crossMatchFasta(file, backBones, outputBuilder, fastaq, assemblyDir, types, doAssemble, isPairedReads);
            }
            ++n2;
        }
        FileManager.writeTextFile(output, outputBuilder.toString(), true);
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        HashMap<String, String> types = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(hapFile).split("\n");
        String name = null;
        String seq = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                if (name != null) {
                    types.put(name, seq);
                }
                String[] items = line.trim().substring(1).split("\\s+");
                name = String.valueOf(items[0].trim()) + "_" + items[1].trim();
                seq = "";
            } else {
                seq = String.valueOf(seq) + line.trim();
            }
            ++n2;
        }
        types.put(name, seq);
        return types;
    }

    private static List<String> filterResult(String matchResult) {
        String[] lines;
        ArrayList<String> results = new ArrayList<String>();
        String[] stringArray = lines = matchResult.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                results.add(line);
            }
            ++n2;
        }
        return results;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(List<String> filteredResult) {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        for (String line : filteredResult) {
            OneMatch aMatch;
            Map matches;
            String type;
            if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12) continue;
            String[] items = line.trim().split("\\s+");
            String name = items[4].trim().substring(0, items[4].trim().length() - 2);
            boolean isRevComp = items[8].trim().equals("C");
            String string = type = isRevComp ? items[9].trim() : items[8].trim();
            if (!result.containsKey(type)) {
                result.put(type, new HashMap());
            }
            if (!(matches = (Map)result.get(type)).containsKey(name)) {
                aMatch = new OneMatch();
                aMatch.setName(name);
                matches.put(name, aMatch);
            }
            aMatch = (OneMatch)matches.get(name);
            if (isRevComp) {
                aMatch.setReverseExist(true);
                aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
                aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
                aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
                continue;
            }
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
        }
        return result;
    }

    private static void crossMatchFasta(File fasta, File backBones, StringBuilder builder, File fastaq, File assemblyDir, Map<String, String> types, boolean doAssemble, boolean isPairedReads) throws Exception {
        String cmd = "/genome/bin/cross_match -minscore " + MIN_SCORE + " " + fasta.getAbsolutePath() + " " + backBones;
        String data = OsHelper.excuteCommand(cmd);
        Map<String, Map<String, OneMatch>> result = CrossMatchEndSeq4.ParseResult(CrossMatchEndSeq4.filterResult(data));
        HashMap orgnizedTypes = new HashMap();
        HashMap effectiveMatchesByType = new HashMap();
        int roundNum = 1;
        if (isPairedReads) {
            roundNum = 0;
        }
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
                if (!match.isForwardExist() || !match.isReverseExist()) continue;
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(type);
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int imageCount = 0;
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (c > 10) {
                for (String t : (List)orgnizedTypes.get(c)) {
                    File phdDir;
                    String info;
                    if (roundNum == 0) {
                        info = String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 9)) + "\t" + t + "\t" + c + "\t";
                        builder.append(info);
                        builder.append(CrossMatchEndSeq4.getStatistics((List)effectiveMatchesByType.get(t), roundNum));
                        builder.append("\n");
                        ++imageCount;
                        if (!doAssemble) continue;
                        phdDir = ParseFastaByHapType.makeDirs(assemblyDir);
                        ParseFastaByHapType.convert(phdDir, CrossMatchEndSeq4.toListOfNames((List)effectiveMatchesByType.get(t)), fastaq, null);
                        CrossMatchEndSeq4.writePhdFile(phdDir, t, types);
                        BatchConvertFastaQdataMiSeq.runCmd("/genome/bin/phredPhrap ", new File(assemblyDir, "assembly"));
                        continue;
                    }
                    info = String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 9)) + "\t" + t + "\t" + c + "\t";
                    builder.append(info);
                    builder.append(CrossMatchEndSeq4.getStatistics((List)effectiveMatchesByType.get(t), roundNum));
                    builder.append("\n");
                    ++imageCount;
                    if (!doAssemble) continue;
                    phdDir = ParseFastaByHapType.makeDirs(assemblyDir);
                    ParseFastaByHapType.convert(phdDir, CrossMatchEndSeq4.toListOfNames((List)effectiveMatchesByType.get(t)), fastaq, null);
                    CrossMatchEndSeq4.writePhdFile(phdDir, t, types);
                    BatchConvertFastaQdataMiSeq.runCmd("/genome/bin/phredPhrap ", new File(assemblyDir, "assembly"));
                }
            }
            --i;
        }
    }

    public static int writePhdFile(File phdDir, String name, Map<String, String> types) throws Exception {
        String seq = null;
        String fullName = null;
        for (String tn : types.keySet()) {
            if (!tn.startsWith(String.valueOf(name) + "_")) continue;
            seq = types.get(tn);
            fullName = tn;
            break;
        }
        File tmpFile = File.createTempFile(fullName, "fa");
        tmpFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(fullName).append("\n");
        builder.append(seq);
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/bin/perl /genome/bin/fasta2Phd.perl -quality 40 " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        phdFile.renameTo(new File(phdDir, String.valueOf(fullName) + ".phd.1"));
        return 1;
    }

    private static List<String> toListOfNames(List<OneMatch> matches) {
        ArrayList<String> names = new ArrayList<String>();
        for (OneMatch matche : matches) {
            names.add(matche.getName());
            if (names.size() >= 100) break;
        }
        return names;
    }

    private static String getStatistics(List<OneMatch> list, int roundNum) {
        double mismatch = 0.0;
        double mismatch2 = 0.0;
        double mismatch3 = 0.0;
        double mismatch4 = 0.0;
        int score = 0;
        int score2 = 0;
        int score3 = 0;
        int score4 = 0;
        int forCount2 = 0;
        int revCount2 = 0;
        int forCount3 = 0;
        int revCount3 = 0;
        int forCount4 = 0;
        int revCount4 = 0;
        int total = list.size();
        if (roundNum == 0) {
            total += total;
        }
        for (OneMatch match : list) {
            int exon;
            if (roundNum == 0) {
                mismatch += match.getForwardMisMatch();
                mismatch += match.getReverseMisMatch();
                score += match.getForwardScore();
                score += match.getReverseScore();
                continue;
            }
            total = 0;
            if (match.isForwardExist()) {
                exon = CrossMatchEndSeq4.getExon(match.getForwardTargetStart(), match.getForwardTargetEnd(), false);
                if (exon == 2) {
                    mismatch2 += match.getForwardMisMatch();
                    score2 += match.getForwardScore();
                    ++forCount2;
                    ++total;
                }
                if (exon == 3) {
                    mismatch3 += match.getForwardMisMatch();
                    score3 += match.getForwardScore();
                    ++forCount3;
                    ++total;
                }
                if (exon == 4) {
                    mismatch4 += match.getForwardMisMatch();
                    score4 += match.getForwardScore();
                    ++forCount4;
                    ++total;
                }
            }
            if (!match.isReverseExist()) continue;
            exon = CrossMatchEndSeq4.getExon(match.getReverseTargetStart(), match.getReverseTargetEnd(), true);
            if (exon == 2) {
                mismatch2 += match.getForwardMisMatch();
                score2 += match.getForwardScore();
                ++revCount2;
                ++total;
            }
            if (exon == 3) {
                mismatch3 += match.getForwardMisMatch();
                score3 += match.getForwardScore();
                ++revCount3;
                ++total;
            }
            if (exon != 4) continue;
            mismatch4 += match.getForwardMisMatch();
            score4 += match.getForwardScore();
            ++revCount4;
            ++total;
        }
        String out = "";
        if (roundNum > 0) {
            if (forCount2 + revCount2 > 0) {
                out = String.valueOf(out) + (forCount2 + revCount2) + "(" + forCount2 + "," + revCount2 + ")\t";
                out = String.valueOf(out) + CrossMatchEndSeq4.roundTwoDecimals(mismatch2 / new Double(forCount2 + revCount2)) + "\t";
            } else {
                out = String.valueOf(out) + "0\t";
                out = String.valueOf(out) + "NA\t";
            }
            if (forCount3 + revCount3 > 0) {
                out = String.valueOf(out) + (forCount3 + revCount3) + "(" + forCount3 + "," + revCount3 + ")\t";
                out = String.valueOf(out) + CrossMatchEndSeq4.roundTwoDecimals(mismatch3 / new Double(forCount3 + revCount3)) + "\t";
            } else {
                out = String.valueOf(out) + "0\t";
                out = String.valueOf(out) + "NA\t";
            }
            if (forCount4 + revCount4 > 0) {
                out = String.valueOf(out) + (forCount4 + revCount4) + "(" + forCount4 + "," + revCount4 + ")\t";
                out = String.valueOf(out) + CrossMatchEndSeq4.roundTwoDecimals(mismatch4 / new Double(forCount4 + revCount4)) + "\t";
            } else {
                out = String.valueOf(out) + "0\t";
                out = String.valueOf(out) + "NA\t";
            }
            return out;
        }
        out = String.valueOf(CrossMatchEndSeq4.roundTwoDecimals(mismatch / new Double(total))) + "\t";
        return String.valueOf(out) + score / total;
    }

    private static int getExon(int start, int end, boolean isRevComp) {
        if (start < 280) {
            return 2;
        }
        if (isRevComp) {
            if (end > 550 && end < 650) {
                return 3;
            }
            if (end > 850 && end < 950) {
                return 4;
            }
        } else {
            if (start > 300 && start < 400) {
                return 3;
            }
            if (start > 550 && start < 650) {
                return 4;
            }
        }
        System.out.println("unknow region " + start + " " + end + " " + isRevComp);
        return 0;
    }

    private static double roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(d));
    }
}

