/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.OneMatch;
import fileOperation.ParseFastaByHapType;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class CrossMatchEndSeq3 {
    static int MIN_SCORE = 35;
    static String LABEL = "000000";
    private static final int MIN_NUM_PAIRS_OUTPUT = 10;

    public static void main(String[] args) throws Exception {
        File backBones = new File(args[0]);
        File miseqDir = new File(args[1]);
        File output = new File(args[2]);
        File fastaqRoot = new File(args[3]);
        File assemblyRoot = new File(args[4]);
        boolean doAssemble = new Boolean(args[5]);
        boolean isPairedReads = new Boolean(args[6]);
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append("Coord\t").append("prob\t").append("count\t").append("average mismatch\t").append("average score\n");
        File[] fileArray = miseqDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("fa")) {
                System.out.println(file.getName().substring(0, file.getName().length() - 9));
                File fastaq = new File(fastaqRoot, String.valueOf(file.getName().substring(0, file.getName().length() - 9)) + ".fq");
                File assemblyDir = new File(assemblyRoot, file.getName().substring(0, file.getName().length() - 9));
                CrossMatchEndSeq3.crossMatchFasta(file, backBones, outputBuilder, fastaq, assemblyDir, doAssemble, isPairedReads);
            }
            ++n2;
        }
        FileManager.writeTextFile(output, outputBuilder.toString(), true);
    }

    private static List<String> filterResult(String matchResult) {
        String[] lines;
        ArrayList<String> results = new ArrayList<String>();
        String[] stringArray = lines = matchResult.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                results.add(line);
            }
            ++n2;
        }
        return results;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(List<String> filteredResult) {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        for (String line : filteredResult) {
            OneMatch aMatch;
            Map matches;
            String type;
            if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12) continue;
            String[] items = line.trim().split("\\s+");
            String name = items[4].trim().substring(0, items[4].trim().length() - 2);
            boolean isRevComp = items[8].trim().equals("C");
            String string = type = isRevComp ? items[9].trim() : items[8].trim();
            if (!result.containsKey(type)) {
                result.put(type, new HashMap());
            }
            if (!(matches = (Map)result.get(type)).containsKey(name)) {
                aMatch = new OneMatch();
                aMatch.setName(name);
                matches.put(name, aMatch);
            }
            aMatch = (OneMatch)matches.get(name);
            if (isRevComp) {
                aMatch.setReverseExist(true);
                aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
                aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
                aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
                continue;
            }
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
        }
        return result;
    }

    private static void crossMatchFasta(File fasta, File backBones, StringBuilder builder, File fastaq, File assemblyDir, boolean doAssemble, boolean isPairedReads) throws Exception {
        String cmd = "/genome/bin/cross_match -minscore " + MIN_SCORE + " " + fasta.getAbsolutePath() + " " + backBones;
        String data = OsHelper.excuteCommand(cmd);
        Map<String, Map<String, OneMatch>> result = CrossMatchEndSeq3.ParseResult(CrossMatchEndSeq3.filterResult(data));
        if (result.size() == 0) {
            builder.append(fasta.getName().substring(0, fasta.getName().length() - 9));
            builder.append("\n");
        }
        HashMap orgnizedTypes = new HashMap();
        HashMap effectiveMatchesByType = new HashMap();
        int roundNum = 1;
        if (isPairedReads) {
            roundNum = 0;
        }
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(type);
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int imageCount = 0;
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (c > 10) {
                for (String t : (List)orgnizedTypes.get(c)) {
                    File phdDir;
                    File typeDir;
                    String info;
                    if (roundNum == 0) {
                        info = String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 9)) + "\t" + t + "\t" + c + "\t";
                        builder.append(info);
                        builder.append(CrossMatchEndSeq3.getStatistics((List)effectiveMatchesByType.get(t), roundNum));
                        builder.append("\n");
                        ++imageCount;
                        if (!doAssemble) continue;
                        typeDir = new File(assemblyDir, t);
                        phdDir = ParseFastaByHapType.makeDirs(typeDir);
                        ParseFastaByHapType.convert(phdDir, CrossMatchEndSeq3.toListOfNames((List)effectiveMatchesByType.get(t)), fastaq, null);
                        continue;
                    }
                    info = String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 9)) + "\t" + t + "\t" + c + "\t";
                    builder.append(info);
                    builder.append(CrossMatchEndSeq3.getStatistics((List)effectiveMatchesByType.get(t), roundNum));
                    builder.append("\n");
                    ++imageCount;
                    if (!doAssemble) continue;
                    typeDir = new File(assemblyDir, t);
                    phdDir = ParseFastaByHapType.makeDirs(typeDir);
                    ParseFastaByHapType.convert(phdDir, CrossMatchEndSeq3.toListOfNames((List)effectiveMatchesByType.get(t)), fastaq, null);
                }
            }
            --i;
        }
    }

    private static List<String> toListOfNames(List<OneMatch> matches) {
        ArrayList<String> names = new ArrayList<String>();
        for (OneMatch matche : matches) {
            names.add(matche.getName());
            if (names.size() >= 300) break;
        }
        return names;
    }

    private static String getStatistics(List<OneMatch> list, int roundNum) {
        double mismatch = 0.0;
        int score = 0;
        for (OneMatch match : list) {
            if (roundNum == 0) {
                mismatch += match.getForwardMisMatch();
                mismatch += match.getReverseMisMatch();
                score += match.getForwardScore();
                score += match.getReverseScore();
                continue;
            }
            mismatch += match.isForwardExist() ? match.getForwardMisMatch() : match.getReverseMisMatch();
            score += match.isForwardExist() ? match.getForwardScore() : match.getReverseScore();
        }
        int total = list.size();
        if (roundNum == 0) {
            total += total;
        }
        String out = String.valueOf(CrossMatchEndSeq3.roundTwoDecimals(mismatch / new Double(total))) + "\t";
        return String.valueOf(out) + score / total;
    }

    private static double roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(d));
    }
}

