/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.OneMatch;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class CrossMatchEndSeq2 {
    static int MIN_SCORE = 80;
    static String LABEL = "000000";
    private static final int MIN_NUM_PAIRS_OUTPUT = 0;

    public static void main(String[] args) throws Exception {
        File backBones = new File(args[0]);
        File miseqDir = new File(args[1]);
        File output = new File(args[2]);
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append("Coord\t").append("prob\t").append("count\t").append("average mismatch\t").append("average score\n");
        File[] fileArray = miseqDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("fa")) {
                System.out.println(">>>>>>>" + file.getName());
                CrossMatchEndSeq2.crossMatchFasta(file, backBones, outputBuilder);
            }
            ++n2;
        }
        FileManager.writeTextFile(output, outputBuilder.toString(), true);
    }

    private static List<String> filterResult(String matchResult) {
        String[] lines;
        ArrayList<String> results = new ArrayList<String>();
        String[] stringArray = lines = matchResult.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                results.add(line);
            }
            ++n2;
        }
        return results;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(List<String> filteredResult) {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        for (String line : filteredResult) {
            OneMatch aMatch;
            Map matches;
            String type;
            if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12) continue;
            String[] items = line.trim().split("\\s+");
            String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
            String name = thisRead.substring(0, thisRead.length() - 2);
            boolean isRevComp = items[8].trim().equals("C");
            String string = type = isRevComp ? items[9].trim() : items[8].trim();
            if (!result.containsKey(type)) {
                result.put(type, new HashMap());
            }
            if (!(matches = (Map)result.get(type)).containsKey(name)) {
                aMatch = new OneMatch();
                aMatch.setName(name);
                matches.put(name, aMatch);
            }
            aMatch = (OneMatch)matches.get(name);
            if (isRevComp) {
                aMatch.setReverseExist(true);
                aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
                aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
                aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
                continue;
            }
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
        }
        return result;
    }

    private static void crossMatchFasta(File fasta, File backBones, StringBuilder builder) throws Exception {
        String cmd = "/genome/bin/cross_match -minscore " + MIN_SCORE + " " + fasta.getAbsolutePath() + " " + backBones;
        String data = OsHelper.excuteCommand(cmd);
        Map<String, Map<String, OneMatch>> result = CrossMatchEndSeq2.ParseResult(CrossMatchEndSeq2.filterResult(data));
        HashMap orgnizedTypes = new HashMap();
        HashMap effectiveMatchesByType = new HashMap();
        int roundNum = 0;
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                if (match.isForwardExist() && match.isReverseExist()) {
                    count += 2;
                    continue;
                }
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(type);
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int imageCount = 0;
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (c > 0) {
                for (String t : (List)orgnizedTypes.get(c)) {
                    String info;
                    if (roundNum == 0) {
                        info = String.valueOf(fasta.getName()) + "\t" + t + "\t" + c + "\t";
                        builder.append(info);
                        builder.append(CrossMatchEndSeq2.getStatistics((List)effectiveMatchesByType.get(t)));
                        builder.append("\n");
                        ++imageCount;
                        continue;
                    }
                    info = String.valueOf(fasta.getName()) + "\t" + t + "\t" + c + "\t";
                    builder.append(info);
                    builder.append(CrossMatchEndSeq2.getStatistics((List)effectiveMatchesByType.get(t)));
                    builder.append("\n");
                    ++imageCount;
                }
            }
            --i;
        }
    }

    private static String getStatistics(List<OneMatch> list) {
        double mismatch = 0.0;
        int score = 0;
        int count = 0;
        for (OneMatch match : list) {
            if (match.isForwardExist()) {
                mismatch += match.getForwardMisMatch();
                score += match.getForwardScore();
                ++count;
            }
            if (!match.isReverseExist()) continue;
            mismatch += match.getReverseMisMatch();
            score += match.getReverseScore();
            ++count;
        }
        String out = String.valueOf(CrossMatchEndSeq2.roundTwoDecimals(mismatch / new Double(count))) + "\t";
        return String.valueOf(out) + score / count;
    }

    private static double roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(d));
    }
}

