/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class CreateExon23Amb {
    private static final int EXON_BOUNDARY = 270;

    public static void main(String[] args) throws Exception {
        File exon23FastaFile = new File(args[0]);
        File outputDir = new File(args[1]);
        String locusName = new String(args[2]);
        List<String> exonspecial = CreateExon23Amb.loadExonspecial();
        CreateExon23Amb.createAmbFiles(exon23FastaFile, outputDir, locusName, exonspecial);
    }

    private static List<String> loadExonspecial() {
        ArrayList<String> exonspecial = new ArrayList<String>();
        exonspecial.add("A*01:15N");
        exonspecial.add("A*01:16N");
        exonspecial.add("A*01:123N");
        exonspecial.add("A*02:94N");
        exonspecial.add("A*02:125N");
        exonspecial.add("A*02:250N");
        exonspecial.add("A*02:301N");
        exonspecial.add("A*03:03N");
        exonspecial.add("A*03:36N");
        exonspecial.add("A*11:52Q");
        exonspecial.add("A*11:78N");
        exonspecial.add("A*11:99N");
        exonspecial.add("A*A*11:180N");
        exonspecial.add("A*23:11N");
        exonspecial.add("A*23:38N");
        exonspecial.add("A*24:36N");
        exonspecial.add("A*24:45N");
        exonspecial.add("A*24:86N");
        exonspecial.add("A*24:158N");
        exonspecial.add("A*24:222N");
        exonspecial.add("A*24:232N");
        exonspecial.add("A*24:252N");
        exonspecial.add("A*26:11N");
        exonspecial.add("A*26:25N");
        exonspecial.add("A*30:70N");
        exonspecial.add("A*30:73N");
        exonspecial.add("A*30:78N");
        exonspecial.add("A*32:56N");
        exonspecial.add("A*68:18N");
        exonspecial.add("A*74:12N");
        exonspecial.add("A*24:294Q");
        exonspecial.add("A*03:200Q");
        exonspecial.add("A*11:180N");
        exonspecial.add("A*24:294Q");
        exonspecial.add("G*01:05N");
        exonspecial.add("J*01:01:01:07");
        exonspecial.add("K*01:01:01:01");
        exonspecial.add("K*01:01:01:02");
        exonspecial.add("K*01:01:01:03");
        exonspecial.add("K*01:01:01:04");
        exonspecial.add("K*01:02");
        exonspecial.add("K*01:03");
        exonspecial.add("L*01:01:01:01");
        exonspecial.add("L*01:01:01:02");
        exonspecial.add("L*01:01:01:03");
        exonspecial.add("L*01:01:02");
        exonspecial.add("L*01:02");
        exonspecial.add("B*07:67N");
        exonspecial.add("B*08:08N");
        exonspecial.add("B*13:07N");
        exonspecial.add("B*13:63N");
        exonspecial.add("B*15:79N");
        exonspecial.add("B*15:111N");
        exonspecial.add("B*15:149N");
        exonspecial.add("B*15:246N");
        exonspecial.add("B*15:262N");
        exonspecial.add("B*27:66N");
        exonspecial.add("B*35:53N");
        exonspecial.add("B*35:145N");
        exonspecial.add("B*39:25N");
        exonspecial.add("B*40:142N");
        exonspecial.add("B*40:155:01N");
        exonspecial.add("B*40:155:02N");
        exonspecial.add("B*40:216N");
        exonspecial.add("B*40:256N");
        exonspecial.add("B*40:265N");
        exonspecial.add("B*44:52N");
        exonspecial.add("B*44:138Q");
        exonspecial.add("B*51:118N");
        exonspecial.add("B*51:149N");
        exonspecial.add("B*54:05N");
        exonspecial.add("B*58:10N");
        exonspecial.add("B*58:17N");
        exonspecial.add("B*46:41N");
        exonspecial.add("B*37:42N");
        exonspecial.add("B*15:304N");
        exonspecial.add("B*14:41N");
        exonspecial.add("B*39:97N");
        exonspecial.add("C*03:46");
        exonspecial.add("C*05:07N");
        exonspecial.add("C*05:51Q");
        exonspecial.add("C*06:16N");
        exonspecial.add("C*07:32N");
        exonspecial.add("C*07:33N");
        exonspecial.add("C*07:150Q");
        exonspecial.add("C*08:36N");
        exonspecial.add("C*12:84N");
        exonspecial.add("C*01:86N");
        exonspecial.add("C*05:99N");
        exonspecial.add("C*06:116N");
        exonspecial.add("C*07:347N");
        exonspecial.add("C*08:88N");
        exonspecial.add("C*08:89N");
        exonspecial.add("C*15:84Q");
        exonspecial.add("C*01:98N");
        exonspecial.add("C*02:92N");
        exonspecial.add("C*05:113N");
        exonspecial.add("C*07:393N");
        exonspecial.add("C*15:105Q");
        return exonspecial;
    }

    private static void createAmbFiles(File fastaFile, File outputDir, String locusName, List<String> exonspecial) {
        LinkedHashMap<String, List<String>> seq2 = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> seq3 = new LinkedHashMap<String, List<String>>();
        LinkedHashMap seq23 = new LinkedHashMap();
        StringBuilder fastaBuilder2 = new StringBuilder();
        StringBuilder fastaBuilder3 = new StringBuilder();
        StringBuilder fastaBuilder23 = new StringBuilder();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                String exon2 = sequence.substring(0, 270);
                String exon3 = sequence.substring(270);
                String exon23 = String.valueOf(exon2) + "XXXXXXXXXX" + exon3;
                if (sequence.length() != 546) {
                    System.out.println(name);
                    if (exonspecial.contains(name)) {
                        int index = 270;
                        if (name.startsWith("A")) {
                            index = sequence.indexOf("GTTCTCACACC");
                        } else if (name.startsWith("B")) {
                            index = sequence.indexOf("GGTCTCACA");
                        } else if (name.startsWith("C")) {
                            index = sequence.indexOf("GGTCTCAC");
                        } else if (name.startsWith("G")) {
                            index = sequence.indexOf("GTTCTCATACC");
                        } else if (name.startsWith("J")) {
                            index = sequence.indexOf("CGTATCACATCCTCC");
                        } else if (name.startsWith("K")) {
                            index = sequence.indexOf("GGTCTAACA");
                        } else if (name.startsWith("L")) {
                            index = sequence.indexOf("GTTCTCACACCATC");
                        }
                        if (index < 240 || index > 300) {
                            System.out.println("wrong boundary " + name);
                        } else {
                            System.out.println(index);
                            exon2 = sequence.substring(0, index);
                            exon3 = sequence.substring(index);
                            exon23 = String.valueOf(exon2) + "XXXXXXXXXX" + exon3;
                        }
                    }
                }
                fastaBuilder2.append(">").append(name).append("\n").append(exon2).append("\n");
                fastaBuilder3.append(">").append(name).append("\n").append(exon3).append("\n");
                fastaBuilder23.append(">").append(name).append("\n").append(exon23).append("\n");
                if (!seq2.containsKey(exon2)) {
                    seq2.put(exon2, new ArrayList());
                }
                if (!seq3.containsKey(exon3)) {
                    seq3.put(exon3, new ArrayList());
                }
                ((List)seq2.get(exon2)).add(name);
                ((List)seq3.get(exon3)).add(name);
            }
            ++i;
        }
        String amb2 = CreateExon23Amb.creatAmbData(seq2);
        String amb3 = CreateExon23Amb.creatAmbData(seq3);
        File f2 = new File(outputDir, String.valueOf(locusName) + "-exon2-hap-amb.txt");
        File f3 = new File(outputDir, String.valueOf(locusName) + "-exon3-hap-amb.txt");
        File fa2 = new File(outputDir, String.valueOf(locusName) + "-exon2.fa");
        File fa3 = new File(outputDir, String.valueOf(locusName) + "-exon3.fa");
        File fa23 = new File(outputDir, String.valueOf(locusName) + "-exon23.fa");
        FileManager.writeTextFile(f2, amb2, true);
        FileManager.writeTextFile(f3, amb3, true);
        FileManager.writeTextFile(fa2, fastaBuilder2.toString(), true);
        FileManager.writeTextFile(fa3, fastaBuilder3.toString(), true);
        FileManager.writeTextFile(fa23, fastaBuilder23.toString(), true);
    }

    private static String creatAmbData(Map<String, List<String>> seq) {
        StringBuilder builder = new StringBuilder();
        for (String s : seq.keySet()) {
            List<String> names = seq.get(s);
            if (names.size() <= 1) continue;
            builder.append(names.get(0)).append("R").append("\t");
            for (String name : names) {
                builder.append(name).append("\t");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private static File organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        tmpFn.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    builder.append(lines[i].trim()).append("\n");
                    builder.append(sequence).append("\n");
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        builder.append(">").append(gname).append("\n");
                        builder.append(sequence).append("\n");
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        return tmpFn;
    }

    private static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }
}

