/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import misc.FileManager;
import misc.SystemCommand;

public class ConvertIlluminaDataToFastq {
    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        File IlluminaFile = new File(args[0]);
        File OutputFile = new File(args[1]);
        int limit = new Integer(args[2]);
        BufferedReader reader = new BufferedReader(new FileReader(IlluminaFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(OutputFile));
        try {
            block6: {
                String line;
                int count;
                block5: {
                    count = 0;
                    if (!true) break block5;
                    line = reader.readLine();
                    if (line == null) return;
                    if (count >= limit) break block6;
                }
                do {
                    String[] info = line.split("\\s+");
                    String sequence = info[8].trim();
                    String qualityChars = info[9].trim();
                    String name = String.valueOf(IlluminaFile.getName().substring(0, 11)) + info[4].trim() + "-" + info[5].trim();
                    writer.write("@");
                    writer.write(name);
                    writer.newLine();
                    writer.write(sequence);
                    writer.newLine();
                    writer.write("+");
                    writer.newLine();
                    writer.write(qualityChars);
                    writer.newLine();
                    ++count;
                    line = reader.readLine();
                    if (line == null) return;
                } while (count < limit);
            }
            return;
        }
        finally {
            reader.close();
            writer.flush();
            writer.close();
        }
    }

    private static void writePhdFile(File phdDir, String name, String sequence, String qualityChars) throws Exception {
        File tmpFile = File.createTempFile("chromat", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence);
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/local/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        int beginDNA = 0;
        int endDNA = 0;
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        out.append("BEGIN_SEQUENCE " + name);
        i = 1;
        while (i <= beginDNA) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            if (!info[0].equals(new String("."))) {
                out.append(info[0]).append(" ");
            } else {
                out.append("n").append(" ");
            }
            char quality = qualityChars.charAt(i - beginDNA - 1);
            out.append(quality - 64).append(" ");
            out.append(info[2]).append("\n");
            ++i;
        }
        i = endDNA;
        while (i < data.length) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        FileManager.writeTextFile(phdFile, out.toString(), true);
        phdFile.renameTo(new File(phdDir, String.valueOf(name) + ".phd.1"));
        FileManager.delete(tmpFile);
    }

    private static File makeDirs(File outputRoot) {
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }
}

