/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import misc.FileManager;
import misc.SystemCommand;

public class ConvertFastaqToFasta {
    public static void main(String[] args) throws Exception {
        File IlluminaFile = new File(args[0]);
        File OutputFile = new File(args[1]);
        int limit = new Integer(args[2]);
        int offset = new Integer(args[3]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void covert(File IlluminaFile, File OutputFastaFile, File outputQualityFile, int limit, int offset) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(IlluminaFile));
        BufferedWriter fastaWriter = new BufferedWriter(new FileWriter(OutputFastaFile));
        BufferedWriter qualityWriter = new BufferedWriter(new FileWriter(outputQualityFile));
        try {
            block16: {
                String line;
                boolean isSeq;
                String qualityChars;
                String sequence;
                String name;
                int lineCount;
                int count;
                block15: {
                    count = 0;
                    lineCount = 0;
                    name = null;
                    sequence = null;
                    qualityChars = null;
                    isSeq = false;
                    if (!true) break block15;
                    line = reader.readLine();
                    if (line == null) return;
                    if (count >= limit) break block16;
                }
                do {
                    if (lineCount < offset * 4) {
                        ++lineCount;
                    } else {
                        if (line.startsWith("@Barcode")) {
                            name = line.trim().substring(1);
                            isSeq = true;
                        } else if (line.trim().equals("+")) {
                            isSeq = false;
                        } else if (isSeq) {
                            sequence = line.trim();
                        } else {
                            qualityChars = line.trim();
                        }
                        if (name != null && sequence != null && qualityChars != null) {
                            fastaWriter.write(">");
                            fastaWriter.write(name);
                            fastaWriter.newLine();
                            fastaWriter.write(sequence);
                            fastaWriter.newLine();
                            qualityWriter.write(">");
                            qualityWriter.write(name);
                            qualityWriter.newLine();
                            qualityWriter.write(ConvertFastaqToFasta.translateQuality(qualityChars));
                            qualityWriter.newLine();
                            name = null;
                            sequence = null;
                            qualityChars = null;
                            ++count;
                        }
                        if (count > limit) {
                            return;
                        }
                    }
                    line = reader.readLine();
                    if (line == null) return;
                } while (count < limit);
            }
            return;
        }
        finally {
            reader.close();
            fastaWriter.flush();
            fastaWriter.close();
            qualityWriter.flush();
            qualityWriter.close();
        }
    }

    private static String translateQuality(String qualityChars) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < qualityChars.length()) {
            int quality = qualityChars.charAt(i) - 33;
            ret.append(quality).append(" ");
            ++i;
        }
        return ret.toString().trim();
    }

    private static void writePhdFile(File phdDir, String name, String sequence, String qualityChars) throws Exception {
        File tmpFile = File.createTempFile("chromat", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence);
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/local/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        int beginDNA = 0;
        int endDNA = 0;
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        out.append("BEGIN_SEQUENCE " + name);
        i = 1;
        while (i <= beginDNA) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            if (!info[0].equals(new String("."))) {
                out.append(info[0]).append(" ");
            } else {
                out.append("n").append(" ");
            }
            char quality = qualityChars.charAt(i - beginDNA - 1);
            out.append(quality - 64).append(" ");
            out.append(info[2]).append("\n");
            ++i;
        }
        i = endDNA;
        while (i < data.length) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        FileManager.writeTextFile(phdFile, out.toString(), true);
        phdFile.renameTo(new File(phdDir, String.valueOf(name) + ".phd.1"));
        FileManager.delete(tmpFile);
    }

    private static File makeDirs(File outputRoot) {
        File phdDir = new File(outputRoot, "phd_dir");
        File assemblyDir = new File(outputRoot, "assembly");
        File chromatDir = new File(outputRoot, "chromat_dir");
        if (!phdDir.isDirectory()) {
            phdDir.mkdirs();
        }
        if (!assemblyDir.isDirectory()) {
            assemblyDir.mkdirs();
        }
        if (!chromatDir.isDirectory()) {
            chromatDir.mkdirs();
        }
        return phdDir;
    }
}

