/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.BatchConvertFastaQdataMiSeq;
import fileOperation.ConvertFastaToPhds;
import java.io.File;
import java.util.Arrays;
import misc.FileManager;
import misc.SystemCommand;

public class ConvertFastaToPhdsWraper {
    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File outputRoot = new File(args[1]);
        File vectorFn = new File(args[2]);
        Object[] fastaFiles = fastaDir.listFiles();
        Arrays.sort(fastaFiles);
        Object[] objectArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object fastaFile = objectArray[n2];
            if (((File)fastaFile).getName().endsWith(".fa")) {
                System.out.println("--- " + ((File)fastaFile).getName());
                String name = ConvertFastaToPhdsWraper.generateName(((File)fastaFile).getName());
                File forsmidDir = new File(outputRoot, name);
                File vector = new File(forsmidDir, "vector.seq");
                FileManager.copyFile(vectorFn, vector, true);
                File fastaOutput = new File(forsmidDir, "fasta");
                File phdOutput = new File(forsmidDir, "phd_dir");
                File assembly = new File(forsmidDir, "assembly");
                if (!assembly.exists() || !assembly.isDirectory()) {
                    assembly.mkdirs();
                }
                String cmd = "rm " + phdOutput.getAbsolutePath() + "/NODE_*";
                String[] commandArray = new String[]{"bash", "-c", cmd};
                SystemCommand command = new SystemCommand(commandArray, null, true);
                command.makeItSo();
                if (fastaOutput.exists()) {
                    cmd = "rm " + fastaOutput.getAbsolutePath() + "/*";
                    String[] commandArray3 = new String[]{"bash", "-c", cmd};
                    command = new SystemCommand(commandArray3, null, true);
                    command.makeItSo();
                }
                cmd = "rm " + assembly.getAbsolutePath() + "/*";
                String[] commandArray2 = new String[]{"bash", "-c", cmd};
                command = new SystemCommand(commandArray2, null, true);
                command.makeItSo();
                ConvertFastaToPhds.convert((File)fastaFile, fastaOutput, phdOutput);
                System.out.println("phredPhrap...");
                BatchConvertFastaQdataMiSeq.runCmd("/genome/bin/phredPhrap -minmatch 100", assembly);
            }
            ++n2;
        }
    }

    private static String generateName(String name) {
        String tname = name.replaceAll("_contigs.fa", "");
        tname = tname.substring(0, tname.length() - 3);
        return tname;
    }
}

