/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.HashMap;
import misc.FileManager;
import misc.SystemCommand;

public class ConvertFastaToPhds {
    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File fastaRoot = new File(args[1]);
        File phdRoot = new File(args[2]);
        ConvertFastaToPhds.convert(fastaFile, fastaRoot, phdRoot);
    }

    public static void convert(File fastaFile, File fastaRoot, File phdRoot) {
        if (!fastaRoot.exists() || !fastaRoot.isDirectory()) {
            fastaRoot.mkdirs();
        }
        if (!phdRoot.exists() || !phdRoot.isDirectory()) {
            phdRoot.mkdirs();
        }
        ConvertFastaToPhds.getFastas(fastaFile, fastaRoot);
        ConvertFastaToPhds.generatePhd(fastaRoot, phdRoot);
    }

    private static void generatePhd(File fastaRoot, File phdRoot) {
        File[] files;
        File[] fileArray = files = fastaRoot.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ConvertFastaToPhds.fasta2Phd(phdRoot, file);
            ++n2;
        }
    }

    public static void fasta2Phd(File phdRoot, File file) {
        String cmd = " " + file.getAbsolutePath();
        System.out.println(cmd);
        SystemCommand command = new SystemCommand("/usr/bin/perl /genome/bin/fasta2Phd.perl -quality 40 " + file.getAbsolutePath(), phdRoot, false);
        command.makeItSo();
    }

    private static void getFastas(File fastaFile, File fastaRoot) {
        HashMap backboneMap = new HashMap();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        String name = null;
        String sequence = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(">")) {
                String fullName;
                if (sequence == null) {
                    fullName = data.substring(1).trim();
                    name = String.valueOf(fullName.split("_")[0]) + "_" + fullName.split("_")[1];
                    sequence = ">" + name + "\n";
                } else {
                    FileManager.writeTextFile(new File(fastaRoot, name), sequence, true);
                    System.out.println(String.valueOf(data) + " " + name);
                    fullName = data.substring(1).trim();
                    name = String.valueOf(fullName.split("_")[0]) + "_" + fullName.split("_")[1];
                    sequence = ">" + name + "\n";
                }
            } else if (data.trim().length() > 0) {
                sequence = String.valueOf(sequence) + data.trim();
            }
            if (sequence != null) {
                FileManager.writeTextFile(new File(fastaRoot, name), sequence, true);
            }
            ++n2;
        }
    }
}

