/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ContentMapMatchStat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ContentMapping {
    static String LABEL = "-plate";
    static String EMPTY = "empty";

    public static void main(String[] args) throws Exception {
        File mapResultFn = new File(args[0]);
        File outputDir = new File(args[1]);
        List<ContentMapMatchStat> matches = ContentMapping.parseContentMap(mapResultFn);
        Map<String, Map<String, List<ContentMapMatchStat>>> matchesByNameProbe = ContentMapping.organizeMatchesByProbe(matches);
        Map<String, Map<String, List<ContentMapMatchStat>>> matchesByNameWell = ContentMapping.organizeMatchesByWell(matches);
        for (String gName : matchesByNameProbe.keySet()) {
            File fn = new File(outputDir, String.valueOf(gName) + ".csv");
            ContentMapping.generateOutput(fn, matchesByNameProbe.get(gName), matchesByNameWell.get(gName));
        }
    }

    private static void generateOutput(File fn, Map<String, List<ContentMapMatchStat>> probeMap, Map<String, List<ContentMapMatchStat>> wellMap) {
        StringBuilder outputBuilder = new StringBuilder();
        HashMap<String, StringBuilder> lines = new HashMap<String, StringBuilder>();
        for (String well : wellMap.keySet()) {
            StringBuilder lineBuilder = new StringBuilder();
            lineBuilder.append(well).append(",");
            lines.put(well, lineBuilder);
        }
        outputBuilder.append("Sample").append(",");
        Object[] names = probeMap.keySet().toArray();
        Arrays.sort(names);
        Object[] objectArray = names;
        int n = names.length;
        int lineBuilder = 0;
        while (lineBuilder < n) {
            Object name = objectArray[lineBuilder];
            if (!name.equals(EMPTY)) {
                outputBuilder.append(name).append(",");
                for (String well : wellMap.keySet()) {
                    ((StringBuilder)lines.get(well)).append(ContentMapping.getEntry(wellMap.get(well), (String)name)).append(",");
                }
            }
            ++lineBuilder;
        }
        outputBuilder.append("\n");
        Object[] names2 = wellMap.keySet().toArray();
        Arrays.sort(names2);
        Object[] objectArray2 = names2;
        int n2 = names2.length;
        n = 0;
        while (n < n2) {
            Object name = objectArray2[n];
            outputBuilder.append((CharSequence)lines.get(name)).append("\n");
            ++n;
        }
        FileManager.writeTextFile(fn, outputBuilder.toString(), true);
    }

    private static String getEntry(List<ContentMapMatchStat> stats, String probe) {
        for (ContentMapMatchStat stat : stats) {
            if (stat.getProbe() == null || !stat.getProbe().equals(probe)) continue;
            return ContentMapping.formatStat(stat);
        }
        return " ";
    }

    private static String formatStat(ContentMapMatchStat stat) {
        return "(" + stat.getMismatch() + ")" + stat.getCount() + "(" + stat.getSharedCount() + ")";
    }

    private static Map<String, Map<String, List<ContentMapMatchStat>>> organizeMatchesByWell(List<ContentMapMatchStat> matches) {
        HashMap<String, Map<String, List<ContentMapMatchStat>>> matchesByNameProbe = new HashMap<String, Map<String, List<ContentMapMatchStat>>>();
        for (ContentMapMatchStat stat : matches) {
            if (!matchesByNameProbe.containsKey(stat.getGName())) {
                matchesByNameProbe.put(stat.getGName(), new HashMap());
            }
            if (!((Map)matchesByNameProbe.get(stat.getGName())).containsKey(stat.getWell())) {
                ((Map)matchesByNameProbe.get(stat.getGName())).put(stat.getWell(), new ArrayList());
            }
            ((List)((Map)matchesByNameProbe.get(stat.getGName())).get(stat.getWell())).add(stat);
        }
        return matchesByNameProbe;
    }

    private static Map<String, Map<String, List<ContentMapMatchStat>>> organizeMatchesByProbe(List<ContentMapMatchStat> matches) {
        HashMap<String, Map<String, List<ContentMapMatchStat>>> matchesByNameProbe = new HashMap<String, Map<String, List<ContentMapMatchStat>>>();
        for (ContentMapMatchStat stat : matches) {
            if (!matchesByNameProbe.containsKey(stat.getGName())) {
                matchesByNameProbe.put(stat.getGName(), new HashMap());
                ((Map)matchesByNameProbe.get(stat.getGName())).put(EMPTY, new ArrayList());
            }
            if (stat.getProbe() != null) {
                if (!((Map)matchesByNameProbe.get(stat.getGName())).containsKey(stat.getProbe())) {
                    ((Map)matchesByNameProbe.get(stat.getGName())).put(stat.getProbe(), new ArrayList());
                }
                ((List)((Map)matchesByNameProbe.get(stat.getGName())).get(stat.getProbe())).add(stat);
                continue;
            }
            ((List)((Map)matchesByNameProbe.get(stat.getGName())).get(EMPTY)).add(stat);
        }
        return matchesByNameProbe;
    }

    private static List<ContentMapMatchStat> parseContentMap(File mapResultFn) {
        ArrayList<ContentMapMatchStat> matches = new ArrayList<ContentMapMatchStat>();
        String[] data = FileManager.readTextFile(mapResultFn).split("\n");
        ContentMapMatchStat stat = null;
        int i = 1;
        while (i < data.length) {
            String line = data[i];
            String[] items = line.trim().split("\t");
            String gName = items[0].split(LABEL)[0];
            stat = items.length == 1 ? new ContentMapMatchStat(items[0], gName, null, 0, 0, 0.0f, 0) : new ContentMapMatchStat(items[0], gName, items[1], Integer.valueOf(items[2]), Integer.valueOf(items[5]), Float.valueOf(items[3]).floatValue(), Integer.valueOf(items[4]));
            matches.add(stat);
            ++i;
        }
        return matches;
    }
}

