/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class CollectBgene {
    private static int MATCH_CHUNK_MIN_SIZE = 50;
    private static int MATCH_CHUNK_MAX_DISCREP = 15;
    private static double MATCH_CHUNK_HIT_DISCREP = 5.0;
    private static int MATCH_CHUNK_REQUIRED = 5;

    public static void main(String[] args) throws Exception {
        File seqFile = new File(args[0]);
        File matchFile = new File(args[1]);
        File newSeqDir = new File(args[2]);
        File oldLogFile = new File(args[3]);
        File newLogFile = new File(args[4]);
        Map<String, Integer> hits = CollectBgene.parseMatch(matchFile);
        CollectBgene.output(seqFile, oldLogFile, hits, newSeqDir, newLogFile);
    }

    private static void output(File seqFile, File oldLogFile, Map<String, Integer> hits, File newSeqDir, File newLogFile) throws Exception {
        String[] lines;
        StringBuilder outSeq = new StringBuilder();
        StringBuilder outLog = new StringBuilder();
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        Map<String, String> sequences = CollectBgene.getSequenceFromFasta(seqFile);
        HashMap sequencesByAnimal = new HashMap();
        String[] stringArray = lines = FileManager.readTextFile(oldLogFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split(",");
            String name = String.valueOf(items[4].trim()) + "-" + items[2].trim();
            if (hits.containsKey(name)) {
                data.put(name, String.valueOf(line.trim()) + "," + hits.get(name));
                if (hits.get(name) >= MATCH_CHUNK_REQUIRED) {
                    String aname = name.split("-")[0];
                    if (!sequencesByAnimal.containsKey(aname)) {
                        sequencesByAnimal.put(aname, new ArrayList());
                    }
                    ((List)sequencesByAnimal.get(aname)).add(CollectBgene.createEntry(sequences, name));
                }
            } else {
                data.put(name, String.valueOf(line.trim()) + "," + 0);
            }
            ++n2;
        }
        for (String line : data.values()) {
            outLog.append(line).append("\n");
        }
        FileManager.writeTextFile(newLogFile, outLog.toString(), true);
        for (String aname : sequencesByAnimal.keySet()) {
            File newFile = new File(newSeqDir, String.valueOf(aname) + ".fa");
            FileManager.writeTextFile(newFile, CollectBgene.collectData((List)sequencesByAnimal.get(aname)), true);
        }
    }

    private static String collectData(List<String> list) {
        StringBuilder ret = new StringBuilder();
        for (String item : list) {
            ret.append(item);
        }
        return ret.toString();
    }

    private static String createEntry(Map<String, String> sequences, String name) {
        StringBuilder ret = new StringBuilder();
        ret.append(">").append(name).append("\n");
        ret.append(sequences.get(name)).append("\n");
        return ret.toString();
    }

    public static Map<String, String> getSequenceFromFasta(File fastaFile) throws Exception {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static Map<String, Integer> parseMatch(File matchFile) {
        String[] lines;
        HashMap<String, Integer> hits = new HashMap<String, Integer>();
        String[] stringArray = lines = FileManager.readTextFile(matchFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf("gi|115345336|ref|NM_001048245.1") >= 0) {
                String[] items = line.trim().split("\\s+");
                String name = items[8];
                if (items[8].equals("C")) {
                    name = items[9];
                }
                if (CollectBgene.isGoodMatch(items)) {
                    if (!hits.containsKey(name)) {
                        hits.put(name, 0);
                    }
                    hits.put(name, (Integer)hits.get(name) + 1);
                }
            }
            ++n2;
        }
        return hits;
    }

    private static boolean isGoodMatch(String[] items) {
        double del;
        double ins;
        int score = new Integer(items[0]);
        double sub = new Double(items[1]);
        double diff = sub + (ins = new Double(items[2]).doubleValue()) + (del = new Double(items[3]).doubleValue());
        if (diff < MATCH_CHUNK_HIT_DISCREP) {
            return true;
        }
        return diff < (double)MATCH_CHUNK_MAX_DISCREP && score >= MATCH_CHUNK_MIN_SIZE;
    }
}

