/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.StringMatch;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class BatchStringSearch {
    static int BASE = 33;
    static String COPY = "GC";
    static int MIN_POS = 80;
    static int MAX_NEG = 25;
    private static final String N_RESULT = "?";
    private static final String POSITIVE = "+";
    private static final String NEGATIVE = "-";

    public static void main(String[] args) throws Exception {
        File fastaqFileDir = new File(args[0]);
        File kirSeqFile = new File(args[1]);
        File pnDeterminSiteFile = new File(args[2]);
        File output = new File(args[3]);
        boolean isForCopyOnly = new Boolean(args[4]);
        Object[] fastaFiles = fastaqFileDir.listFiles();
        Arrays.sort(fastaFiles);
        Map<String, String> geneKeySiteMap = BatchStringSearch.parseGeneKeySiteFile(pnDeterminSiteFile);
        LinkedHashMap<String, Map<String, List<Integer>>> overallResult = new LinkedHashMap<String, Map<String, List<Integer>>>();
        Object[] objectArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object fastaFile = objectArray[n2];
            if (!((File)fastaFile).getName().endsWith("fa")) {
                System.out.println("Skip " + ((File)fastaFile).getName());
            } else if (isForCopyOnly && !BatchStringSearch.isCopyFile(((File)fastaFile).getName())) {
                System.out.println("Skip " + ((File)fastaFile).getName());
            } else {
                System.out.println(((File)fastaFile).getName());
                StringMatch.match((File)fastaFile, kirSeqFile, overallResult);
            }
            ++n2;
        }
        BatchStringSearch.writeOutput(overallResult, output, geneKeySiteMap, isForCopyOnly);
    }

    private static boolean isCopyFile(String name) {
        System.out.println(String.valueOf(name) + " " + name.indexOf("GC"));
        return name.endsWith("fa") && name.toUpperCase().indexOf(COPY) > 0;
    }

    private static Map<String, String> parseGeneKeySiteFile(File pnDeterminSiteFile) {
        String[] lines;
        LinkedHashMap<String, String> geneKeySiteMap = new LinkedHashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(pnDeterminSiteFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            geneKeySiteMap.put(line.trim().split("\\s+")[0], line.trim().split("\\s+")[1]);
            ++n2;
        }
        return geneKeySiteMap;
    }

    private static void writeOutput(Map<String, Map<String, List<Integer>>> overallResult, File output, Map<String, String> geneKeySiteMap, boolean isForCopyOnly) {
        StringBuilder note = new StringBuilder();
        ArrayList<String> name = new ArrayList<String>();
        for (String sample : overallResult.keySet()) {
            Map<String, List<Integer>> result = overallResult.get(sample);
            if (name.size() == 0) {
                note.append("cellLine");
                for (String genes : result.keySet()) {
                    name.add(genes);
                    note.append("\t").append(genes);
                }
                note.append("\n");
            }
            note.append(sample);
            for (String genes : result.keySet()) {
                note.append("\t");
                note.append(BatchStringSearch.calculateAverage(result.get(genes)));
            }
            note.append("\n");
        }
        FileManager.writeTextFile(output, note.toString(), true);
        if (!isForCopyOnly) {
            StringBuilder note2 = new StringBuilder();
            name = new ArrayList();
            File summaryPnFile = new File(String.valueOf(output.getAbsolutePath()) + ".summary");
            for (String sample : overallResult.keySet()) {
                Map<String, List<Integer>> result = overallResult.get(sample);
                if (name.size() == 0) {
                    note2.append("cellLine");
                    for (String genes : geneKeySiteMap.keySet()) {
                        name.add(genes);
                        note2.append("\t").append(genes);
                    }
                    note2.append("\n");
                }
                note2.append(sample);
                for (String genes : geneKeySiteMap.keySet()) {
                    note2.append("\t");
                    if (result.get(geneKeySiteMap.get(genes)) == null) {
                        System.out.println(String.valueOf(genes) + " ??? " + geneKeySiteMap.get(genes));
                        continue;
                    }
                    note2.append(BatchStringSearch.calculatePn(result.get(geneKeySiteMap.get(genes))));
                }
                note2.append("\n");
            }
            FileManager.writeTextFile(summaryPnFile, note2.toString(), true);
        }
    }

    private static String calculatePn(List<Integer> counts) {
        int total = 0;
        for (Integer count : counts) {
            total += count.intValue();
        }
        int ave = total / counts.size();
        if (ave <= MAX_NEG) {
            return NEGATIVE;
        }
        if (ave >= MIN_POS) {
            return POSITIVE;
        }
        return N_RESULT;
    }

    private static Object formatCount(List<Integer> list) {
        String out = "(";
        for (Integer count : list) {
            out = String.valueOf(out) + count;
            out = String.valueOf(out) + ", ";
        }
        return String.valueOf(out) + ")";
    }

    private static Object calculateAverage(List<Integer> list) {
        int total = 0;
        for (Integer count : list) {
            total += count.intValue();
        }
        return total / list.size();
    }

    private static String generateDirName(String name) {
        return name.split("\\.")[0];
    }
}

