/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.InputStream;
import misc.FileManager;

public class BatchFastaTrimX {
    public static void main(String[] args) throws Exception {
        File[] fastaFiles;
        File fastaFileDir = new File(args[0]);
        File[] fileArray = fastaFiles = fastaFileDir.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (!fastaFile.getName().endsWith("fa")) {
                System.out.println("Skip " + fastaFile.getName());
            } else {
                BatchFastaTrimX.fixSequenceFromFasta(fastaFile);
            }
            ++n2;
        }
    }

    public static void fixSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        StringBuilder out = new StringBuilder();
        out.append(lines[0].trim()).append("\n");
        out.append(seq.toString().replaceAll("X", ""));
        FileManager.writeTextFile(fasta, out.toString(), true);
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateFileName(String name) {
        return String.valueOf(name.split("\\.")[0]) + "_contigs.fa";
    }
}

