/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class BatchFastaCleanup2 {
    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        boolean doSplit = new Boolean(args[1]);
        File outputFile = new File(args[2]);
        BatchFastaCleanup2.fixSequenceFromFasta(fastaFile, doSplit, outputFile);
    }

    public static void fixSequenceFromFasta(File fasta, boolean doSplit, File outputFile) {
        Map<String, String> sequences = BatchFastaCleanup2.getSequences(fasta);
        LinkedHashMap<String, String> newsequences = new LinkedHashMap<String, String>();
        for (String name : sequences.keySet()) {
            String sequence = sequences.get(name);
            if (doSplit) {
                if (sequence.indexOf("XXXXXXXXXX") > 20) {
                    int i = sequence.indexOf("XXXXXXXXXX");
                    String sequence1 = sequence.substring(0, i).replaceAll("X", "");
                    String sequence2 = sequence.substring(i).replaceAll("X", "");
                    newsequences.put(String.valueOf(name) + "a", sequence1);
                    newsequences.put(String.valueOf(name) + "b", sequence2);
                    continue;
                }
                newsequences.put(name, sequence.replaceAll("X", ""));
                continue;
            }
            newsequences.put(name, sequence.replaceAll("X", ""));
        }
        StringBuilder seq = new StringBuilder();
        for (String name : newsequences.keySet()) {
            if (((String)newsequences.get(name)).length() < 5000) continue;
            seq.append(">").append(name).append("\n");
            seq.append((String)newsequences.get(name)).append("\n");
        }
        FileManager.writeTextFile(outputFile, seq.toString(), true);
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = BatchFastaCleanup2.getSeq(i + 1, lines);
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static String getSeq(int index, String[] lines) {
        StringBuilder seq = new StringBuilder();
        int i = index;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) {
                return seq.toString();
            }
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateFileName(String name) {
        return String.valueOf(name.split("\\.")[0]) + "_contigs.fa";
    }
}

