/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.InputStream;
import misc.FileManager;

public class BatchFastaCleanup {
    public static void main(String[] args) throws Exception {
        File[] fastaFiles;
        File fastaFileDir = new File(args[0]);
        File[] fileArray = fastaFiles = fastaFileDir.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastaFile = fileArray[n2];
            if (!fastaFile.getName().endsWith("fa")) {
                System.out.println("Skip " + fastaFile.getName());
            } else {
                BatchFastaCleanup.fixSequenceFromFasta(fastaFile);
            }
            ++n2;
        }
    }

    public static void fixSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        String sequence = seq.toString();
        if (sequence.indexOf("XXXXXXXXXX") > 20) {
            int i2 = sequence.indexOf("XXXXXXXXXX");
            String sequence1 = sequence.substring(0, i2);
            String sequence2 = sequence.substring(i2);
            StringBuilder out1 = new StringBuilder();
            out1.append(String.valueOf(lines[0].trim()) + "-1").append("\n");
            out1.append(sequence1.replaceAll("X", ""));
            StringBuilder out2 = new StringBuilder();
            out2.append(String.valueOf(lines[0].trim()) + "-2").append("\n");
            out2.append(sequence2.replaceAll("X", ""));
            FileManager.writeTextFile(new File(fasta.getParentFile(), String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 3)) + "-1.fa"), out1.toString(), true);
            FileManager.writeTextFile(new File(fasta.getParentFile(), String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 3)) + "-2.fa"), out2.toString(), true);
            fasta.delete();
        } else {
            StringBuilder out = new StringBuilder();
            out.append(lines[0].trim()).append("\n");
            out.append(seq.toString().replaceAll("X", ""));
            FileManager.writeTextFile(fasta, out.toString(), true);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String generateFileName(String name) {
        return String.valueOf(name.split("\\.")[0]) + "_contigs.fa";
    }
}

