/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import dataFix.ChromatVO;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import misc.FileManager;

public class RenameExperiments {
    public static void main(String[] args) {
        File rootDir = new File(args[0]);
        File renameFile = new File(args[1]);
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            RenameExperiments.startRename(renameFile, rootDir, srcDB);
            RenameExperiments.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void startRename(File renameFile, File rootDir, Connection srcDB) {
        String[] info = FileManager.readTextFile(renameFile).split("\n");
        String[] items = null;
        String[] stringArray = info;
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            items = line.split("\t");
            RenameExperiments.collectAndRenameCellLine(items, new File(rootDir, items[0]), rootDir, srcDB);
            ++n2;
        }
    }

    private static void collectAndRenameCellLine(String[] items, File chromatDir, File rootDir, Connection srcDB) {
        PreparedStatement preparedStatement = null;
        String selectSql = "select chromat_id from pcr.plate_coord where experiment_id =? and coordinate=?";
        File[] chromats = chromatDir.listFiles();
        String name = null;
        String coord = null;
        String newName = null;
        String newId = null;
        File[] fileArray = chromats;
        int n = chromats.length;
        int n2 = 0;
        while (n2 < n) {
            File chromat = fileArray[n2];
            name = chromat.getName();
            coord = name.split("_")[1].split("\\.")[0];
            try {
                preparedStatement = srcDB.prepareStatement(selectSql);
                preparedStatement.setString(1, items[3].trim());
                preparedStatement.setString(2, coord);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    newId = resultSet.getString(1);
                    newName = String.valueOf(newId) + "_" + coord + ".ab1";
                    chromat.renameTo(new File(chromatDir, newName));
                    System.out.println(String.valueOf(name) + " -> " + newName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        String[] parsed = chromatDir.getName().split("_");
        String newDirName = String.valueOf(parsed[0]) + "_" + items[3].trim() + "_" + parsed[2] + "_" + parsed[3];
        System.out.println(String.valueOf(chromatDir.getName()) + " dir -> " + newDirName);
        chromatDir.renameTo(new File(rootDir, newDirName));
    }

    private static String getClId(String name, Connection srcDB) throws SQLException {
        String selectSql = "select cell_line_id from core.cell_line where local_name =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, name);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    private static void updateName(List<ChromatVO> chromats, String[] items, Connection srcDB) throws SQLException {
        String updateSql = "update pcr.chromat_report_mv set cell_line_id=?, cell_line_name=? where chromat_id =?";
        PreparedStatement preparedStatement = null;
        Object newName = null;
        for (ChromatVO chromatVO : chromats) {
            System.out.println(String.valueOf(chromatVO.getCellLineName()) + " -> " + items[2].trim());
            preparedStatement = srcDB.prepareStatement(updateSql);
            preparedStatement.setString(1, RenameExperiments.getClId(items[2].trim(), srcDB));
            preparedStatement.setString(2, items[2].trim());
            preparedStatement.setString(3, chromatVO.getId());
            preparedStatement.executeUpdate();
        }
        RenameExperiments.closeResources(null, preparedStatement, null);
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

