/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import dataFix.ChromatVO;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import misc.FileManager;

public class RenameCelllineByTable {
    public static void main(String[] args) {
        File renameFile = new File(args[0]);
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            srcDB.setAutoCommit(false);
            RenameCelllineByTable.startRename(renameFile, srcDB);
            srcDB.commit();
            RenameCelllineByTable.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void startRename(File renameFile, Connection srcDB) {
        String[] info = FileManager.readTextFile(renameFile).split("\n");
        String[] items = null;
        String[] stringArray = info;
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                items = line.split(",");
                System.out.println(line);
                RenameCelllineByTable.rename(items, srcDB);
            }
            ++n2;
        }
    }

    private static List<ChromatVO> getChromats(String[] items, Connection srcDB) {
        PreparedStatement preparedStatement = null;
        ArrayList<ChromatVO> chromats = new ArrayList<ChromatVO>();
        String wrongAmpliconName = items[0].trim();
        String clName = items[1].trim();
        String coord = items[2].trim();
        String correctAmpliconName = items[3].trim();
        String selectSql = "select chromat_id, seq_primer_name from pcr.chromat_report_mv where cell_line_name = ? and amplicon_name = ? AND coordinate = ?";
        try {
            preparedStatement = srcDB.prepareStatement(selectSql);
            preparedStatement.setString(1, clName);
            preparedStatement.setString(2, wrongAmpliconName);
            preparedStatement.setString(3, coord);
            ResultSet resultSet = preparedStatement.executeQuery();
            ChromatVO chromatVO = null;
            while (resultSet.next()) {
                chromatVO = new ChromatVO();
                chromatVO.setId(resultSet.getString(1));
                RenameCelllineByTable.setCorrectAmplicon(chromatVO, correctAmpliconName, srcDB);
                String wrongSeqPrimerName = resultSet.getString(2);
                if (wrongSeqPrimerName.endsWith("F")) {
                    chromatVO.setSequencingPrimerName(chromatVO.getForPrimerName());
                    chromatVO.setSequencingPrimerId(chromatVO.getForPrimerId());
                } else {
                    chromatVO.setSequencingPrimerName(chromatVO.getRevPrimerName());
                    chromatVO.setSequencingPrimerId(chromatVO.getRevPrimerId());
                }
                chromats.add(chromatVO);
            }
            System.out.println(String.valueOf(items[1]) + " " + chromats.size() + " - >" + items[2].trim());
            RenameCelllineByTable.closeResources(resultSet, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chromats;
    }

    private static void setCorrectAmplicon(ChromatVO chromatVO, String correctAmpliconName, Connection srcDB) throws Exception {
        String selectSql = "select amplicon_id, fwd_primer_id, rev_primer_id from pcr.amplicon where name =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, correctAmpliconName);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            chromatVO.setAmpliconId(resultSet.getString(1));
            chromatVO.setAmpliconName(correctAmpliconName);
            chromatVO.setForPrimerId(resultSet.getString(2));
            chromatVO.setForPrimerName(RenameCelllineByTable.getPrimerName(chromatVO.getForPrimerId(), srcDB));
            chromatVO.setRevPrimerId(resultSet.getString(3));
            chromatVO.setRevPrimerName(RenameCelllineByTable.getPrimerName(chromatVO.getRevPrimerId(), srcDB));
        }
    }

    private static void rename(String[] items, Connection srcDB) {
        PreparedStatement preparedStatement = null;
        String selectSql = "update pcr.chromat_report_mv set amplicon_id=?, amplicon_name = ?, fwd_primer_id = ?, fwd_primer_name=?, rev_primer_id=?, rev_primer_name=?, seq_primer_id=?, seq_primer_name=? where chromat_id = ?";
        try {
            List<ChromatVO> vos = RenameCelllineByTable.getChromats(items, srcDB);
            for (ChromatVO vo : vos) {
                System.out.println("update " + items[2] + "->" + vo.getAmpliconName() + " " + vo.getForPrimerName() + " " + vo.getRevPrimerName() + " " + vo.getSequencingPrimerName());
            }
            for (ChromatVO vo : vos) {
                preparedStatement = srcDB.prepareStatement(selectSql);
                preparedStatement.setString(1, vo.getAmpliconId());
                preparedStatement.setString(2, vo.getAmpliconName());
                preparedStatement.setString(3, vo.getForPrimerId());
                preparedStatement.setString(4, vo.getForPrimerName());
                preparedStatement.setString(5, vo.getRevPrimerId());
                preparedStatement.setString(6, vo.getRevPrimerName());
                preparedStatement.setString(7, vo.getSequencingPrimerId());
                preparedStatement.setString(8, vo.getSequencingPrimerName());
                preparedStatement.setString(9, vo.getId());
                preparedStatement.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getPrimerName(String id, Connection srcDB) throws SQLException {
        String selectSql = "select name from pcr.primer where primer_id =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, id);
        ResultSet resultSet = preparedStatement.executeQuery();
        String name = null;
        if (resultSet.next()) {
            name = resultSet.getString(1);
            if (resultSet.next()) {
                System.out.println("duplicate primer name " + name);
            }
        }
        RenameCelllineByTable.closeResources(resultSet, preparedStatement, null);
        if (name == null) {
            System.out.println("no primer name " + id);
        }
        return name;
    }

    private static String getClId(String name, Connection srcDB) throws SQLException {
        String selectSql = "select cell_line_id from core.cell_line where local_name =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, name);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    private static void updateName(List<ChromatVO> chromats, Connection srcDB) throws SQLException {
        String updateSql = "update pcr.chromat_report_mv set cell_line_id=?, cell_line_name=? where chromat_id=?";
        PreparedStatement preparedStatement = null;
        for (ChromatVO chromatVO : chromats) {
            preparedStatement = srcDB.prepareStatement(updateSql);
            preparedStatement.setString(1, chromatVO.getCellLineId());
            preparedStatement.setString(2, chromatVO.getCellLineName());
            preparedStatement.setString(3, chromatVO.getId());
            preparedStatement.executeUpdate();
        }
        RenameCelllineByTable.closeResources(null, preparedStatement, null);
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

