/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;

public class RenameBySS {
    private static final String UTF_8 = "UTF-8";

    public static void main(String[] args) {
        File[] files;
        File ssfolder = new File(args[0]);
        File destfolder = new File(args[1]);
        File chrfolder = new File(args[2]);
        File emptyChromat = new File(args[3]);
        if (!destfolder.exists() || !destfolder.isDirectory()) {
            destfolder.mkdirs();
        }
        File[] fileArray = files = ssfolder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (name.indexOf("txt") > 0) {
                File chromatDestDir = new File(destfolder, name.substring(0, name.length() - 4));
                if (!chromatDestDir.exists() || !chromatDestDir.isDirectory()) {
                    chromatDestDir.mkdir();
                }
                System.out.println("rename by " + name);
                RenameBySS.rename(file, chromatDestDir, chrfolder, emptyChromat);
            }
            ++n2;
        }
    }

    private static void rename(File sampleSheet, File chromatDestDir, File chrfolder, File emptyChromat) {
        String[] info = RenameBySS.readTextFile(sampleSheet).split("\n");
        if (info.length != 99) {
            System.out.println("wrong sample sheet format " + sampleSheet.getAbsolutePath());
        }
        File[] chromats = chrfolder.listFiles();
        Map<String, String> coordNames = RenameBySS.getNameMaps(info);
        for (String oldName : coordNames.keySet()) {
            boolean isFound = false;
            File[] fileArray = chromats;
            int n = chromats.length;
            int n2 = 0;
            while (n2 < n) {
                File chromat = fileArray[n2];
                String fName = chromat.getName();
                if (fName.startsWith(oldName)) {
                    File newFile = new File(chromatDestDir, coordNames.get(oldName));
                    RenameBySS.copyFile(chromat, newFile, true);
                    isFound = true;
                    break;
                }
                ++n2;
            }
            if (isFound) continue;
            System.out.println(" fake " + coordNames.get(oldName));
            File newFile = new File(chromatDestDir, coordNames.get(oldName));
            RenameBySS.copyFile(emptyChromat, newFile, true);
        }
    }

    public static String readTextFile(File src) {
        return RenameBySS.readAnyFile(src, true);
    }

    private static String readAnyFile(File src, boolean isTextOnly) {
        String data;
        block5: {
            FileChannel srcFileChannel = null;
            ByteBuffer byteBuffer = null;
            data = null;
            try {
                try {
                    srcFileChannel = new FileInputStream(src).getChannel();
                    byteBuffer = ByteBuffer.allocate((int)srcFileChannel.size());
                    srcFileChannel.read(byteBuffer);
                    data = new String(byteBuffer.array(), UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    RenameBySS.closeFileDestination(srcFileChannel);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                RenameBySS.closeFileDestination(srcFileChannel);
                throw throwable;
            }
            RenameBySS.closeFileDestination(srcFileChannel);
        }
        return data;
    }

    private static boolean isFileReadyForWrite(File dest, boolean isOverWrite) {
        if (dest.exists() && dest.isFile() && !isOverWrite) {
            return false;
        }
        if (!dest.getParentFile().isDirectory()) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }

    public static boolean copyFile(File src, File dest, boolean isOverWrite) {
        block7: {
            FileChannel srcFileChannel = null;
            FileChannel destFileChannel = null;
            if (!RenameBySS.isFileReadyForWrite(dest, isOverWrite)) {
                return false;
            }
            try {
                try {
                    if (!dest.exists()) {
                        dest.createNewFile();
                    }
                    srcFileChannel = new FileInputStream(src).getChannel();
                    destFileChannel = new FileOutputStream(dest).getChannel();
                    srcFileChannel.transferTo(0L, srcFileChannel.size(), destFileChannel);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    RenameBySS.closeFileDestination(srcFileChannel);
                    RenameBySS.closeFileDestination(destFileChannel);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                RenameBySS.closeFileDestination(srcFileChannel);
                RenameBySS.closeFileDestination(destFileChannel);
                throw throwable;
            }
            RenameBySS.closeFileDestination(srcFileChannel);
            RenameBySS.closeFileDestination(destFileChannel);
        }
        return true;
    }

    private static void closeFileDestination(FileChannel fileChannel) {
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Map<String, String> getNameMaps(String[] info) {
        HashMap<String, String> coordNames = new HashMap<String, String>();
        int i = 3;
        while (i < info.length) {
            String[] items = info[i].trim().split("\\s+");
            String coord = items[0].trim();
            String ssId = items[1].trim();
            if (ssId.trim().length() == 0 || ssId.trim().equals("Empty")) {
                coordNames.put("FAKE" + coord, String.valueOf(coord) + ".ab1");
            } else {
                String newName = String.valueOf(ssId) + "_" + coord + ".ab1";
                if (ssId.startsWith("___")) {
                    coordNames.put("FAKE" + ssId, newName);
                } else {
                    String[] fields = ssId.split("_");
                    String amplicon = fields[1].trim();
                    if (amplicon.equals("HLA-DRB1-Combine2")) {
                        amplicon = "DRB1-Combined";
                    } else if (amplicon.equals("HLA-DRB1-03")) {
                        amplicon = "DRB1-03";
                    } else if (amplicon.equals("HLA-DRB1-05")) {
                        amplicon = "DRB1-05";
                    } else if (amplicon.equals("HLA-DRB1-13")) {
                        amplicon = "DRB1-13";
                    } else if (amplicon.equals("HLA-DRB1-15")) {
                        amplicon = "DRB1-15";
                    } else if (amplicon.equals("HLA-DPA1")) {
                        amplicon = "DPA-M";
                    } else if (amplicon.equals("HLA-DPB1")) {
                        amplicon = "DPB-M";
                    }
                    String primer = fields[2].trim();
                    coordNames.put(String.valueOf(fields[0]) + "_" + amplicon + "_" + primer, newName);
                }
            }
            ++i;
        }
        return coordNames;
    }
}

