/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ImageFixer {
    private static final int IMG_SIDE = 502;

    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().endsWith("jpg") && !file.getName().endsWith("JPG")) {
                System.out.println("skip not JPG " + file.getName());
            } else {
                BufferedImage originalImage = ImageIO.read(file);
                if (Math.max(originalImage.getHeight(), originalImage.getWidth()) >= 502) {
                    System.out.println("skip size OK " + file.getName());
                } else {
                    System.out.println("resize " + file.getName());
                    BufferedImage resizedImage = ImageFixer.resizeImage(originalImage);
                    ImageIO.write((RenderedImage)resizedImage, "jpg", file);
                }
            }
            ++n2;
        }
    }

    private static BufferedImage resizeImage(BufferedImage originalImage) throws Exception {
        int height = originalImage.getHeight();
        int width = originalImage.getWidth();
        double factor = 502.0 / ((double)Math.max(height, width) * 1.0);
        int newHeight = new Double((double)height * factor).intValue();
        int newWidth = new Double((double)width * factor).intValue();
        System.out.println("factor = " + factor + ", new size " + newWidth + "X" + newHeight);
        BufferedImage resizedImage = new BufferedImage(newWidth, newHeight, originalImage.getType());
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, newWidth, newHeight, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return resizedImage;
    }
}

