/*
 * Decompiled with CFR 0.152.
 */
package aboTyping;

import aboTyping.Exon;
import aboTyping.Match;
import aboTyping.TypeSet;
import guid.IdentifierFactory;
import importChromat.ImportExternalChromats;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class generateRuleSet {
    public static void main(String[] args) throws Exception {
        String ruleSetId = args[0];
        File ruleSetDir = new File(args[1]);
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        File dipAmbiguityPrimerFile = new File(ruleSetDir, "DiploidAmbiguityResolving.txt");
        LinkedHashMap typeSets = new LinkedHashMap();
        Map<String, List<String>> diploidAmbPrimer = generateRuleSet.parseDiploidAmbPrimer(dipAmbiguityPrimerFile);
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            srcDB.setAutoCommit(false);
            generateRuleSet.insertDiploidAmbPrimers(diploidAmbPrimer, ruleSetId, srcDB);
            System.out.println("Done insert DiploidAmb ");
            srcDB.commit();
            ImportExternalChromats.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void insertDiploidAmbPrimers(Map<String, List<String>> diploidAmbPrimer, String ruleSetId, Connection srcDB) throws SQLException {
        for (String amb : diploidAmbPrimer.keySet()) {
            System.out.println(amb);
            String ambId = generateRuleSet.getAmbId(amb, ruleSetId, srcDB);
            if (ambId == null) {
                System.out.println("no record amb " + amb);
                continue;
            }
            for (String primer : diploidAmbPrimer.get(amb)) {
                System.out.println("\t" + primer);
                String primerId = generateRuleSet.getPrimerId(primer, srcDB);
                if (primerId == null) {
                    System.out.println("no record primer " + primer);
                    continue;
                }
                generateRuleSet.insertDiploidAmbPrimerRecord(ambId, primerId, srcDB);
            }
        }
    }

    private static void insertDiploidAmbPrimerRecord(String ambId, String primerId, Connection srcDB) {
        String dapId = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into genotype.diploid_ambiguity_primer (diploid_ambiguity_id, primer_id) values (?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, ambId);
            preparedStatement.setString(2, primerId);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getPrimerId(String primer, Connection srcDB) throws SQLException {
        String selectSql = "select primer_id from pcr.primer where name =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, primer);
        ResultSet resultSet = preparedStatement.executeQuery();
        String id = null;
        if (resultSet.next()) {
            id = resultSet.getString(1);
            if (resultSet.next()) {
                System.out.println("duplicate primer name " + primer);
            }
        }
        ImportExternalChromats.closeResources(null, preparedStatement, null);
        if (id == null) {
            System.out.println("no primer name " + primer);
        }
        return id;
    }

    private static String getAmbId(String amb, String rulesetid, Connection srcDB) throws SQLException {
        String selectSql = "select dap.diploid_ambiguity_id from genotype.diploid_ambiguous_pair dap join genotype.diploid_ambiguity da on dap.diploid_ambiguity_id=da.diploid_ambiguity_id where dap.name = ? and rule_set_id=?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, amb);
        preparedStatement.setString(2, rulesetid);
        ResultSet resultSet = preparedStatement.executeQuery();
        String id = null;
        if (resultSet.next()) {
            id = resultSet.getString(1);
            if (resultSet.next()) {
                System.out.println("duplicate amb name " + amb);
            }
        }
        ImportExternalChromats.closeResources(null, preparedStatement, null);
        if (id == null) {
            System.out.println("no amb name " + amb);
        }
        return id;
    }

    private static void insertDiploidAmb(List<List<String>> diploidAmb, String ruleSetId, Connection srcDB) {
        for (List<String> diList : diploidAmb) {
            String daId = generateRuleSet.insertDiploidAmbiguity(ruleSetId, srcDB);
            for (String pair : diList) {
                generateRuleSet.insertDiploidAmbPair(pair, daId, srcDB);
            }
        }
    }

    private static void insertDiploidAmbPair(String pair, String daId, Connection srcDB) {
        String dapId = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into genotype.diploid_ambiguous_pair (diploid_ambiguous_pair_id, diploid_ambiguity_id, name) values (?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, dapId);
            preparedStatement.setString(2, daId);
            preparedStatement.setString(3, pair.trim());
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String insertDiploidAmbiguity(String ruleSetId, Connection srcDB) {
        String daId = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into genotype.diploid_ambiguity (diploid_ambiguity_id, rule_set_id) values (?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, daId);
            preparedStatement.setString(2, ruleSetId);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return daId;
    }

    private static void insertRuleSetSnps(List<Match> ruleSetSnps, String ruleSetId, Connection srcDB) {
        for (Match match : ruleSetSnps) {
            generateRuleSet.insertRuleSetSnp(match, ruleSetId, srcDB);
        }
    }

    private static void insertRuleSetSnp(Match match, String ruleSetId, Connection srcDB) {
        String ruleSetSnpId = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into genotype.rule_set_snp (rule_set_snp_id, rule_set_id, position, genotype) values (?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, ruleSetSnpId);
            preparedStatement.setString(2, ruleSetId);
            preparedStatement.setInt(3, match.getPosition());
            preparedStatement.setString(4, match.getGenotype().substring(0, 1));
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertTypeSets(Map<String, TypeSet> typeSets, String ruleSetId, Connection srcDB) {
        String typeSetId = null;
        for (TypeSet typeSet : typeSets.values()) {
            typeSetId = generateRuleSet.insertTypeSet(typeSet, ruleSetId, srcDB);
            generateRuleSet.insertExons(typeSet.getExons(), typeSetId, srcDB);
            generateRuleSet.insertMatches(typeSet.getMatches(), typeSetId, srcDB);
        }
    }

    private static void insertMatches(List<Match> matches, String typeSetId, Connection srcDB) {
        if (matches == null) {
            return;
        }
        for (Match match : matches) {
            generateRuleSet.insertMatch(match, typeSetId, srcDB);
        }
    }

    private static void insertMatch(Match match, String typeSetId, Connection srcDB) {
        String matchId = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into genotype.match (match_id, genotype, type_set_id, not_match, position, match_type, deletion_count) values (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, matchId);
            preparedStatement.setString(2, match.getGenotype());
            preparedStatement.setString(3, typeSetId);
            preparedStatement.setBoolean(4, false);
            preparedStatement.setInt(5, match.getPosition());
            preparedStatement.setString(6, match.getMatchType());
            preparedStatement.setInt(7, match.getDeletionCount());
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertExons(List<Exon> exons, String typeSetId, Connection srcDB) {
        for (Exon exon : exons) {
            generateRuleSet.insertExon(exon, typeSetId, srcDB);
        }
    }

    private static void insertExon(Exon exon, String typeSetId, Connection srcDB) {
        String exonId = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into genotype.type_set_exon (type_set_exon_id, start_position_bb_seq, stop_position_bb_seq, align_param_gap_open, align_param_gap_extend, type_set_id, number, start_position_ale_seq, stop_position_ale_seq) values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            preparedStatement.setString(1, exonId);
            preparedStatement.setInt(2, exon.getBackboneStart());
            preparedStatement.setInt(3, exon.getBackboneEnd());
            preparedStatement.setInt(4, 4);
            preparedStatement.setInt(5, 3);
            preparedStatement.setString(6, typeSetId);
            preparedStatement.setInt(7, exon.getNumber());
            preparedStatement.setInt(8, exon.getAlleleStart());
            preparedStatement.setInt(9, exon.getAlleleEnd());
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String insertTypeSet(TypeSet typeSet, String ruleSetId, Connection srcDB) {
        String typeSetId = IdentifierFactory.createUniqueIdentifier().getId();
        String sql = "insert into genotype.type_set (type_set_id, name, rule_set_id, sequence, deprecated, disambiguous_name, locked) values (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = srcDB.prepareStatement(sql);
            System.out.println("typeSetId= " + typeSetId);
            preparedStatement.setString(1, typeSetId);
            System.out.println("typeSetName= " + typeSet.getName());
            preparedStatement.setString(2, typeSet.getName());
            System.out.println("ruleSetId= " + ruleSetId);
            preparedStatement.setString(3, ruleSetId);
            System.out.println("getSequence= " + typeSet.getSequence());
            preparedStatement.setString(4, typeSet.getSequence());
            preparedStatement.setBoolean(5, false);
            if (typeSet.getDisambiguousName() == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, typeSet.getDisambiguousName());
                System.out.println("getDisambiguousName= " + typeSet.getDisambiguousName());
            }
            preparedStatement.setBoolean(7, false);
            preparedStatement.executeUpdate();
            ImportExternalChromats.closeResources(null, preparedStatement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return typeSetId;
    }

    private static Map<String, List<String>> parseDiploidAmbPrimer(File dipAmbiguityPrimerFile) {
        String[] lines;
        HashMap<String, List<String>> diploidAmbPrimer = new HashMap<String, List<String>>();
        String[] stringArray = lines = FileManager.readTextFile(dipAmbiguityPrimerFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\t");
                String amb = items[0].trim();
                diploidAmbPrimer.put(amb, new ArrayList());
                int i = 1;
                while (i < items.length) {
                    ((List)diploidAmbPrimer.get(amb)).add(items[i].trim());
                    ++i;
                }
            }
            ++n2;
        }
        return diploidAmbPrimer;
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<String>> parseDiploidAmb(File dipAmbiguityFile) {
        void var4_7;
        String[] lines;
        ArrayList<List<String>> diploidAmb = new ArrayList<List<String>>();
        String[] stringArray = lines = FileManager.readTextFile(dipAmbiguityFile).split("\n");
        int n = lines.length;
        boolean n2 = false;
        while (var4_7 < n) {
            String line = stringArray[var4_7];
            if (line.trim().length() != 0) {
                String[] items;
                ArrayList<String> amb = new ArrayList<String>();
                String[] stringArray2 = items = line.trim().split("\t");
                int n3 = items.length;
                int n4 = 0;
                while (n4 < n3) {
                    String pair = stringArray2[n4];
                    amb.add(pair.trim());
                    ++n4;
                }
                diploidAmb.add(amb);
            }
            ++var4_7;
        }
        int i = 1;
        for (List list : diploidAmb) {
            System.out.print("amb pair " + i + "\t");
            for (String pair : list) {
                System.out.print(String.valueOf(pair) + "\t");
            }
            System.out.print("\n");
            ++i;
        }
        return diploidAmb;
    }

    private static List<Match> parseRuleSetSnp(File ruleSetSnpFile) {
        String[] lines;
        ArrayList<Match> ruleSetSnps = new ArrayList<Match>();
        Match match = null;
        String[] stringArray = lines = FileManager.readTextFile(ruleSetSnpFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\t");
                match = new Match(items[1].trim(), Integer.valueOf(items[0]), null, 0);
                ruleSetSnps.add(match);
            }
            ++n2;
        }
        for (Match match2 : ruleSetSnps) {
            System.out.println(String.valueOf(match2.getPosition()) + " - " + match2.getGenotype());
        }
        return ruleSetSnps;
    }

    private static void populateMatch(Map<String, TypeSet> typeSets, File matchFile) {
        String[] lines = FileManager.readTextFile(matchFile).split("\n");
        Match match = null;
        String name = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\t");
                name = items[0].trim();
                match = new Match(items[2].trim(), Integer.valueOf(items[1]), items[3].trim(), Integer.valueOf(items[4]));
                if (typeSets.get(name).getMatches() == null) {
                    typeSets.get(name).setMatches(new ArrayList<Match>());
                }
                typeSets.get(name).getMatches().add(match);
            }
            ++n2;
        }
        for (TypeSet typeSet : typeSets.values()) {
            System.out.println(String.valueOf(typeSet.getName()) + " match ");
            if (typeSet.getMatches() == null) {
                System.out.println(" no match ");
                continue;
            }
            for (Match e : typeSet.getMatches()) {
                System.out.println(String.valueOf(e.getPosition()) + " " + e.getGenotype() + " " + e.getMatchType() + " " + e.getDeletionCount());
            }
        }
    }

    private static void populateExon(Map<String, TypeSet> typeSets, File exonFile) {
        String[] lines = FileManager.readTextFile(exonFile).split("\n");
        Exon exon = null;
        String name = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\t");
                name = items[0].trim();
                exon = new Exon(Integer.valueOf(items[4]), Integer.valueOf(items[5]), Integer.valueOf(items[2]), Integer.valueOf(items[3]));
                exon.setNumber(Integer.valueOf(items[1]));
                if (typeSets.get(name).getExons() == null) {
                    typeSets.get(name).setExons(new ArrayList<Exon>());
                }
                typeSets.get(name).getExons().add(exon);
            }
            ++n2;
        }
        for (TypeSet typeSet : typeSets.values()) {
            System.out.println(String.valueOf(typeSet.getName()) + " exon ");
            for (Exon e : typeSet.getExons()) {
                System.out.println(String.valueOf(e.getNumber()) + " " + e.getAlleleStart() + " " + e.getAlleleEnd() + " " + e.getBackboneStart() + " " + e.getBackboneEnd());
            }
        }
    }

    private static void populateDisambName(Map<String, TypeSet> typeSets, File hapAmbiguityFile) {
        String[] lines = FileManager.readTextFile(hapAmbiguityFile).split("\n");
        HashMap<String, String> hapAmb = new HashMap<String, String>();
        String ambName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\t");
                ambName = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    if (items[i].trim().length() != 0) {
                        hapAmb.put(items[i].trim(), ambName.trim());
                    }
                    ++i;
                }
            }
            ++n2;
        }
        for (String type : hapAmb.keySet()) {
            System.out.println(String.valueOf(type) + " " + (String)hapAmb.get(type));
        }
        for (TypeSet typeSet : typeSets.values()) {
            if (!hapAmb.containsKey(typeSet.getName())) continue;
            typeSet.setDisambiguousName((String)hapAmb.get(typeSet.getName()));
            System.out.println("set ambname " + typeSet.getName() + " -> " + typeSet.getDisambiguousName());
        }
    }

    private static void populateSequence(Map<String, TypeSet> typeSets, File sequenceFile) {
        String[] lines = FileManager.readTextFile(sequenceFile).split("\n");
        TypeSet typeSet = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            typeSet = new TypeSet();
            String[] items = line.split("\t");
            typeSet.setName(items[0].trim());
            typeSet.setSequence(items[1].trim());
            typeSets.put(typeSet.getName(), typeSet);
            ++n2;
        }
        System.out.println("populateSequence " + typeSets.size());
    }
}

