/*
 * Decompiled with CFR 0.152.
 */
package aboTyping;

import aboTyping.DiploidType;
import aboTyping.Exon;
import aboTyping.Match;
import aboTyping.RuleSetSnps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class WorkOnMicaAlignment {
    public static String MICA = "MICA";
    public static String SUBSTITUTION = "SUBSTITUTION";
    public static String INSERTION = "INSERTION";
    public static String DELETION = "DELETION";
    public static String EXON2 = "2";
    public static String EXON3 = "3";
    public static String EXON4 = "4";
    public static String EXON5 = "5";

    public static void main(String[] args) throws Exception {
        File fastaAlignmentFile1 = new File(args[0]);
        File fastaAlignmentFile2 = new File(args[1]);
        File fastaAlignmentFile3 = new File(args[2]);
        File fastaAlignmentFile4 = new File(args[3]);
        File backboneFile = new File(args[4]);
        File outputDir = new File(args[5]);
        String backboneSeq = WorkOnMicaAlignment.getSequenceFromFasta(backboneFile);
        HashMap<String, List<Match>> typeMatches1 = new HashMap<String, List<Match>>();
        LinkedHashMap<String, Exon> exons1 = new LinkedHashMap<String, Exon>();
        RuleSetSnps ruleSetSnps1 = new RuleSetSnps();
        HashMap<String, List<Match>> typeMatches2 = new HashMap<String, List<Match>>();
        LinkedHashMap<String, Exon> exons2 = new LinkedHashMap<String, Exon>();
        RuleSetSnps ruleSetSnps2 = new RuleSetSnps();
        HashMap<String, List<Match>> typeMatches3 = new HashMap<String, List<Match>>();
        LinkedHashMap<String, Exon> exons3 = new LinkedHashMap<String, Exon>();
        RuleSetSnps ruleSetSnps3 = new RuleSetSnps();
        HashMap<String, List<Match>> typeMatches4 = new HashMap<String, List<Match>>();
        LinkedHashMap<String, Exon> exons4 = new LinkedHashMap<String, Exon>();
        RuleSetSnps ruleSetSnps4 = new RuleSetSnps();
        Map<String, String> sequenceMap1 = WorkOnMicaAlignment.parseAlignmentFile(fastaAlignmentFile1, backboneSeq, typeMatches1, exons1, ruleSetSnps1);
        Map<String, String> sequenceMap2 = WorkOnMicaAlignment.parseAlignmentFile(fastaAlignmentFile2, backboneSeq, typeMatches2, exons2, ruleSetSnps2);
        Map<String, String> sequenceMap3 = WorkOnMicaAlignment.parseAlignmentFile(fastaAlignmentFile3, backboneSeq, typeMatches3, exons3, ruleSetSnps3);
        Map<String, String> sequenceMap4 = WorkOnMicaAlignment.parseAlignmentFile(fastaAlignmentFile4, backboneSeq, typeMatches4, exons4, ruleSetSnps4);
        ArrayList<String> skipList = new ArrayList<String>();
        ArrayList<List<String>> hapAmb = new ArrayList<List<String>>();
        WorkOnMicaAlignment.buildHaploidMap(typeMatches1, exons1, ruleSetSnps1, typeMatches2, exons2, ruleSetSnps2, typeMatches3, exons3, ruleSetSnps3, typeMatches4, exons4, ruleSetSnps4, skipList, hapAmb);
        WorkOnMicaAlignment.writeSequence(outputDir, sequenceMap1, sequenceMap2, sequenceMap3, sequenceMap4, skipList);
        WorkOnMicaAlignment.writeExon(outputDir, exons1, exons2, exons3, exons4, skipList);
        WorkOnMicaAlignment.writeMatch(outputDir, typeMatches1, typeMatches2, typeMatches3, typeMatches4, skipList);
        WorkOnMicaAlignment.writeRuleSetSnp(outputDir, ruleSetSnps1, ruleSetSnps2, ruleSetSnps3, ruleSetSnps4);
        System.out.println("All sequence:" + sequenceMap1.size() + " " + sequenceMap2.size() + " " + sequenceMap3.size() + " " + sequenceMap4.size());
        System.out.println("Empty sequence:" + skipList.size());
        for (String string : skipList) {
            System.out.println(string);
        }
        System.out.println("Hap Amb sequences:" + hapAmb.size());
        for (List list : hapAmb) {
            System.out.println(String.valueOf(WorkOnMicaAlignment.constructHapName(list)) + " : " + list);
            if (list.size() <= 1) continue;
            for (String type : list) {
                System.out.println("\t" + ((Exon)exons1.get(type)).getBackboneStart() + "-" + ((Exon)exons1.get(type)).getBackboneEnd() + " " + ((Exon)exons2.get(type)).getBackboneStart() + "-" + ((Exon)exons2.get(type)).getBackboneEnd() + " " + ((Exon)exons3.get(type)).getBackboneStart() + "-" + ((Exon)exons3.get(type)).getBackboneEnd() + " " + ((Exon)exons4.get(type)).getBackboneStart() + "-" + ((Exon)exons4.get(type)).getBackboneEnd());
            }
        }
    }

    private static void writeRuleSetSnp(File outputDir, RuleSetSnps ruleSetSnps1, RuleSetSnps ruleSetSnps2, RuleSetSnps ruleSetSnps3, RuleSetSnps ruleSetSnps4) {
        StringBuilder builder = new StringBuilder();
        for (Integer pos : ruleSetSnps1.getRuleSetSubstitutionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps1.getRuleSetSubstitutionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps1.getRuleSetInsertionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps1.getRuleSetInsertionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps1.getRuleSetDeletionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps1.getRuleSetDeletionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps2.getRuleSetSubstitutionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps2.getRuleSetSubstitutionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps2.getRuleSetInsertionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps2.getRuleSetInsertionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps2.getRuleSetDeletionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps2.getRuleSetDeletionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps3.getRuleSetSubstitutionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps3.getRuleSetSubstitutionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps3.getRuleSetInsertionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps3.getRuleSetInsertionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps3.getRuleSetDeletionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps3.getRuleSetDeletionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps4.getRuleSetSubstitutionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps4.getRuleSetSubstitutionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps4.getRuleSetInsertionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps4.getRuleSetInsertionSnp().get((Object)pos).genotype).append("\n");
        }
        for (Integer pos : ruleSetSnps4.getRuleSetDeletionSnp().keySet()) {
            builder.append(pos).append("\t").append(ruleSetSnps4.getRuleSetDeletionSnp().get((Object)pos).genotype).append("\n");
        }
        FileManager.writeTextFile(new File(outputDir, "ruleSetSnp.txt"), builder.toString(), true);
    }

    private static void writeMatch(File outputDir, Map<String, List<Match>> typeMatches1, Map<String, List<Match>> typeMatches2, Map<String, List<Match>> typeMatches3, Map<String, List<Match>> typeMatches4, List<String> skipList) {
        StringBuilder builder = new StringBuilder();
        for (String type : typeMatches1.keySet()) {
            for (Match match : typeMatches1.get(type)) {
                builder.append(type).append("\t");
                builder.append(match.getPosition()).append("\t");
                builder.append(match.genotype).append(match.genotype).append("\t");
                builder.append(match.getMatchType()).append("\t");
                builder.append(match.getDeletionCount()).append("\n");
            }
            for (Match match : typeMatches2.get(type)) {
                builder.append(type).append("\t");
                builder.append(match.getPosition()).append("\t");
                builder.append(match.genotype).append(match.genotype).append("\t");
                builder.append(match.getMatchType()).append("\t");
                builder.append(match.getDeletionCount()).append("\n");
            }
            for (Match match : typeMatches3.get(type)) {
                builder.append(type).append("\t");
                builder.append(match.getPosition()).append("\t");
                builder.append(match.genotype).append(match.genotype).append("\t");
                builder.append(match.getMatchType()).append("\t");
                builder.append(match.getDeletionCount()).append("\n");
            }
            for (Match match : typeMatches4.get(type)) {
                builder.append(type).append("\t");
                builder.append(match.getPosition()).append("\t");
                builder.append(match.genotype).append(match.genotype).append("\t");
                builder.append(match.getMatchType()).append("\t");
                builder.append(match.getDeletionCount()).append("\n");
            }
        }
        FileManager.writeTextFile(new File(outputDir, "match.txt"), builder.toString(), true);
    }

    private static void writeExon(File outputDir, Map<String, Exon> exons1, Map<String, Exon> exons2, Map<String, Exon> exons3, Map<String, Exon> exons4, List<String> skipList) {
        StringBuilder builder = new StringBuilder();
        for (String type : exons1.keySet()) {
            if (skipList.contains(type)) continue;
            builder.append(type).append("\t").append(EXON2).append("\t");
            if (exons1.get(type).getAlleleEnd() == 0) {
                builder.append(0).append("\t").append(0).append("\t");
            } else {
                builder.append(exons1.get(type).getAlleleStart()).append("\t").append(exons1.get(type).getAlleleEnd() - 1).append("\t");
            }
            builder.append(exons1.get(type).getBackboneStart() + 1).append("\t").append(Math.max(1, exons1.get(type).getBackboneEnd())).append("\t");
            builder.append("\n");
            builder.append(type).append("\t").append(EXON3).append("\t");
            if (exons2.get(type).getAlleleEnd() == 0) {
                builder.append(0).append("\t").append(0).append("\t");
            } else {
                builder.append(exons2.get(type).getAlleleStart() + exons1.get(type).getAlleleEnd()).append("\t").append(Math.max(0, exons2.get(type).getAlleleEnd() + exons1.get(type).getAlleleEnd() - 1)).append("\t");
            }
            builder.append(exons2.get(type).getBackboneStart() + 1).append("\t").append(Math.max(1, exons2.get(type).getBackboneEnd())).append("\t");
            builder.append("\n");
            builder.append(type).append("\t").append(EXON4).append("\t");
            if (exons3.get(type).getAlleleEnd() == 0) {
                builder.append(0).append("\t").append(0).append("\t");
            } else {
                builder.append(exons3.get(type).getAlleleStart() + exons1.get(type).getAlleleEnd() + exons2.get(type).getAlleleEnd()).append("\t").append(exons3.get(type).getAlleleEnd() + exons1.get(type).getAlleleEnd() + exons2.get(type).getAlleleEnd() - 1).append("\t");
            }
            builder.append(exons3.get(type).getBackboneStart() + 1).append("\t").append(Math.max(1, exons3.get(type).getBackboneEnd())).append("\t");
            builder.append("\n");
            builder.append(type).append("\t").append(EXON5).append("\t");
            if (exons4.get(type).getAlleleEnd() == 0) {
                builder.append(0).append("\t").append(0).append("\t");
            } else {
                builder.append(exons4.get(type).getAlleleStart() + exons1.get(type).getAlleleEnd() + exons2.get(type).getAlleleEnd() + exons3.get(type).getAlleleEnd()).append("\t").append(exons4.get(type).getAlleleEnd() + exons1.get(type).getAlleleEnd() + exons2.get(type).getAlleleEnd() + exons3.get(type).getAlleleEnd() - 1).append("\t");
            }
            builder.append(exons4.get(type).getBackboneStart() + 1).append("\t").append(Math.max(1, exons4.get(type).getBackboneEnd())).append("\t");
            builder.append("\n");
        }
        FileManager.writeTextFile(new File(outputDir, "exon.txt"), builder.toString(), true);
    }

    private static void writeSequence(File outputDir, Map<String, String> sequenceMap1, Map<String, String> sequenceMap2, Map<String, String> sequenceMap3, Map<String, String> sequenceMap4, List<String> skipList) {
        StringBuilder builder = new StringBuilder();
        for (String type : sequenceMap1.keySet()) {
            if (skipList.contains(type)) continue;
            builder.append(type).append("\t").append(sequenceMap1.get(type)).append(sequenceMap2.get(type)).append(sequenceMap3.get(type)).append(sequenceMap4.get(type)).append("\n");
        }
        FileManager.writeTextFile(new File(outputDir, "sequence.txt"), builder.toString(), true);
    }

    private static List<List<DiploidType>> buildDiploidMap(Map<String, List<Match>> typeMatches1, Map<String, Exon> exons1, RuleSetSnps ruleSetSnps1, Map<String, List<Match>> typeMatches2, Map<String, Exon> exons2, RuleSetSnps ruleSetSnps2, Map<String, List<Match>> typeMatches3, Map<String, Exon> exons3, RuleSetSnps ruleSetSnps3, Map<String, List<Match>> typeMatches4, Map<String, Exon> exons4, RuleSetSnps ruleSetSnps4, List<List<String>> hapAmb) {
        ArrayList<List<DiploidType>> DiploidAmbs = new ArrayList<List<DiploidType>>();
        List<DiploidType> diploidTypes = WorkOnMicaAlignment.buildDiploidTypes(typeMatches1, exons1, typeMatches2, exons2, typeMatches3, exons3, typeMatches4, exons4, hapAmb);
        System.out.println("diploidTypes " + diploidTypes.size());
        DiploidType diploidType1 = null;
        DiploidType diploidType2 = null;
        ArrayList matchedList = new ArrayList();
        int i = 0;
        while (i < diploidTypes.size() - 1) {
            diploidType1 = diploidTypes.get(i);
            if (!matchedList.contains(diploidType1)) {
                ArrayList<DiploidType> amb = new ArrayList<DiploidType>();
                amb.add(diploidType1);
                int j = i + 1;
                while (j < diploidTypes.size()) {
                    diploidType2 = diploidTypes.get(j);
                    if (!matchedList.contains(diploidType2)) {
                        System.out.println("Compare " + diploidType1.toString() + " " + diploidType2.toString());
                        if (WorkOnMicaAlignment.isSameDiploid(diploidType1, diploidType2, ruleSetSnps1, ruleSetSnps2, ruleSetSnps3, ruleSetSnps4)) {
                            amb.add(diploidType2);
                        }
                    }
                    ++j;
                }
                if (amb.size() > 1) {
                    DiploidAmbs.add(amb);
                }
                matchedList.addAll(amb);
            }
            ++i;
        }
        return DiploidAmbs;
    }

    private static boolean isSameDiploid(DiploidType diploidType1, DiploidType diploidType2, RuleSetSnps ruleSetSnps1, RuleSetSnps ruleSetSnps2, RuleSetSnps ruleSetSnps3, RuleSetSnps ruleSetSnps4) {
        boolean isSame = true;
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps1.getRuleSetSubstitutionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps1.getRuleSetInsertionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps1.getRuleSetDeletionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps2.getRuleSetSubstitutionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps2.getRuleSetInsertionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps2.getRuleSetDeletionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps3.getRuleSetSubstitutionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps3.getRuleSetInsertionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps3.getRuleSetDeletionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps4.getRuleSetSubstitutionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps4.getRuleSetInsertionSnp())) {
            return false;
        }
        if (!WorkOnMicaAlignment.isSameDiploidMatches(diploidType1, diploidType2, ruleSetSnps4.getRuleSetDeletionSnp())) {
            return false;
        }
        return isSame;
    }

    private static boolean isInRange(Integer position, List<Exon> exons) {
        for (Exon exon : exons) {
            if (position <= exon.getBackboneStart() || position >= exon.getBackboneEnd()) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameDiploidMatches(DiploidType diploidType1, DiploidType diploidType2, Map<Integer, Match> ruleSnp) {
        boolean isSame = true;
        Match match = null;
        Match match1Hap1 = null;
        Match match1Hap2 = null;
        Match match2Hap1 = null;
        Match match2Hap2 = null;
        ArrayList<Integer> diffPos = new ArrayList<Integer>();
        for (Integer position : ruleSnp.keySet()) {
            match = ruleSnp.get(position);
            match1Hap1 = WorkOnMicaAlignment.findMatch(diploidType1.getMatches1(), match);
            match1Hap2 = WorkOnMicaAlignment.findMatch(diploidType1.getMatches2(), match);
            match2Hap1 = WorkOnMicaAlignment.findMatch(diploidType2.getMatches1(), match);
            match2Hap2 = WorkOnMicaAlignment.findMatch(diploidType2.getMatches2(), match);
            if (!WorkOnMicaAlignment.isInRange(position, diploidType1.getExons1())) {
                match1Hap1 = new Match("*", position, match.getMatchType(), 0);
            }
            if (!WorkOnMicaAlignment.isInRange(position, diploidType1.getExons2())) {
                match1Hap2 = new Match("*", position, match.getMatchType(), 0);
            }
            if (!WorkOnMicaAlignment.isInRange(position, diploidType2.getExons1())) {
                match2Hap1 = new Match("*", position, match.getMatchType(), 0);
            }
            if (!WorkOnMicaAlignment.isInRange(position, diploidType2.getExons2())) {
                match2Hap2 = new Match("*", position, match.getMatchType(), 0);
            }
            if (WorkOnMicaAlignment.combine(match1Hap1, match1Hap2).equals(WorkOnMicaAlignment.combine(match2Hap1, match2Hap2))) continue;
            diffPos.add(position);
            isSame = false;
        }
        if (diffPos.size() > 0) {
            System.out.println("---diploid different pos " + diffPos);
        }
        return isSame;
    }

    private static String combine(Match match1Hap1, Match match1Hap2) {
        char allele1 = 'B';
        char allele2 = 'B';
        String ret = null;
        if (match1Hap1 != null) {
            allele1 = match1Hap1.getGenotype().charAt(0);
        }
        if (match1Hap2 != null) {
            allele2 = match1Hap2.getGenotype().charAt(0);
        }
        ret = allele1 > allele2 ? String.valueOf(allele2) + allele1 : String.valueOf(allele1) + allele2;
        return ret;
    }

    private static List<DiploidType> buildDiploidTypes(Map<String, List<Match>> typeMatches1, Map<String, Exon> exons1, Map<String, List<Match>> typeMatches2, Map<String, Exon> exons2, Map<String, List<Match>> typeMatches3, Map<String, Exon> exons3, Map<String, List<Match>> typeMatches4, Map<String, Exon> exons4, List<List<String>> hapAmb) {
        ArrayList<DiploidType> diploidTypes = new ArrayList<DiploidType>();
        DiploidType diploidType = null;
        int i = 0;
        while (i < hapAmb.size()) {
            List<String> hap1 = hapAmb.get(i);
            int j = i;
            while (j < hapAmb.size()) {
                List<String> hap2 = hapAmb.get(j);
                diploidType = new DiploidType();
                diploidType.setHap1(WorkOnMicaAlignment.constructHapName(hap1));
                diploidType.setHap2(WorkOnMicaAlignment.constructHapName(hap2));
                List<Match> matches1 = typeMatches1.get(hap1.get(0));
                matches1.addAll((Collection<Match>)typeMatches2.get(hap1.get(0)));
                matches1.addAll((Collection<Match>)typeMatches3.get(hap1.get(0)));
                matches1.addAll((Collection<Match>)typeMatches4.get(hap1.get(0)));
                diploidType.setMatches1(matches1);
                List<Match> matches2 = typeMatches1.get(hap2.get(0));
                matches2.addAll((Collection<Match>)typeMatches2.get(hap2.get(0)));
                matches2.addAll((Collection<Match>)typeMatches3.get(hap2.get(0)));
                matches2.addAll((Collection<Match>)typeMatches4.get(hap2.get(0)));
                diploidType.setMatches2(matches2);
                ArrayList<Exon> exonHap1 = new ArrayList<Exon>();
                exonHap1.add(exons1.get(hap1.get(0)));
                exonHap1.add(exons2.get(hap1.get(0)));
                exonHap1.add(exons3.get(hap1.get(0)));
                exonHap1.add(exons4.get(hap1.get(0)));
                diploidType.setExons1(exonHap1);
                ArrayList<Exon> exonHap2 = new ArrayList<Exon>();
                exonHap2.add(exons1.get(hap2.get(0)));
                exonHap2.add(exons2.get(hap2.get(0)));
                exonHap2.add(exons3.get(hap2.get(0)));
                exonHap2.add(exons4.get(hap2.get(0)));
                diploidType.setExons2(exonHap2);
                diploidTypes.add(diploidType);
                ++j;
            }
            ++i;
        }
        return diploidTypes;
    }

    private static String constructHapName(List<String> hap) {
        if (hap.size() == 1) {
            return hap.get(0);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(hap.get(0));
        int i = 1;
        while (i < hap.size()) {
            builder.append("/");
            builder.append(hap.get(i).split("\\*")[1]);
            ++i;
        }
        return builder.toString();
    }

    private static void buildHaploidMap(Map<String, List<Match>> typeMatches1, Map<String, Exon> exons1, RuleSetSnps ruleSetSnps1, Map<String, List<Match>> typeMatches2, Map<String, Exon> exons2, RuleSetSnps ruleSetSnps2, Map<String, List<Match>> typeMatches3, Map<String, Exon> exons3, RuleSetSnps ruleSetSnps3, Map<String, List<Match>> typeMatches4, Map<String, Exon> exons4, RuleSetSnps ruleSetSnps4, List<String> skipList, List<List<String>> hapAmb) {
        ArrayList<String> tmp;
        Object[] types = exons1.keySet().toArray();
        ArrayList<String> matchesList = new ArrayList<String>();
        List<Match> matchI1 = null;
        List<Match> matchI2 = null;
        List<Match> matchI3 = null;
        List<Match> matchI4 = null;
        List<Match> matchJ1 = null;
        List<Match> matchJ2 = null;
        List<Match> matchJ3 = null;
        List<Match> matchJ4 = null;
        String type1 = null;
        String type2 = null;
        Object type3 = null;
        Object type4 = null;
        int i = 0;
        while (i < types.length - 1) {
            type1 = (String)types[i];
            if (!matchesList.contains(type1) && !skipList.contains(type1)) {
                if (exons1.get(type1).getBackboneStart() == 0 && exons1.get(type1).getBackboneEnd() == 0 && exons2.get(type1).getBackboneStart() == 0 && exons2.get(type1).getBackboneEnd() == 0) {
                    skipList.add(type1);
                } else if (exons1.get(type1).getBackboneStart() == 0 && exons1.get(type1).getBackboneEnd() == 0 || exons2.get(type1).getBackboneStart() == 0 && exons2.get(type1).getBackboneEnd() == 0) {
                    tmp = new ArrayList();
                    tmp.add(type1);
                    hapAmb.add(tmp);
                    matchesList.add(type1);
                } else {
                    ArrayList<String> sameTypes = new ArrayList<String>();
                    sameTypes.add(type1);
                    matchI1 = typeMatches1.get(type1);
                    matchI2 = typeMatches2.get(type1);
                    matchI3 = typeMatches3.get(type1);
                    matchI4 = typeMatches4.get(type1);
                    int j = i + 1;
                    while (j < types.length) {
                        type2 = (String)types[j];
                        if (!matchesList.contains(type2) && !skipList.contains(type2)) {
                            if (exons1.get(type2).getBackboneStart() == 0 && exons1.get(type2).getBackboneEnd() == 0 && exons2.get(type2).getBackboneStart() == 0 && exons2.get(type2).getBackboneEnd() == 0) {
                                skipList.add(type2);
                            } else {
                                matchJ1 = typeMatches1.get(type2);
                                matchJ2 = typeMatches2.get(type2);
                                matchJ3 = typeMatches3.get(type2);
                                matchJ4 = typeMatches4.get(type2);
                                if (WorkOnMicaAlignment.isAllSameMatches(matchI1, matchJ1, exons1.get(type1), exons1.get(type2), ruleSetSnps1) && WorkOnMicaAlignment.isAllSameMatches(matchI2, matchJ2, exons2.get(type1), exons2.get(type2), ruleSetSnps2) && WorkOnMicaAlignment.isAllSameMatches(matchI3, matchJ3, exons3.get(type1), exons3.get(type2), ruleSetSnps3) && WorkOnMicaAlignment.isAllSameMatches(matchI4, matchJ4, exons4.get(type1), exons4.get(type2), ruleSetSnps4)) {
                                    System.out.println("same");
                                    sameTypes.add(type2);
                                }
                            }
                        }
                        ++j;
                    }
                    hapAmb.add(sameTypes);
                    matchesList.addAll(sameTypes);
                }
            }
            ++i;
        }
        String lastType = (String)types[types.length - 1];
        if (!matchesList.contains(lastType) && !skipList.contains(lastType)) {
            tmp = new ArrayList<String>();
            tmp.add(lastType);
            hapAmb.add(tmp);
        }
    }

    private static boolean isAllSameMatches(List<Match> matchesA, List<Match> matchesB, Exon exonA, Exon exonB, RuleSetSnps ruleSetSnps) {
        boolean isSame = true;
        if ((exonA.getBackboneStart() == 0 && exonA.getBackboneEnd() == 0 || exonB.getBackboneStart() == 0 && exonB.getBackboneEnd() == 0) && exonA.getBackboneStart() != exonB.getBackboneStart()) {
            isSame = false;
        }
        if (!WorkOnMicaAlignment.isSameMatches(matchesA, matchesB, exonA, exonB, ruleSetSnps.getRuleSetSubstitutionSnp())) {
            isSame = false;
        }
        if (!WorkOnMicaAlignment.isSameMatches(matchesA, matchesB, exonA, exonB, ruleSetSnps.getRuleSetInsertionSnp())) {
            isSame = false;
        }
        if (!WorkOnMicaAlignment.isSameMatches(matchesA, matchesB, exonA, exonB, ruleSetSnps.getRuleSetDeletionSnp())) {
            isSame = false;
        }
        return isSame;
    }

    private static boolean isSameMatches(List<Match> matchesA, List<Match> matchesB, Exon exonA, Exon exonB, Map<Integer, Match> matches) {
        boolean isSame = true;
        Match match = null;
        Match match1 = null;
        Match match2 = null;
        ArrayList<Integer> diffPos = new ArrayList<Integer>();
        for (Integer position : matches.keySet()) {
            match = matches.get(position);
            if (position <= exonA.getBackboneStart() || position >= exonA.getBackboneEnd() || position <= exonB.getBackboneStart() || position >= exonB.getBackboneEnd()) continue;
            match1 = WorkOnMicaAlignment.findMatch(matchesA, match);
            match2 = WorkOnMicaAlignment.findMatch(matchesB, match);
            if (match1 != null && match2 != null) {
                if (match1.getGenotype().equals(match2.getGenotype()) && match1.getDeletionCount() == match2.getDeletionCount()) continue;
                diffPos.add(position);
                isSame = false;
                continue;
            }
            if ((match1 == null || match2 != null) && (match1 != null || match2 == null)) continue;
            diffPos.add(position);
            isSame = false;
        }
        return isSame;
    }

    private static Match findMatch(List<Match> matches, Match match) {
        int i = 0;
        while (i < matches.size()) {
            if (matches.get(i).getPosition() > match.getPosition()) {
                return null;
            }
            if (matches.get(i).getPosition() == match.getPosition() && match.getMatchType().equals(matches.get(i).getMatchType())) {
                return matches.get(i);
            }
            ++i;
        }
        return null;
    }

    private static String getTemplateSeq(String[] lines) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] data = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(MICA) && (data = line.trim().split("\\s+"))[1].trim().indexOf("-") < 0 && data[1].trim().indexOf("*") < 0) {
                int i = 1;
                while (i < data.length) {
                    stringBuilder.append(data[i].trim());
                    ++i;
                }
            }
            ++n2;
        }
        System.out.println("Size of template: " + stringBuilder.toString().length());
        System.out.println(stringBuilder.toString());
        return stringBuilder.toString();
    }

    private static Map<String, String> parseAlignmentFile(File fastaAlignmentFile, String backboneSeq, Map<String, List<Match>> typeMatches, Map<String, Exon> exons, RuleSetSnps ruleSetSnps) {
        LinkedHashMap<String, String> sequenceMap = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaAlignmentFile).split("\n");
        String[] data = null;
        String hapType = null;
        String sequence = null;
        String templateSeq = WorkOnMicaAlignment.getTemplateSeq(lines);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(MICA) && ((data = line.trim().split("\\s+"))[1].trim().indexOf("-") >= 0 || data[1].trim().indexOf("*") >= 0)) {
                hapType = data[0];
                sequence = sequenceMap.containsKey(hapType) ? (String)sequenceMap.get(hapType) : "";
                int i = 1;
                while (i < data.length) {
                    sequence = String.valueOf(sequence) + data[i].trim().toUpperCase();
                    ++i;
                }
                sequenceMap.put(hapType, sequence);
            }
            ++n2;
        }
        for (String h : sequenceMap.keySet()) {
            System.out.println(String.valueOf(h) + "\t" + (String)sequenceMap.get(h));
        }
        Map<String, String> formatedSequenceMap = WorkOnMicaAlignment.formatSeqences(sequenceMap, backboneSeq, templateSeq, typeMatches, exons, ruleSetSnps);
        return formatedSequenceMap;
    }

    private static Map<String, String> formatSeqences(Map<String, String> sequenceMap, String backboneSeq, String templateSeq, Map<String, List<Match>> typeMatches, Map<String, Exon> exons, RuleSetSnps ruleSetSnps) {
        String newTemplate = templateSeq.replaceAll("\\.", "");
        int backboneStart = backboneSeq.indexOf(newTemplate);
        LinkedHashMap<String, String> formatedSequenceMap = new LinkedHashMap<String, String>();
        if (backboneStart < 0) {
            System.out.println("ERROR can't find template seq on backbone \n" + newTemplate);
            return null;
        }
        System.out.println(backboneStart);
        String fullSeq = null;
        for (String type : sequenceMap.keySet()) {
            System.out.println("--------------" + type + "--------------");
            String sequence = sequenceMap.get(type);
            typeMatches.put(type, new ArrayList());
            StringBuilder builder = new StringBuilder();
            fullSeq = WorkOnMicaAlignment.compareToTemplate(templateSeq, backboneStart, typeMatches, ruleSetSnps, type, sequence, builder);
            exons.put(type, WorkOnMicaAlignment.findExon(fullSeq, templateSeq, backboneStart));
            formatedSequenceMap.put(type, fullSeq.replaceAll("\\*", ""));
            System.out.println("Exon bbstart=" + exons.get(type).getBackboneStart() + ", bbend=" + exons.get(type).getBackboneEnd() + ", alstart=" + exons.get(type).getAlleleStart() + ", alend=" + exons.get(type).getAlleleEnd());
        }
        System.out.println("<<<<<<<<<rule set snp>>>>>>>>>>>>>>>");
        System.out.println("ruleSetSubstitutionSnp=" + ruleSetSnps.getRuleSetSubstitutionSnp().size());
        for (Match match : ruleSetSnps.getRuleSetSubstitutionSnp().values()) {
            System.out.println("\t" + match.getPosition() + " " + match.genotype);
        }
        System.out.println("ruleSetInsertionSnp=" + ruleSetSnps.getRuleSetInsertionSnp().size());
        for (Match match : ruleSetSnps.getRuleSetInsertionSnp().values()) {
            System.out.println("\t" + match.getPosition() + " " + match.genotype);
        }
        System.out.println("ruleSetDeletionSnp=" + ruleSetSnps.getRuleSetDeletionSnp().size());
        for (Match match : ruleSetSnps.getRuleSetDeletionSnp().values()) {
            System.out.println("\t" + match.getPosition() + " " + match.genotype);
        }
        return formatedSequenceMap;
    }

    private static Exon findExon(String fullSeq, String templateSeq, int backboneStart) {
        String newTemplate = templateSeq.replaceAll("\\.", "");
        int backboneEnd = backboneStart + newTemplate.length();
        if (fullSeq.indexOf(42) < 0) {
            return new Exon(backboneStart, backboneEnd, 0, fullSeq.length());
        }
        String newFullSeq = fullSeq.replaceAll("\\*", "");
        if (newFullSeq.trim().length() == 0) {
            System.out.println("WARNING missing whole sequence");
            return new Exon(0, 0, 0, 0);
        }
        int endDiff = fullSeq.length() - fullSeq.indexOf(newFullSeq) - newFullSeq.length();
        return new Exon(backboneStart + fullSeq.indexOf(newFullSeq), backboneEnd - endDiff, 0, newFullSeq.length());
    }

    private static String compareToTemplate(String templateSeq, int pos, Map<String, List<Match>> typeMatches, RuleSetSnps ruleSetSnps, String type, String sequence, StringBuilder builder) {
        int offset = 0;
        int i = 0;
        while (i < templateSeq.length()) {
            int backboneIndex;
            if (templateSeq.charAt(i) == '.') {
                if (sequence.charAt(i) != '.' && sequence.charAt(i) != '*') {
                    if (sequence.charAt(i) == '-') {
                        System.out.println("ERROR ------------ ");
                    } else {
                        builder.append(sequence.charAt(i));
                        backboneIndex = pos + i - offset;
                        if (!ruleSetSnps.getRuleSetInsertionSnp().containsKey(backboneIndex)) {
                            ruleSetSnps.getRuleSetInsertionSnp().put(backboneIndex, new Match(String.valueOf('-'), backboneIndex, INSERTION, 0));
                        }
                        typeMatches.get(type).add(new Match(String.valueOf(sequence.charAt(i)), backboneIndex, INSERTION, 0));
                    }
                }
                ++offset;
            } else if (sequence.charAt(i) == '-') {
                builder.append(templateSeq.charAt(i));
            } else if (sequence.charAt(i) == '.') {
                backboneIndex = pos + i + 1 - offset;
                if (!ruleSetSnps.getRuleSetDeletionSnp().containsKey(backboneIndex)) {
                    ruleSetSnps.getRuleSetDeletionSnp().put(backboneIndex, new Match(String.valueOf(templateSeq.charAt(i)), backboneIndex, DELETION, 1));
                }
                typeMatches.get(type).add(new Match(String.valueOf('-'), backboneIndex, DELETION, 1));
            } else if (sequence.charAt(i) == '*') {
                builder.append(sequence.charAt(i));
            } else {
                builder.append(sequence.charAt(i));
                backboneIndex = pos + i + 1 - offset;
                if (!ruleSetSnps.getRuleSetSubstitutionSnp().containsKey(backboneIndex)) {
                    ruleSetSnps.getRuleSetSubstitutionSnp().put(backboneIndex, new Match(String.valueOf(templateSeq.charAt(i)), backboneIndex, SUBSTITUTION, 0));
                }
                typeMatches.get(type).add(new Match(String.valueOf(sequence.charAt(i)), backboneIndex, SUBSTITUTION, 0));
            }
            ++i;
        }
        System.out.println("Sequence :");
        System.out.println(templateSeq);
        System.out.println(sequence);
        System.out.println(builder.toString());
        System.out.println("Type matches: " + typeMatches.get(type).size());
        for (Match match : typeMatches.get(type)) {
            System.out.println("\t" + match.getPosition() + " " + match.getMatchType() + " " + match.getGenotype() + " " + match.getDeletionCount());
        }
        return builder.toString();
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }
}

