/*
 * Decompiled with CFR 0.152.
 */
package aboTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class MapNewTypesForAmbPrimer {
    public static void main(String[] args) throws Exception {
        File OldHapAmbFile = new File(args[0]);
        File NewHapAmbFile = new File(args[1]);
        File TranslationFile = new File(args[2]);
        File OldDipAmbFile = new File(args[3]);
        File NewDipAmbFile = new File(args[4]);
        File OldAmbPrimerFile = new File(args[5]);
        File NewAmbPrimerFile = new File(args[6]);
        File OldPrimerBindingFile = new File(args[7]);
        File NewPrimerBindingFile = new File(args[8]);
        Map<String, List<String>> oldHapAmb = MapNewTypesForAmbPrimer.parseHapAmbFile(OldHapAmbFile);
        Map<String, String> newHapAmb = MapNewTypesForAmbPrimer.parseNewHapAmbFile(NewHapAmbFile);
        List<List<String>> oldDipAmbs = MapNewTypesForAmbPrimer.parseNewDipAmbs(OldDipAmbFile);
        List<List<String>> newDipAmbs = MapNewTypesForAmbPrimer.parseNewDipAmbs(NewDipAmbFile);
        Map<String, List<String>> oldPrimerMap = MapNewTypesForAmbPrimer.parsePrimerAmbFile(OldAmbPrimerFile);
        MapNewTypesForAmbPrimer.writePrimerBindingFile(OldPrimerBindingFile, NewPrimerBindingFile, oldHapAmb, newHapAmb);
        StringBuilder out = new StringBuilder();
        for (String diType : oldPrimerMap.keySet()) {
            List<String> allOldtypes = MapNewTypesForAmbPrimer.getAllOldTypes(diType, oldDipAmbs);
            if (allOldtypes == null) continue;
            String newDType = null;
            for (String thisDType : allOldtypes) {
                newDType = MapNewTypesForAmbPrimer.getNewDipAmbType(thisDType, oldHapAmb, newHapAmb, newDipAmbs);
                if (newDType == null) continue;
                out.append(newDType).append("\t");
                break;
            }
            if (newDType == null) {
                System.out.println("!!!!!!!!!!not found");
            }
            for (String primer : oldPrimerMap.get(diType)) {
                out.append(primer).append("\t");
            }
            out.append("\n");
        }
        FileManager.writeTextFile(NewAmbPrimerFile, out.toString(), true);
    }

    private static void writePrimerBindingFile(File oldPrimerBindingFile, File newPrimerBindingFile, Map<String, List<String>> oldHapAmb, Map<String, String> newHapAmb) {
        String[] input = FileManager.readTextFile(oldPrimerBindingFile).split("\n");
        StringBuilder out = new StringBuilder();
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\\s+");
                out.append(items[0].trim()).append("\t");
                int i = 1;
                while (i < items.length) {
                    if (items[i].trim().length() > 0) {
                        String type = MapNewTypesForAmbPrimer.getNewType(items[i].trim(), oldHapAmb, newHapAmb);
                        if (type == null) {
                            System.out.println("Can not find ----- " + items[i].trim());
                        } else {
                            out.append(type).append("\t");
                        }
                    }
                    ++i;
                }
                out.append("\n");
            }
            ++n2;
        }
        FileManager.writeTextFile(newPrimerBindingFile, out.toString(), true);
    }

    private static List<String> getAllOldTypes(String type, List<List<String>> oldDipAmbs) {
        for (List<String> list : oldDipAmbs) {
            if (!list.contains(type)) continue;
            return list;
        }
        return null;
    }

    private static String getNewDipAmbType(String type, Map<String, List<String>> oldHapAmb, Map<String, String> newHapAmb, List<List<String>> newDipAmbs) {
        String type1 = type.split("\\+")[0];
        String type2 = type.split("\\+")[1];
        String newType1 = MapNewTypesForAmbPrimer.getNewType(type1, oldHapAmb, newHapAmb);
        String newType2 = MapNewTypesForAmbPrimer.getNewType(type2, oldHapAmb, newHapAmb);
        if (newType1 == null || newType2 == null) {
            return null;
        }
        String rep = MapNewTypesForAmbPrimer.getInNewMap(String.valueOf(newType1) + "+" + newType2, newDipAmbs);
        if (rep == null) {
            rep = MapNewTypesForAmbPrimer.getInNewMap(String.valueOf(newType2) + "+" + newType1, newDipAmbs);
        }
        return rep;
    }

    private static String getNewType(String type, Map<String, List<String>> oldHapAmb, Map<String, String> newHapAmb) {
        String newType = type;
        if (newHapAmb.containsKey(newType)) {
            newType = newHapAmb.get(newType);
        }
        return newType;
    }

    private static String getInNewMap(String type, List<List<String>> newDipAmbs) {
        for (List<String> list : newDipAmbs) {
            if (!list.contains(type)) continue;
            return list.get(0);
        }
        return null;
    }

    private static Map<String, List<String>> parsePrimerAmbFile(File file) {
        String[] input;
        LinkedHashMap<String, List<String>> primerAmb = new LinkedHashMap<String, List<String>>();
        String[] stringArray = input = FileManager.readTextFile(file).split("\n");
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\\s+");
                primerAmb.put(items[0].trim(), new ArrayList());
                int i = 1;
                while (i < items.length) {
                    if (items[i].trim().length() > 0) {
                        ((List)primerAmb.get(items[0].trim())).add(items[i].trim());
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return primerAmb;
    }

    private static List<List<String>> parseNewDipAmbs(File file) {
        String[] input;
        ArrayList<List<String>> newDipAmbs = new ArrayList<List<String>>();
        String[] stringArray = input = FileManager.readTextFile(file).split("\n");
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\\s+");
                ArrayList<String> aList = new ArrayList<String>();
                int i = 0;
                while (i < items.length) {
                    if (items[i].trim().length() > 0) {
                        aList.add(items[i].trim());
                    }
                    ++i;
                }
                newDipAmbs.add(aList);
            }
            ++n2;
        }
        return newDipAmbs;
    }

    private static Map<String, String> parseTranslationFile(File file) {
        String[] input;
        HashMap<String, String> transMap = new HashMap<String, String>();
        String[] stringArray = input = FileManager.readTextFile(file).split("\n");
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\\s+");
                transMap.put(items[0].trim(), items[1].trim());
            }
            ++n2;
        }
        return transMap;
    }

    private static Map<String, String> parseNewHapAmbFile(File file) {
        String[] input;
        HashMap<String, String> hapAmb = new HashMap<String, String>();
        String[] stringArray = input = FileManager.readTextFile(file).split("\n");
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\\s+");
                int i = 1;
                while (i < items.length) {
                    if (items[i].trim().length() > 0) {
                        hapAmb.put(items[i].trim(), items[0].trim());
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return hapAmb;
    }

    private static Map<String, List<String>> parseHapAmbFile(File file) {
        String[] input;
        HashMap<String, List<String>> hapAmb = new HashMap<String, List<String>>();
        String[] stringArray = input = FileManager.readTextFile(file).split("\n");
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\\s+");
                hapAmb.put(items[0].trim(), new ArrayList());
                int i = 1;
                while (i < items.length) {
                    if (items[i].trim().length() > 0) {
                        ((List)hapAmb.get(items[0].trim())).add(items[i].trim());
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return hapAmb;
    }
}

