/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TestAmbiguityPrimer0620 {
    private static int SEQUENCING_SIZE = 700;
    private static int Valid_SEQUENCE_START = 30;
    private static int RESOLUTION_LEVEL = 90;
    private static int PRIMER_NUMBER = 50;
    private static double SALT_CONCENTRATION = 50.0;
    private static double PRIMER_CONCENTRATION = 250.0;
    private static int END_NUMBER = 6;

    public static void main(String[] args) throws Exception {
        String type = args[0];
        File fastaAlignmentFile = new File(args[1]);
        File ambiguityFile = new File(args[2]);
        File primerFile = new File(args[3]);
        File symbolFile = new File(args[4]);
        File resolvingFile = new File(args[5]);
        File outputFile = new File(args[6]);
        Map<String, String> sequenceMap = TestAmbiguityPrimer0620.parseAlignmentFile(fastaAlignmentFile, type);
        Map<String, String> primerMap = TestAmbiguityPrimer0620.parsePrimerFile(primerFile);
        Map<String, Integer> bindingSitesMap = TestAmbiguityPrimer0620.getPrimerBindingSites(primerMap, sequenceMap);
        String[] ambiguities = FileManager.readTextFile(ambiguityFile).split("\n");
        Map<String, List<String>> symbolMap = TestAmbiguityPrimer0620.parseSymbolFile(symbolFile, type);
        Map<String, List<String>> primerResolvingMap = TestAmbiguityPrimer0620.getResolvingMap(resolvingFile);
        Map<String, List<String>> primerBindingMap = TestAmbiguityPrimer0620.getPrimerBindingMap(ambiguities, sequenceMap, symbolMap, primerMap, bindingSitesMap, primerResolvingMap);
        TestAmbiguityPrimer0620.writeOutput(outputFile, primerBindingMap);
    }

    private static void writeOutput(File outputFile, Map<String, List<String>> primerBindingMap) {
        StringBuilder builder = new StringBuilder();
        for (String primer : primerBindingMap.keySet()) {
            builder.append(primer).append("=");
            for (String hap : primerBindingMap.get(primer)) {
                builder.append(hap).append(",");
            }
            builder.append("\n");
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static Map<String, List<String>> getPrimerBindingMap(String[] ambiguities, Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, Map<String, String> primerMap, Map<String, Integer> bindingSitesMap, Map<String, List<String>> primerResolvingMap) {
        HashMap<String, List<String>> primerBindingMap = new HashMap<String, List<String>>();
        Object diploidType = null;
        for (String primer : primerResolvingMap.keySet()) {
            if (!primerBindingMap.containsKey(primer)) {
                primerBindingMap.put(primer, new ArrayList());
            }
            for (String ambiguity : primerResolvingMap.get(primer)) {
                String[] pairs;
                String thisAmbiguities = TestAmbiguityPrimer0620.findAmbiguity(ambiguities, ambiguity.trim());
                if (thisAmbiguities == null) {
                    System.out.println("can not find ambiguities " + ambiguity);
                    continue;
                }
                String[] stringArray = pairs = thisAmbiguities.trim().split(",");
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] data = pair.trim().split("\\+");
                    if (((List)primerBindingMap.get(primer)).contains(data[0]) && ((List)primerBindingMap.get(primer)).contains(data[1])) {
                        System.out.println("trouble determin which should bind " + pair + " " + primer);
                    } else if (!((List)primerBindingMap.get(primer)).contains(data[0]) && !((List)primerBindingMap.get(primer)).contains(data[1])) {
                        TestAmbiguityPrimer0620.determineBindingHap(primerBindingMap, primer, pair, primerMap, sequenceMap, symbolMap, bindingSitesMap);
                    }
                    ++n2;
                }
            }
        }
        return primerBindingMap;
    }

    private static void determineBindingHap(Map<String, List<String>> primerBindingMap, String primer, String pair, Map<String, String> primerMap, Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, Map<String, Integer> bindingSitesMap) {
        PrimerSequencingResult result2;
        DiploidType diploidType = TestAmbiguityPrimer0620.parseDiploid(pair, sequenceMap);
        String sequence1 = TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, diploidType.getHaploid1());
        if (sequence1 == null) {
            System.out.println("no seq for " + diploidType.getHaploid1());
            return;
        }
        String sequence2 = TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, diploidType.getHaploid2());
        if (sequence2 == null) {
            System.out.println("no seq for " + diploidType.getHaploid2());
            return;
        }
        if (primerMap.get(primer) == null) {
            return;
        }
        PrimerSequencingResult result1 = TestAmbiguityPrimer0620.findPrimerBindingSite(sequence1, primerMap.get(primer), diploidType.getHaploid1(), bindingSitesMap.get(primer), sequence2);
        PrimerSequencingResult result = TestAmbiguityPrimer0620.combineSequence(result1, result2 = TestAmbiguityPrimer0620.findPrimerBindingSite(sequence2, primerMap.get(primer), diploidType.getHaploid2(), bindingSitesMap.get(primer), sequence1));
        if (result != null && result.getBindingPosistion() > 0) {
            if (result1 != null && result1.getBindingPosistion() > -1) {
                primerBindingMap.get(primer).add(pair.trim().split("\\+")[0]);
            } else if (result2 != null && result2.getBindingPosistion() > -1) {
                primerBindingMap.get(primer).add(pair.trim().split("\\+")[1]);
            }
        } else {
            System.out.println("xxxx can not locate which will bind " + primer + " on " + pair);
        }
    }

    public static String findAmbiguity(String[] ambiguities, String ambiguity) {
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(ambiguity) >= 0) {
                return line;
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, List<String>> getResolvingMap(File resolvingFile) {
        String[] lines;
        HashMap<String, List<String>> primerMap = new HashMap<String, List<String>>();
        String[] stringArray = lines = FileManager.readTextFile(resolvingFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split(",");
                int i = 1;
                while (i < items.length) {
                    String primer = items[i];
                    if (primer.trim().length() != 0) {
                        if (!primerMap.containsKey(primer)) {
                            primerMap.put(primer, new ArrayList());
                        }
                        ((List)primerMap.get(primer)).add(items[0]);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return primerMap;
    }

    private static int findRemoveTarget(List<Integer> primerStaticsList, List<Integer> primerUniqueList, Map<String, String> testedPrimerMap) {
        int index = -1;
        int uniqueCount = -1;
        int i = 0;
        while (i < primerUniqueList.size()) {
            if (i >= testedPrimerMap.size()) {
                if (uniqueCount == -1 || uniqueCount > primerUniqueList.get(i)) {
                    uniqueCount = primerUniqueList.get(i);
                    index = i;
                } else if (uniqueCount == primerUniqueList.get(i) && primerStaticsList.get(index) > primerStaticsList.get(i)) {
                    uniqueCount = primerUniqueList.get(i);
                    index = i;
                }
            }
            ++i;
        }
        return index;
    }

    private static Map<String, String> buildNewPrimerMap(Map<String, String> primerMap, int removeIndex) {
        LinkedHashMap<String, String> newPrimerMap = new LinkedHashMap<String, String>();
        int i = 0;
        String primer2 = null;
        for (String primer2 : primerMap.keySet()) {
            if (i != removeIndex) {
                newPrimerMap.put(primer2, primerMap.get(primer2));
            }
            ++i;
        }
        return newPrimerMap;
    }

    private static String buildDiploidType(String ambiguity) {
        return ambiguity.split(",")[0];
    }

    private static void testAndOutputPrimerLastPrimerSet(Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, Map<String, String> primerMap, String[] ambiguities, StringBuffer stringBuffer, Map<String, Integer> bindingSitesMap, File ambiguityFile, String type) {
        int workedCount = 0;
        int failedCount = 0;
        AmbiguityTestResult ambiguityTestResult = null;
        List<Integer> primerStaticsList = TestAmbiguityPrimer0620.initPrimerStataicsList(primerMap);
        List<Integer> primerUniqueList = TestAmbiguityPrimer0620.initPrimerStataicsList(primerMap);
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String ambiguity = stringArray[n2];
            ambiguityTestResult = TestAmbiguityPrimer0620.testing(sequenceMap, symbolMap, primerMap, ambiguity, stringBuffer, bindingSitesMap, primerStaticsList, primerUniqueList, false);
            if (ambiguityTestResult.isAllResolved()) {
                ++workedCount;
                if (ambiguityTestResult.getWorkingPrimers().size() > 0) {
                    System.out.println(String.valueOf(TestAmbiguityPrimer0620.buildDiploidType(ambiguity)) + "," + TestAmbiguityPrimer0620.formatPrimers(ambiguityTestResult.getWorkingPrimers()));
                }
            } else {
                ++failedCount;
            }
            ++n2;
        }
        System.out.println("\nStatistics Min primer set: \n----------------------");
        System.out.println("total ambiguities:\t" + ambiguities.length);
        System.out.println("resolved:\t" + workedCount + " " + (float)workedCount * 1.0f / (float)ambiguities.length * 100.0f);
        System.out.println("unresolved:\t" + failedCount + "\n");
        int i = 0;
        for (String primer : primerMap.keySet()) {
            System.out.println(String.valueOf(primer) + "\t" + primerMap.get(primer) + "\t" + TestAmbiguityPrimer0620.calculateMeltingTemp(primerMap.get(primer).replaceAll("\\.", "")) + "\tworks\t" + primerStaticsList.get(i) + "\tunique\t" + primerUniqueList.get(i));
            ++i;
        }
        System.out.println("----------------------\n");
    }

    private static String formatPrimers(List<String> primers) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String primer : primers) {
            stringBuilder.append(primer).append(",");
        }
        return stringBuilder.toString();
    }

    public static double calculateMeltingTemp(String primerSequence) {
        double m_meltingTemp = 0.0;
        double theH = 0.0;
        double theS = -10.8;
        DecimalFormat fmt = new DecimalFormat();
        fmt.setMaximumFractionDigits(1);
        int i = 0;
        while (i < primerSequence.length() - 1) {
            String theStr = primerSequence.substring(i, i + 2);
            List<String> theList = Arrays.asList(PrimerConstants.ATGC_LIST);
            int pos = theList.indexOf(theStr);
            if (pos == -1) {
                System.out.println("------------" + theStr + "\n" + primerSequence);
            }
            theH += PrimerConstants.DELTAH_LIST[pos];
            theS += PrimerConstants.DELTAS_LIST[pos];
            ++i;
        }
        m_meltingTemp = theH * 1000.0 / (theS + 1.987 * Math.log(PRIMER_CONCENTRATION * 1.0E-12 / 4.0)) - 273.15 + 16.6 * Math.log(SALT_CONCENTRATION * 0.001) / Math.log(10.0);
        String s = fmt.format(m_meltingTemp);
        m_meltingTemp = Double.parseDouble(s);
        return m_meltingTemp;
    }

    private static String getPrimerName(Map<String, String> primerMap, int index) {
        int i = 0;
        for (String primer : primerMap.keySet()) {
            if (i == index) {
                return primer;
            }
            ++i;
        }
        return null;
    }

    public static void buildMiniPrimerSetBasedOnPrimerSize(Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, Map<String, String> primerMap, String[] ambiguities, StringBuffer stringBuffer, Map<String, Integer> bindingSitesMap, List<Integer> primerStaticsList, List<Integer> primerUniqueList, Map<String, String> testedPrimerMap, File ambiguityFile, String type) {
        int index = TestAmbiguityPrimer0620.findRemoveTarget(primerStaticsList, primerUniqueList, testedPrimerMap);
        Map<String, String> newPrimerMap = TestAmbiguityPrimer0620.buildNewPrimerMap(primerMap, index);
        List<Integer> newPrimerStaticsList = TestAmbiguityPrimer0620.initPrimerStataicsList(newPrimerMap);
        List<Integer> newPrimerUniqueList = TestAmbiguityPrimer0620.initPrimerStataicsList(newPrimerMap);
        int workedCount = 0;
        int failedCount = 0;
        AmbiguityTestResult ambiguityTestResult = null;
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String ambiguity = stringArray[n2];
            ambiguityTestResult = TestAmbiguityPrimer0620.testing(sequenceMap, symbolMap, newPrimerMap, ambiguity, stringBuffer, bindingSitesMap, newPrimerStaticsList, newPrimerUniqueList, false);
            if (ambiguityTestResult.isAllResolved()) {
                ++workedCount;
            } else {
                ++failedCount;
            }
            ++n2;
        }
        if (newPrimerMap.size() < PRIMER_NUMBER || index == -1) {
            TestAmbiguityPrimer0620.testAndOutputPrimerLastPrimerSet(sequenceMap, symbolMap, primerMap, ambiguities, stringBuffer, bindingSitesMap, ambiguityFile, type);
            return;
        }
        System.out.println("remove " + TestAmbiguityPrimer0620.getPrimerName(primerMap, index) + " " + (float)workedCount * 1.0f / (float)ambiguities.length * 100.0f);
        TestAmbiguityPrimer0620.buildMiniPrimerSetBasedOnPrimerSize(sequenceMap, symbolMap, newPrimerMap, ambiguities, stringBuffer, bindingSitesMap, newPrimerStaticsList, newPrimerUniqueList, testedPrimerMap, ambiguityFile, type);
    }

    public static void buildMiniPrimerSetBasedOnPercentage(Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, Map<String, String> primerMap, String[] ambiguities, StringBuffer stringBuffer, Map<String, Integer> bindingSitesMap, List<Integer> primerStaticsList, List<Integer> primerUniqueList, Map<String, String> testedPrimerMap, File ambiguityFile, String type) {
        int index = TestAmbiguityPrimer0620.findRemoveTarget(primerStaticsList, primerUniqueList, testedPrimerMap);
        Map<String, String> newPrimerMap = TestAmbiguityPrimer0620.buildNewPrimerMap(primerMap, index);
        List<Integer> newPrimerStaticsList = TestAmbiguityPrimer0620.initPrimerStataicsList(newPrimerMap);
        List<Integer> newPrimerUniqueList = TestAmbiguityPrimer0620.initPrimerStataicsList(newPrimerMap);
        int workedCount = 0;
        int failedCount = 0;
        AmbiguityTestResult ambiguityTestResult = null;
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String ambiguity = stringArray[n2];
            ambiguityTestResult = TestAmbiguityPrimer0620.testing(sequenceMap, symbolMap, newPrimerMap, ambiguity, stringBuffer, bindingSitesMap, newPrimerStaticsList, newPrimerUniqueList, false);
            if (ambiguityTestResult.isAllResolved()) {
                ++workedCount;
            } else {
                ++failedCount;
            }
            ++n2;
        }
        if ((float)workedCount * 1.0f / (float)ambiguities.length * 100.0f < (float)RESOLUTION_LEVEL || index == -1) {
            TestAmbiguityPrimer0620.testAndOutputPrimerLastPrimerSet(sequenceMap, symbolMap, primerMap, ambiguities, stringBuffer, bindingSitesMap, ambiguityFile, type);
            return;
        }
        System.out.println("remove " + TestAmbiguityPrimer0620.getPrimerName(primerMap, index) + " " + (float)workedCount * 1.0f / (float)ambiguities.length * 100.0f);
        TestAmbiguityPrimer0620.buildMiniPrimerSetBasedOnPercentage(sequenceMap, symbolMap, newPrimerMap, ambiguities, stringBuffer, bindingSitesMap, newPrimerStaticsList, newPrimerUniqueList, new HashMap<String, String>(), ambiguityFile, type);
    }

    public static Map<String, List<String>> parseSymbolFile(File symbolFile, String type) {
        HashMap<String, List<String>> symbolMap = new HashMap<String, List<String>>();
        String[] lines = FileManager.readTextFile(symbolFile).split("\n");
        String[] info = null;
        ArrayList<String> list = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            info = line.trim().split(",");
            if (info[0].indexOf("/") < 0 && info[0].startsWith(type)) {
                list = new ArrayList<String>();
                int i = 1;
                while (i < info.length) {
                    if (info[i].trim().startsWith(type)) {
                        list.add(info[i].trim().split("\\*")[1]);
                    }
                    ++i;
                }
                symbolMap.put(info[0].trim().split("\\*")[1], list);
            }
            ++n2;
        }
        return symbolMap;
    }

    public static List<Integer> initPrimerStataicsList(Map<String, String> primerMap) {
        ArrayList<Integer> primerStaticsList = new ArrayList<Integer>();
        for (String primer : primerMap.keySet()) {
            primerStaticsList.add(0);
        }
        return primerStaticsList;
    }

    public static Map<String, Integer> getPrimerBindingSites(Map<String, String> primerMap, Map<String, String> sequenceMap) {
        String primerSequence = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        block0: for (String primer : primerMap.keySet()) {
            primerSequence = primerMap.get(primer);
            for (String sequence : sequenceMap.values()) {
                if (sequence.indexOf(primerSequence) > -1) {
                    map.put(primer, sequence.indexOf(primerSequence) + 1);
                    continue block0;
                }
                if (sequence.indexOf(StringUtils.revCompSeq(primerSequence)) <= -1) continue;
                map.put(primer, sequence.indexOf(StringUtils.revCompSeq(primerSequence)) + 1);
                continue block0;
            }
        }
        for (String primer : primerMap.keySet()) {
            if (!map.containsKey(primer)) {
                System.out.println("no binding site " + primer + " " + primerMap.get(primer));
                continue;
            }
            System.out.println("binding site " + primer + " " + map.get(primer));
        }
        return map;
    }

    public static AmbiguityTestResult testing(Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, Map<String, String> primerMap, AmbiguityPair ambiguityPair, StringBuffer stringBuffer, Map<String, Integer> bindingSitesMap, List<Integer> primerStaticsList, List<Integer> primerUniqueList, boolean isOutput) {
        ArrayList<DiploidType> types = new ArrayList<DiploidType>();
        TestAmbiguityPrimer0620.getPattern(ambiguityPair.getDiploidType1(), TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType1().getHaploid1()), TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType1().getHaploid2()), primerMap, bindingSitesMap);
        types.add(ambiguityPair.getDiploidType1());
        TestAmbiguityPrimer0620.getPattern(ambiguityPair.getDiploidType2(), TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType2().getHaploid1()), TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, ambiguityPair.getDiploidType2().getHaploid2()), primerMap, bindingSitesMap);
        types.add(ambiguityPair.getDiploidType2());
        return TestAmbiguityPrimer0620.testing(sequenceMap, primerMap, types, stringBuffer, bindingSitesMap, primerStaticsList, primerUniqueList, isOutput);
    }

    public static AmbiguityTestResult testing(Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, Map<String, String> primerMap, String ambiguity, StringBuffer stringBuffer, Map<String, Integer> bindingSitesMap, List<Integer> primerStaticsList, List<Integer> primerUniqueList, boolean isOutput) {
        if (isOutput) {
            System.out.println("**********************");
        }
        String[] data = ambiguity.split(",");
        DiploidType diploidType = null;
        AmbiguityTestResult ambiguityTestResult = new AmbiguityTestResult();
        ArrayList<DiploidType> types = new ArrayList<DiploidType>();
        String sequence1 = null;
        String sequence2 = null;
        boolean abortTest = false;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            if (info.trim().length() > 0) {
                diploidType = TestAmbiguityPrimer0620.parseDiploid(info, sequenceMap);
                sequence1 = TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, diploidType.getHaploid1());
                if (sequence1 == null) {
                    if (isOutput) {
                        System.out.println("no seq for " + diploidType.getHaploid1());
                    }
                    abortTest = true;
                    break;
                }
                sequence2 = TestAmbiguityPrimer0620.getHaplotyleSequence(sequenceMap, symbolMap, diploidType.getHaploid2());
                if (sequence2 == null) {
                    if (isOutput) {
                        System.out.println("no seq for " + diploidType.getHaploid2());
                    }
                    abortTest = true;
                    break;
                }
                TestAmbiguityPrimer0620.getPattern(diploidType, sequence1, sequence2, primerMap, bindingSitesMap);
                types.add(diploidType);
            }
            ++n2;
        }
        if (abortTest) {
            if (isOutput) {
                System.out.println("Can not test...  ");
            }
            ambiguityTestResult.setTestable(false);
            return ambiguityTestResult;
        }
        return TestAmbiguityPrimer0620.testing(sequenceMap, primerMap, types, stringBuffer, bindingSitesMap, primerStaticsList, primerUniqueList, isOutput);
    }

    public static String getHaplotyleSequence(Map<String, String> sequenceMap, Map<String, List<String>> symbolMap, String haplotype) {
        String sequence1 = sequenceMap.get(haplotype);
        if (sequence1 == null && symbolMap.containsKey(haplotype)) {
            List<String> symbols = symbolMap.get(haplotype);
            for (String symbol : symbols) {
                if (sequenceMap.get(symbol) == null) continue;
                sequence1 = sequenceMap.get(symbol);
                break;
            }
        }
        return sequence1;
    }

    private static AmbiguityTestResult testing(Map<String, String> sequenceMap, Map<String, String> primerMap, List<DiploidType> types, StringBuffer stringBuffer, Map<String, Integer> bindingSitesMap, List<Integer> primerStaticsList, List<Integer> primerUniqueList, boolean isOutput) {
        AmbiguityTestResult ambiguityTestResult = new AmbiguityTestResult();
        ArrayList<AmbiguityPair> ambiguityPairs = new ArrayList<AmbiguityPair>();
        DiploidType diploidType1 = null;
        DiploidType diploidType2 = null;
        AmbiguityPair ambiguityPair = null;
        int i = 0;
        while (i < types.size()) {
            diploidType1 = types.get(i);
            int j = i + 1;
            while (j < types.size()) {
                diploidType2 = types.get(j);
                ambiguityPair = new AmbiguityPair();
                ambiguityPair.setDiploidType1(diploidType1);
                ambiguityPair.setDiploidType2(diploidType2);
                ambiguityPairs.add(ambiguityPair);
                ++j;
            }
            ++i;
        }
        ambiguityTestResult.setAmbiguityPairs(ambiguityPairs);
        TestAmbiguityPrimer0620.testFullSet(ambiguityTestResult, primerStaticsList, primerUniqueList, primerMap, isOutput);
        return ambiguityTestResult;
    }

    private static void testFullSet(AmbiguityTestResult ambiguityTestResult, List<Integer> primerStaticsList, List<Integer> primerUniqueList, Map<String, String> primerMap, boolean isOutput) {
        boolean isAllResolved = true;
        ArrayList<ArrayList<Integer>> workList = new ArrayList<ArrayList<Integer>>();
        for (AmbiguityPair ambiguityPair : ambiguityTestResult.getAmbiguityPairs()) {
            ArrayList<Integer> tmpList;
            if (isOutput) {
                System.out.println("Checking diff between " + ambiguityPair.getDiploidType1().getHaploid1() + "+" + ambiguityPair.getDiploidType1().getHaploid2() + " and " + ambiguityPair.getDiploidType2().getHaploid1() + "+" + ambiguityPair.getDiploidType2().getHaploid2() + "\nbinding pattern: " + ambiguityPair.getDiploidType1().getPattern() + " " + ambiguityPair.getDiploidType2().getPattern());
            }
            if (TestAmbiguityPrimer0620.isSamePattern(ambiguityPair, tmpList = new ArrayList<Integer>(), primerMap, isOutput)) {
                isAllResolved = false;
                if (!isOutput) continue;
                System.out.println("--can not resolve " + ambiguityPair.getDiploidType1().getPattern());
                continue;
            }
            workList.add(tmpList);
        }
        if (isAllResolved) {
            ambiguityTestResult.setAllResolved(true);
            ambiguityTestResult.setWorkingPrimers(TestAmbiguityPrimer0620.getAmbiguityTestResultPrimers(ambiguityTestResult, primerMap));
            if (isOutput) {
                System.out.println("ambiguity resloved!");
            }
        }
        for (List list : workList) {
            for (Integer index : list) {
                int count = primerStaticsList.get(index) + 1;
                primerStaticsList.set(index, count);
            }
            if (list.size() != 1) continue;
            int count = primerUniqueList.get((Integer)list.get(0)) + 1;
            primerUniqueList.set((Integer)list.get(0), count);
        }
    }

    private static List<String> getAmbiguityTestResultPrimers(AmbiguityTestResult ambiguityTestResult, Map<String, String> primerMap) {
        ArrayList<String> allWorkingPrimers = new ArrayList<String>();
        List<String> thisWorkingPrimers = null;
        for (String primer : primerMap.keySet()) {
            boolean allworked = true;
            for (AmbiguityPair ambiguityPair : ambiguityTestResult.getAmbiguityPairs()) {
                thisWorkingPrimers = ambiguityPair.getWorkingPrimers();
                if (thisWorkingPrimers.contains(primer)) continue;
                allworked = false;
                break;
            }
            if (!allworked) continue;
            allWorkingPrimers.add(primer);
        }
        return allWorkingPrimers;
    }

    private static boolean isSamePattern(AmbiguityPair ambiguityPair, List<Integer> tmpList, Map<String, String> primerMap, boolean isOutput) {
        boolean isSamePattern = true;
        int i = 0;
        while (i < ambiguityPair.getDiploidType1().getPattern().length()) {
            if (ambiguityPair.getDiploidType1().getPattern().charAt(i) != '?' && ambiguityPair.getDiploidType2().getPattern().charAt(i) != '?' && ambiguityPair.getDiploidType1().getPattern().charAt(i) != '2' && ambiguityPair.getDiploidType2().getPattern().charAt(i) != '2' && ambiguityPair.getDiploidType1().getPattern().charAt(i) != ambiguityPair.getDiploidType2().getPattern().charAt(i)) {
                if (isOutput) {
                    System.out.println("--Difference on sequencing pattern " + ambiguityPair.getDiploidType1().getPattern() + " " + ambiguityPair.getDiploidType2().getPattern());
                }
                isSamePattern = false;
                ambiguityPair.setResolved(true);
                tmpList.add(i);
            }
            ++i;
        }
        String sequence1 = null;
        String sequence2 = null;
        ArrayList<String> workingPrimers = new ArrayList<String>();
        int i2 = 0;
        while (i2 < ambiguityPair.getDiploidType1().getPattern().length()) {
            if (ambiguityPair.getDiploidType1().getPattern().charAt(i2) == '1' && ambiguityPair.getDiploidType2().getPattern().charAt(i2) == '1' && TestAmbiguityPrimer0620.isShowsDifference(sequence1 = ambiguityPair.getDiploidType1().getSequences().get(i2), sequence2 = ambiguityPair.getDiploidType2().getSequences().get(i2), ambiguityPair.getDiploidType1().getRevComps().charAt(i2), i2 + 1, isOutput)) {
                isSamePattern = false;
                ambiguityPair.setResolved(true);
                workingPrimers.add(TestAmbiguityPrimer0620.getPrimerName(primerMap, i2));
                tmpList.add(i2);
                if (isOutput) {
                    System.out.println(String.valueOf(TestAmbiguityPrimer0620.getPrimerName(primerMap, i2)) + " works, binding site: " + ambiguityPair.getDiploidType1().getBindingSite().get(i2) + " " + ambiguityPair.getDiploidType1().getRevComps().charAt(i2));
                }
            }
            ++i2;
        }
        ambiguityPair.setWorkingPrimers(workingPrimers);
        return isSamePattern;
    }

    private static boolean isShowsDifference(String sequence1, String sequence2, char direction, int index, boolean isOutput) {
        boolean isDiff;
        block10: {
            block9: {
                isDiff = false;
                if (Math.min(sequence1.length(), sequence2.length()) < Valid_SEQUENCE_START) {
                    return false;
                }
                if (direction != 'f') break block9;
                int i = Valid_SEQUENCE_START;
                while (i < Math.min(sequence1.length(), sequence2.length())) {
                    if (sequence1.charAt(i) != sequence2.charAt(i) && sequence1.charAt(i) != '*' && sequence2.charAt(i) != '*') {
                        int end;
                        isDiff = true;
                        int start = i >= 5 ? i - 5 : 0;
                        int n = end = i + 6 > Math.min(sequence1.length(), sequence2.length()) ? Math.min(sequence1.length(), sequence2.length()) : i + 6;
                        if (isOutput) {
                            System.out.println("\tshows different at " + sequence1.substring(start, i).toLowerCase() + sequence1.charAt(i) + sequence1.substring(i + 1, end).toLowerCase() + " vs " + sequence2.substring(start, i).toLowerCase() + sequence2.charAt(i) + sequence2.substring(i + 1, end).toLowerCase());
                        }
                    }
                    ++i;
                }
                break block10;
            }
            if (direction != 'r') break block10;
            int i = Valid_SEQUENCE_START;
            while (i <= Math.min(sequence1.length(), sequence2.length())) {
                if (sequence1.charAt(sequence1.length() - i) != sequence2.charAt(sequence2.length() - i) && sequence1.charAt(sequence1.length() - i) != '*' && sequence2.charAt(sequence2.length() - i) != '*') {
                    int end;
                    isDiff = true;
                    int start = sequence1.length() - i >= 5 ? sequence1.length() - i - 5 : 0;
                    int n = end = sequence1.length() - i + 6 > Math.min(sequence1.length(), sequence2.length()) ? Math.min(sequence1.length(), sequence2.length()) : sequence1.length() - i + 6;
                    if (isOutput) {
                        try {
                            System.out.println("\tshows different at " + sequence1.substring(start, sequence1.length() - i).toLowerCase() + sequence1.charAt(sequence1.length() - i) + sequence1.substring(sequence1.length() - i + 1, end).toLowerCase() + " vs " + sequence2.substring(start, sequence2.length() - i).toLowerCase() + sequence2.charAt(sequence2.length() - i) + sequence2.substring(sequence2.length() - i + 1, end).toLowerCase());
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            System.out.println(String.valueOf(start) + " !!!!!!!!!!!! " + end + " " + sequence1.length() + " " + sequence2.length() + " " + i);
                            System.out.println(sequence1);
                            System.out.println(sequence2);
                        }
                    }
                }
                ++i;
            }
        }
        return isDiff;
    }

    private static void getPattern(DiploidType diploidType, String sequence1, String sequence2, Map<String, String> primerMap, Map<String, Integer> bindingSitesMap) {
        String pattern = "";
        ArrayList<String> sequences = new ArrayList<String>();
        PrimerSequencingResult result1 = null;
        PrimerSequencingResult result2 = null;
        String sequence = null;
        String revComps = "";
        ArrayList<Integer> bindSites = new ArrayList<Integer>();
        for (String primer : primerMap.keySet()) {
            result1 = TestAmbiguityPrimer0620.findPrimerBindingSite(sequence1, primerMap.get(primer), diploidType.getHaploid1(), bindingSitesMap.get(primer), sequence2);
            PrimerSequencingResult result = TestAmbiguityPrimer0620.combineSequence(result1, result2 = TestAmbiguityPrimer0620.findPrimerBindingSite(sequence2, primerMap.get(primer), diploidType.getHaploid2(), bindingSitesMap.get(primer), sequence1));
            if (result != null && result.getBindingPosistion() > 0 && TestAmbiguityPrimer0620.isSimilar3EndSequence(sequence1, sequence2, result, primerMap.get(primer))) {
                result = null;
            }
            sequence = result == null ? null : result.getSequence();
            pattern = String.valueOf(pattern) + (result == null ? (char)'?' : TestAmbiguityPrimer0620.getPrimerPattern(result1, result2));
            revComps = String.valueOf(revComps) + TestAmbiguityPrimer0620.getPrimerRevComp(result1, result2);
            sequences.add(sequence);
            bindSites.add(TestAmbiguityPrimer0620.getBindingSite(result1, result2));
        }
        diploidType.setPattern(pattern);
        diploidType.setSequences(sequences);
        diploidType.setRevComps(revComps);
        diploidType.setBindingSite(bindSites);
    }

    private static boolean isSimilar3EndSequence(String sequence1, String sequence2, PrimerSequencingResult result, String primer) {
        int bindingSite = result.getBindingPosistion();
        int diffCount = 0;
        if (result.isReverseComplement()) {
            int i = 0;
            while (i < 15) {
                if (sequence1.charAt(bindingSite - primer.length() + i) != sequence2.charAt(bindingSite - primer.length() + i)) {
                    ++diffCount;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 15) {
                if (sequence1.charAt(bindingSite + primer.length() - i - 2) != sequence2.charAt(bindingSite + primer.length() - i - 2)) {
                    ++diffCount;
                }
                ++i;
            }
        }
        return diffCount < 2;
    }

    private static int getBindingSite(PrimerSequencingResult result1, PrimerSequencingResult result2) {
        if (result1 != null) {
            return result1.getBindingPosistion();
        }
        if (result2 != null) {
            return result2.getBindingPosistion();
        }
        return -1;
    }

    private static String getPrimerRevComp(PrimerSequencingResult result1, PrimerSequencingResult result2) {
        if (result1 != null) {
            return result1.isReverseComplement() ? "r" : "f";
        }
        if (result2 != null) {
            return result2.isReverseComplement() ? "r" : "f";
        }
        return "0";
    }

    private static char getPrimerPattern(PrimerSequencingResult result1, PrimerSequencingResult result2) {
        if (result1 == null && result2 == null) {
            return '0';
        }
        if (result1 != null && result1.isUnknown()) {
            return '?';
        }
        if (result2 != null && result2.isUnknown()) {
            return '?';
        }
        if (result1 != null && result2 != null) {
            return '2';
        }
        return '1';
    }

    private static PrimerSequencingResult combineSequence(PrimerSequencingResult result1, PrimerSequencingResult result2) {
        if (result1 == null && result2 == null) {
            return null;
        }
        if (result1 != null && result1.isUnknown()) {
            return null;
        }
        if (result2 != null && result2.isUnknown()) {
            return null;
        }
        if (result1 != null && result2 != null) {
            return new PrimerSequencingResult();
        }
        if (result1 == null) {
            return result2;
        }
        return result1;
    }

    private static PrimerSequencingResult findPrimerBindingSite(String sequence, String primerSeq, String haploid, Integer targetPostion, String otherSeq) {
        PrimerSequencingResult primerSequencingResult = TestAmbiguityPrimer0620.makePrimerSequencingResult(sequence, primerSeq, haploid, targetPostion, otherSeq);
        String newPrimerSeq = "";
        if (primerSequencingResult == null && targetPostion != null && sequence.substring(targetPostion - 1, targetPostion - 1 + primerSeq.length()).indexOf("*") > -1) {
            int count = 0;
            int i = 0;
            while (i < primerSeq.length()) {
                if (sequence.charAt(targetPostion - 1 + i) == '*') {
                    newPrimerSeq = String.valueOf(newPrimerSeq) + '*';
                    ++count;
                } else {
                    newPrimerSeq = String.valueOf(newPrimerSeq) + primerSeq.charAt(i);
                }
                ++i;
            }
            if (count <= 6) {
                return TestAmbiguityPrimer0620.makePrimerSequencingResult(sequence, newPrimerSeq, haploid, targetPostion, otherSeq);
            }
            PrimerSequencingResult unknowResult = new PrimerSequencingResult();
            unknowResult.setUnknown(true);
            return unknowResult;
        }
        return primerSequencingResult;
    }

    private static PrimerSequencingResult makePrimerSequencingResult(String sequence, String primerSeq, String haploid, Integer targetPostion, String otherSeq) {
        int bindingSite = -1;
        boolean isRevComp = false;
        String predictedSeq = null;
        PrimerSequencingResult primerSequencingResult = new PrimerSequencingResult();
        if (sequence.indexOf(primerSeq) > -1) {
            bindingSite = sequence.indexOf(primerSeq);
            if (sequence.indexOf(primerSeq, bindingSite + 1) > -1) {
                System.out.println("Non unique binding " + primerSeq + " on " + haploid);
                return null;
            }
        } else if (sequence.indexOf(StringUtils.revCompSeq(primerSeq)) > -1) {
            if (bindingSite > 0) {
                System.out.println("Non unique binding " + primerSeq + " on forward and reverse " + haploid);
                return null;
            }
            bindingSite = sequence.indexOf(StringUtils.revCompSeq(primerSeq));
            if (sequence.indexOf(StringUtils.revCompSeq(primerSeq), bindingSite + 1) > -1) {
                System.out.println("Non unique binding " + primerSeq + " on reverse " + haploid);
                return null;
            }
            isRevComp = true;
        } else if (sequence.replaceAll("\\.", "").indexOf(primerSeq.replaceAll("\\.", "")) > -1) {
            bindingSite = sequence.replaceAll("\\.", "").indexOf(primerSeq.replaceAll("\\.", ""));
        } else if (sequence.replaceAll("\\.", "").indexOf(StringUtils.revCompSeq(primerSeq.replaceAll("\\.", ""))) > -1) {
            bindingSite = sequence.replaceAll("\\.", "").indexOf(StringUtils.revCompSeq(primerSeq.replaceAll("\\.", "")));
            isRevComp = true;
        } else if (sequence.indexOf(primerSeq.substring(primerSeq.length() - END_NUMBER)) > -1 && otherSeq.indexOf(primerSeq.substring(primerSeq.length() - END_NUMBER)) <= -1) {
            bindingSite = sequence.indexOf(primerSeq.substring(primerSeq.length() - END_NUMBER)) - END_NUMBER;
        } else if (sequence.indexOf(StringUtils.revCompSeq(primerSeq).substring(0, END_NUMBER)) > -1 && otherSeq.indexOf(StringUtils.revCompSeq(primerSeq).substring(0, END_NUMBER)) <= -1) {
            bindingSite = sequence.indexOf(StringUtils.revCompSeq(primerSeq));
            isRevComp = true;
        }
        if (bindingSite > -1) {
            if (isRevComp) {
                primerSequencingResult.setReverseComplement(true);
                primerSequencingResult.setBindingPosistion(bindingSite + primerSeq.length());
                predictedSeq = sequence.substring(Math.max(0, bindingSite + primerSeq.length() - SEQUENCING_SIZE), bindingSite + primerSeq.length());
            } else {
                primerSequencingResult.setReverseComplement(false);
                primerSequencingResult.setBindingPosistion(bindingSite + 1);
                predictedSeq = sequence.substring(bindingSite, Math.min(bindingSite + SEQUENCING_SIZE, sequence.length()));
            }
            primerSequencingResult.setSequence(predictedSeq);
            return primerSequencingResult;
        }
        return null;
    }

    private static boolean diffButWillBind(String primerSeq, String sequence, Integer targetPostion, String haploid, boolean isRevComp) {
        int diffCount = 0;
        ArrayList<Integer> diffSites = new ArrayList<Integer>();
        if (targetPostion == null) {
            return false;
        }
        int i = 0;
        while (i < primerSeq.length()) {
            if (primerSeq.charAt(i) != sequence.charAt(targetPostion - 1 + i)) {
                ++diffCount;
                diffSites.add(i);
            }
            ++i;
        }
        if (isRevComp) {
            if (diffSites.size() >= 1 && ((Integer)diffSites.get(0) == 0 || (Integer)diffSites.get(0) == 1)) {
                return false;
            }
            if (diffCount == 1) {
                return true;
            }
            if (diffCount >= 2 && TestAmbiguityPrimer0620.hasContingous3end(diffSites, primerSeq, isRevComp)) {
                return true;
            }
        } else {
            if (diffSites.size() >= 1 && ((Integer)diffSites.get(diffSites.size() - 1) == primerSeq.length() - 1 || (Integer)diffSites.get(diffSites.size() - 1) == primerSeq.length() - 2)) {
                return false;
            }
            if (diffCount == 1) {
                return true;
            }
            if (diffCount >= 2 && TestAmbiguityPrimer0620.hasContingous3end(diffSites, primerSeq, isRevComp)) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasContingous3end(List<Integer> diffSites, String primerSeq, boolean isRevComp) {
        if (isRevComp) {
            if (diffSites.size() > 2 && diffSites.get(1) - diffSites.get(0) <= 10) {
                return false;
            }
            if (diffSites.get(1) - diffSites.get(0) >= 6) {
                return true;
            }
            if (diffSites.get(1) - diffSites.get(0) == 1 ? diffSites.get(0) >= 4 : diffSites.get(0) >= 3) {
                return true;
            }
        } else {
            if (diffSites.size() > 2 && diffSites.get(diffSites.size() - 1) - diffSites.get(diffSites.size() - 2) <= 10) {
                return false;
            }
            if (diffSites.get(1) - diffSites.get(0) >= 6) {
                return true;
            }
            if (diffSites.get(1) - diffSites.get(0) == 1 ? diffSites.get(1) <= primerSeq.length() - 4 - 1 : diffSites.get(1) <= primerSeq.length() - 3 - 1) {
                return true;
            }
        }
        return false;
    }

    public static DiploidType parseDiploid(String info, Map<String, String> sequenceMap) {
        int i;
        String[] data = info.trim().split("\\+");
        String a = data[0].split("\\/")[0].split("\\*")[1].trim();
        String b = data[1].split("\\/")[0].split("\\*")[1].trim();
        if (sequenceMap.get(a) == null && data[0].split("\\/").length > 1) {
            i = 1;
            while (i < data[0].split("\\/").length) {
                if (sequenceMap.get(data[0].split("\\/")[i]) != null) {
                    a = data[0].split("\\/")[i];
                    break;
                }
                ++i;
            }
        }
        if (sequenceMap.get(b) == null && data[1].split("\\/").length > 1) {
            i = 1;
            while (i < data[1].split("\\/").length) {
                if (sequenceMap.get(data[1].split("\\/")[i]) != null) {
                    b = data[1].split("\\/")[i];
                    break;
                }
                ++i;
            }
        }
        return new DiploidType(a, b);
    }

    public static Map<String, String> parsePrimerFile(File primerFile) {
        String[] lines;
        LinkedHashMap<String, String> primerMap = new LinkedHashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(primerFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() > 0) {
                primerMap.put(line.split(",")[0].trim(), line.split(",")[1].trim().toUpperCase());
            }
            ++n2;
        }
        return primerMap;
    }

    public static Map<String, String> parseAlignmentFile(File fastaAlignmentFile, String type) {
        HashMap<String, String> sequenceMap = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaAlignmentFile).split("\n");
        String[] data = null;
        String hapType = null;
        String sequence = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(type)) {
                data = line.trim().split("\\s+");
                hapType = data[0].split("\\*")[1];
                sequence = sequenceMap.containsKey(hapType) ? (String)sequenceMap.get(hapType) : "";
                int i = 1;
                while (i < data.length) {
                    sequence = String.valueOf(sequence) + data[i].trim().toUpperCase();
                    ++i;
                }
                sequenceMap.put(hapType, sequence);
            }
            ++n2;
        }
        for (String string : sequenceMap.keySet()) {
        }
        return sequenceMap;
    }
}

