/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

public class SnpCallerPrepForKir {
    public static void main(String[] args) throws Exception {
        File amp_list = new File(args[0]);
        File assemblyRoot = new File(args[1]);
        File snpRoot = new File(args[2]);
        SnpCallerPrepForKir.prepSnpCallerData(amp_list, assemblyRoot, snpRoot);
    }

    private static void prepSnpCallerData(File amp_list, File assemblyRoot, File snpRoot) {
        String[] amplicons = FileManager.readTextFile(amp_list).split("\n");
        File fastaDir = null;
        File[] files = null;
        StringBuilder allfasta = null;
        StringBuilder allfasta_qual = null;
        String sequence = null;
        String[] stringArray = amplicons;
        int n = amplicons.length;
        int n2 = 0;
        while (n2 < n) {
            String amplicon = stringArray[n2];
            SnpCallerPrepForKir.makeSnpDirs(amplicon, snpRoot);
            allfasta = new StringBuilder();
            allfasta_qual = new StringBuilder();
            fastaDir = new File(new File(assemblyRoot, amplicon), "fasta");
            File[] fileArray = files = fastaDir.listFiles();
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                File file = fileArray[n4];
                if (!file.getName().endsWith("log")) {
                    sequence = FileManager.readTextFile(file).trim().split("\n").length == 1 ? "" : FileManager.readTextFile(file).split("\n")[1];
                    allfasta.append(">").append(file.getName()).append("\n");
                    allfasta.append(sequence).append("\n");
                    allfasta_qual.append(">").append(file.getName()).append("\n");
                    int i = 0;
                    while (i < sequence.length()) {
                        allfasta_qual.append("56 ");
                        ++i;
                    }
                    allfasta_qual.append("\n");
                    SnpCallerPrepForKir.writePolyFile(file, amplicon, snpRoot);
                }
                ++n4;
            }
            SnpCallerPrepForKir.writeFastaQualityFile(allfasta, allfasta_qual, amplicon, snpRoot);
            ++n2;
        }
    }

    private static void writePolyFile(File file, String amplicon, File snpRoot) {
        String name = String.valueOf(file.getName()) + ".poly";
        File poly_dir = new File(new File(snpRoot, amplicon), "poly_dir");
        String sequence = null;
        sequence = FileManager.readTextFile(file).trim().split("\n").length == 1 ? "" : FileManager.readTextFile(file).split("\n")[1];
        StringBuilder builder = new StringBuilder();
        builder.append("poly\n");
        int i = 0;
        while (i < sequence.length()) {
            builder.append(sequence.charAt(i)).append(" ").append((i + 1) * 10).append(" 1000 1.0 N -1 -1.00 -1.00 0 0 0 0\n");
            ++i;
        }
        FileManager.writeTextFile(new File(poly_dir, name), builder.toString(), true);
    }

    private static void writeFastaQualityFile(StringBuilder allfasta, StringBuilder allfasta_qual, String amplicon, File snpRoot) {
        File ampliconDir = new File(snpRoot, amplicon);
        File fasta = new File(new File(ampliconDir, "snp_data_dir"), "allfasta");
        File fasta_trim = new File(new File(ampliconDir, "snp_data_dir"), "allfasta_trim");
        File fasta_qual = new File(new File(ampliconDir, "snp_data_dir"), "allfasta.qual");
        File fasta_trim_qual = new File(new File(ampliconDir, "snp_data_dir"), "allfasta_trim.qual");
        FileManager.writeTextFile(fasta, allfasta.toString(), true);
        FileManager.writeTextFile(fasta_trim, allfasta.toString(), true);
        FileManager.writeTextFile(fasta_qual, allfasta_qual.toString(), true);
        FileManager.writeTextFile(fasta_trim_qual, allfasta_qual.toString(), true);
    }

    private static void makeSnpDirs(String amplicon, File snpRoot) {
        File ampliconDir = new File(snpRoot, amplicon);
        new File(ampliconDir, "poly_dir").mkdirs();
        new File(ampliconDir, "snp_data_dir").mkdirs();
    }
}

