/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class RunPolyphredPrep {
    private static String SUDO_PHRED = "/home/groups/GeMS/polyphred5Test/Software/sudophred ";

    public static void main(String[] args) throws Exception {
        File ampFile = new File(args[0]);
        File dataRoot = new File(args[1]);
        File backboneRoot = new File(args[2]);
        String[] amps = FileManager.readTextFile(ampFile).split("\n");
        File edit_dir = null;
        Object backbone = null;
        String[] stringArray = amps;
        int n = amps.length;
        int n2 = 0;
        while (n2 < n) {
            String amp = stringArray[n2];
            edit_dir = new File(new File(dataRoot, amp), "edit_dir");
            RunPolyphredPrep.runCmd("phred -id ../chromat_dir -dd ../poly_dir", edit_dir);
            RunPolyphredPrep.runCmd("phredPhrap -forcelevel 10 ", edit_dir);
            ++n2;
        }
    }

    private static void runCmd(String cmd, File dir) {
        block6: {
            String data = null;
            InputStream inputStream = null;
            InputStream errorStream = null;
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                Process proc = Runtime.getRuntime().exec(cmd, null, dir);
                inputStream = proc.getInputStream();
                errorStream = proc.getErrorStream();
                StreamReaderThread outThread = new StreamReaderThread(inputStream, out, true);
                StreamReaderThread errThread = new StreamReaderThread(errorStream, err, true);
                outThread.start();
                errThread.start();
                int result = proc.waitFor();
                outThread.join();
                errThread.join();
                data = out.toString();
            }
            catch (IOException ioe) {
                System.err.println("an I/O error occurs" + ioe.toString());
                System.exit(1);
                RunPolyphredPrep.closeInputStream(inputStream);
                RunPolyphredPrep.closeInputStream(errorStream);
                break block6;
            }
            catch (InterruptedException e) {
                try {
                    System.err.println("Interrupted waiting for process!");
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    RunPolyphredPrep.closeInputStream(inputStream);
                    RunPolyphredPrep.closeInputStream(errorStream);
                    throw throwable;
                }
                RunPolyphredPrep.closeInputStream(inputStream);
                RunPolyphredPrep.closeInputStream(errorStream);
                break block6;
            }
            RunPolyphredPrep.closeInputStream(inputStream);
            RunPolyphredPrep.closeInputStream(errorStream);
        }
    }

    private static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String formatCellLine(String name) {
        String ret = name;
        int i = 0;
        while (i < 10 - name.length()) {
            ret = String.valueOf(ret) + "X";
            ++i;
        }
        return ret;
    }

    private static void checkFileStructure(File ampDir) {
        if (!ampDir.exists() || !ampDir.isDirectory()) {
            ampDir.mkdirs();
            new File(ampDir, "chromat_dir").mkdir();
            new File(ampDir, "phd_dir").mkdir();
            new File(ampDir, "assembly").mkdir();
            new File(ampDir, "edit_dir").mkdir();
            new File(ampDir, "manager").mkdir();
            new File(ampDir, "poly_dir").mkdir();
        }
    }
}

