/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParseAlignments {
    private static int FULL_SIZE = 341;
    private static int DIFF_CUTOFF = 2;

    public static void main(String[] args) throws Exception {
        String type = args[0];
        File fastaAlignmentFile = new File(args[1]);
        File outputFile = new File(args[2]);
        Map<String, String> sequenceMap = TestAmbiguity0620.parseAlignmentFile(fastaAlignmentFile, type);
        StringBuilder stringBuffer = new StringBuilder();
        List<AlignmentPosition> positions = ParseAlignments.buildCommonSites(sequenceMap);
        stringBuffer.append("CommonPosition\t").append("CommonAllele\t").append("CommonCount\t").append("DiffAllele/Count\t").append("UnknownCount\n");
        for (AlignmentPosition p : positions) {
            stringBuffer.append(p.getIndex()).append("\t").append(p.getCommon()).append("\t").append(p.getCommonCount()).append("\t").append(ParseAlignments.formatDiffMap(p.getDiffMap())).append("\t").append(p.getUnknownCount()).append("\n");
        }
        FileManager.writeTextFile(outputFile, stringBuffer.toString(), true);
    }

    private static String formatDiffMap(Map<String, Integer> diffMap) {
        StringBuilder builder = new StringBuilder();
        for (String call : diffMap.keySet()) {
            builder.append(call).append("-").append(diffMap.get(call)).append(",");
        }
        return builder.toString();
    }

    private static List<AlignmentPosition> buildCommonSites(Map<String, String> sequenceMap) {
        ArrayList<AlignmentPosition> positions = new ArrayList<AlignmentPosition>();
        String call = null;
        int i = 0;
        while (i < FULL_SIZE) {
            AlignmentPosition alignmentPosition = new AlignmentPosition();
            HashMap<String, Integer> statsMap = new HashMap<String, Integer>();
            for (String seq : sequenceMap.values()) {
                if (i >= seq.length()) continue;
                call = String.valueOf(seq.charAt(i));
                if (i == 4 && call.equals("I")) {
                    System.out.println(seq);
                }
                int count = 1;
                if (statsMap.containsKey(call)) {
                    count = (Integer)statsMap.get(call) + 1;
                }
                statsMap.put(call, count);
            }
            alignmentPosition.setStatsMap(statsMap);
            if (ParseAlignments.isCommonSite(alignmentPosition)) {
                alignmentPosition.setIndex(i + 1);
                positions.add(alignmentPosition);
            }
            ++i;
        }
        return positions;
    }

    private static boolean isCommonSite(AlignmentPosition alignmentPosition) {
        Map<String, Integer> statsMap = alignmentPosition.getStatsMap();
        int max = 0;
        int unknown = 0;
        String common = null;
        for (String call : statsMap.keySet()) {
            if (call.equals("*")) {
                unknown = statsMap.get(call);
                continue;
            }
            if (statsMap.get(call) <= max) continue;
            max = statsMap.get(call);
            common = call;
        }
        int totalDiff = 0;
        HashMap<String, Integer> diffMap = new HashMap<String, Integer>();
        for (String call : statsMap.keySet()) {
            if (call.equals("*") || call.equals(common)) continue;
            if (statsMap.get(call) > DIFF_CUTOFF) {
                return false;
            }
            diffMap.put(call, statsMap.get(call));
            totalDiff += statsMap.get(call).intValue();
        }
        alignmentPosition.setCommon(common);
        alignmentPosition.setCommonCount(statsMap.get(common));
        alignmentPosition.setDiffCount(totalDiff);
        alignmentPosition.setDiffMap(diffMap);
        alignmentPosition.setUnknownCount(unknown);
        return true;
    }
}

