/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class ObjectDecorator
implements Serializable {
    private static final long serialVersionUID = 330168159231672058L;
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String EQUALS = "=";
    private static final String DELIMITER = ", ";
    private static final String NAME_DELIMITER = "\n";
    private static final String BEGIN_STRING = "{";
    private static final String END_STRING = "}";

    private ObjectDecorator() {
    }

    public static Object copy(Object instance) {
        return ObjectDecorator.toObject(ObjectDecorator.toBytes(instance, false), false);
    }

    public static byte[] compress(Object instance) {
        return ObjectDecorator.toBytes(instance, true);
    }

    public static Object decompress(byte[] compressedObject) {
        return ObjectDecorator.toObject(compressedObject, true);
    }

    public static String toString(Object instance) {
        StringBuffer stringBuffer = new StringBuffer(BEGIN_STRING).append(instance.getClass().getName().toUpperCase()).append(NAME_DELIMITER);
        try {
            Method[] methods = instance.getClass().getMethods();
            int i = 0;
            while (i < methods.length) {
                String methodName = methods[i].getName();
                if (methodName.startsWith(GET) || methodName.startsWith(IS)) {
                    stringBuffer.append(methodName).append(EQUALS);
                    stringBuffer.append(String.valueOf(methods[i].invoke(instance, new Object[0]))).append(DELIMITER);
                }
                ++i;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return stringBuffer.replace(stringBuffer.length() - DELIMITER.length(), stringBuffer.length(), END_STRING).toString();
    }

    private static byte[] toBytes(Object object, boolean isCompressed) {
        byte[] bytes;
        block20: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            bytes = null;
            try {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    objectOutputStream = new ObjectOutputStream(isCompressed ? new BufferedOutputStream(new GZIPOutputStream(byteArrayOutputStream)) : new BufferedOutputStream(byteArrayOutputStream));
                    objectOutputStream.writeObject(object);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    bytes = byteArrayOutputStream.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (byteArrayOutputStream == null) break block20;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object toObject(byte[] bytes, boolean isCompressed) {
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(isCompressed ? new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes))) : new BufferedInputStream(new ByteArrayInputStream(bytes)));
                object = objectInputStream.readObject();
                objectInputStream.close();
                return object;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (objectInputStream == null) return object;
                try {
                    objectInputStream.close();
                    return object;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return object;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                if (objectInputStream == null) return object;
                try {
                    objectInputStream.close();
                    return object;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return object;
            }
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

