/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class DrawSequence {
    private static final String PNG = "png";
    private static final double MIN_NUMBER = 5.0;
    private static final double MAX_NUMBER = 10.0;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_HEIGHT = 500;
    private static final int IMAGE_SEQUENCE_POSITION = 100;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int AMPLICON_BAR_HEIGHT = 5;
    private static final int MARKER_HEIGHT = 8;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 74;
    private static final int LETTER_WIDTH = 8;
    private static final int[] AMPLICON_POSITION = new int[]{125, 145, 165, 185};
    private static final int PRIMER_POSITION = 300;
    private static final int GENE_NOTE = 50;
    private static final int EXON_NOTE = 70;
    private static final int PRIMER_NOTE = 90;
    private static final int SNP_POINT_WIDTH = 1;
    private static final int IMAGE_UNIT = 100;
    private static final int NORMAL_SEQUENCE_UNIT = 10000;
    private static final int MAX_IMAGE_WIDTH = 65500;
    private static final int SEQUENCE_SIZE = 140000;
    private static final int SHIFTING_UNIT = 4;
    private static final int OFF_SET = 0;
    private static final Color[] colors = new Color[]{Color.CYAN, Color.GREEN, Color.GRAY, Color.BLUE, Color.DARK_GRAY};
    private static final Color GENE_COLOR = colors[1];
    private static final Color EXON_COLOR = Color.RED;
    private static final Color PRIMER_COLOR = Color.ORANGE;
    private static final Color OVERLAP_COLOR = Color.BLUE;
    private BufferedImage bufferedImage;
    private Graphics2D graphics2D;
    private int imageWidth;
    private boolean useDefault;
    private double unit;
    private int num;
    private int sequenceUnit;
    private Map<String, int[]> geneExonMap;
    private Map<String, Integer> primerMap;
    private Map<String, File> coverageMap;
    private File geneExonFile;
    private File primerFile;
    private File coverageDir;
    private File outputFile;

    public DrawSequence(File geneExonFile, File primerFile, File coverageDir, File outputFile) {
        this.geneExonFile = geneExonFile;
        this.primerFile = primerFile;
        this.coverageDir = coverageDir;
        this.outputFile = outputFile;
    }

    public void generateImage() {
        System.out.println("initializeBufferedImage");
        this.initializeBufferedImage();
        System.out.println("initializeGraphics2D");
        this.initializeGraphics2D();
        System.out.println("drawSequence");
        this.drawSequence();
        System.out.println("getGeneExonMap");
        this.getGeneExonMap(this.geneExonFile);
        System.out.println("drawGeneExon");
        this.drawGeneExon();
        System.out.println("getPrimerMap");
        this.getCoverageMap(this.coverageDir);
        System.out.println("drawCoverage");
        this.drawCoverage();
        System.out.println("getPrimerMap");
        this.getPrimerMap(this.primerFile);
        System.out.println("drawPrimer");
        this.drawPrimer();
        System.out.println("writeImageToFile");
        this.writeImageToFile(this.outputFile);
    }

    private void getCoverageMap(File inputFile) {
        this.coverageMap = new HashMap<String, File>();
        File[] files = this.coverageDir.listFiles();
        String name = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            name = file.getName().split("\\.")[0];
            this.coverageMap.put(name, file);
            ++n2;
        }
    }

    private void getPrimerMap(File inputFile) {
        this.primerMap = new LinkedHashMap<String, Integer>();
        String[] data = FileManager.readTextFile(inputFile).split("\n");
        int i = 1;
        while (i < data.length) {
            String[] item = data[i].split(",");
            this.primerMap.put(item[0].trim(), new Integer(item[2].trim()));
            ++i;
        }
    }

    private void getGeneExonMap(File inputFile) {
        this.geneExonMap = new LinkedHashMap<String, int[]>();
        String[] data = FileManager.readTextFile(inputFile).split("\n");
        int i = 1;
        while (i < data.length) {
            String[] item = data[i].split("\t");
            int[] fromTo = new int[]{new Integer(item[1].trim()), new Integer(item[2].trim())};
            this.geneExonMap.put(item[0].trim(), fromTo);
            ++i;
        }
    }

    private void writeImageToFile(File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName(PNG).next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(this.bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }

    private void drawPrimer() {
        int length = 140000;
        this.graphics2D.setColor(Color.ORANGE);
        this.graphics2D.drawRect(30, 90, 2, 8);
        this.graphics2D.fillRect(30, 90, 2, 8);
        this.graphics2D.setColor(Color.DARK_GRAY);
        this.graphics2D.drawString("Primer", 42, 98);
        String name2 = null;
        for (String name2 : this.primerMap.keySet()) {
            int position = this.primerMap.get(name2);
            int x = 0;
            x = this.useDefault ? Math.round(new Float(new Double(1000.0) / new Double(length) * (double)position).floatValue()) : position * 100 / this.sequenceUnit;
            this.graphics2D.setColor(Color.ORANGE);
            this.graphics2D.drawRect(x, this.bufferedImage.getHeight() - 300, 1, 8);
            this.graphics2D.fillRect(x, this.bufferedImage.getHeight() - 300, 1, 8);
        }
    }

    private void drawCoverage() {
        this.graphics2D.setColor(Color.GRAY);
        this.graphics2D.draw3DRect(150, 50, 50, 2, true);
        this.graphics2D.fill3DRect(150, 50, 50, 2, true);
        this.graphics2D.setColor(Color.DARK_GRAY);
        this.graphics2D.drawString("Individual Cell Line Coverage", 210, 60);
        this.graphics2D.setColor(OVERLAP_COLOR);
        this.graphics2D.draw3DRect(150, 70, 50, 5, true);
        this.graphics2D.fill3DRect(150, 70, 50, 5, true);
        this.graphics2D.setColor(Color.DARK_GRAY);
        this.graphics2D.drawString("Common Overlap Regions", 210, 80);
        int length = 140000;
        File map = null;
        String[] data = null;
        int yIndex = 0;
        for (String name : this.coverageMap.keySet()) {
            map = this.coverageMap.get(name);
            data = FileManager.readTextFile(map).split("\n");
            int height = 0;
            height = name.equals("OverlapCoverage") ? 5 : 2;
            int position = 0;
            position = name.equals("OverlapCoverage") ? this.bufferedImage.getHeight() - 150 : this.bufferedImage.getHeight() - 200 - yIndex * 10;
            Color color = Color.GRAY;
            if (name.equals("OverlapCoverage")) {
                color = OVERLAP_COLOR;
            }
            String[] stringArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String fromto = stringArray[n2];
                int from = new Integer(fromto.split("\\s+")[0]);
                int to = new Integer(fromto.split("\\s+")[1]);
                int x1 = 0;
                int x2 = 0;
                if (this.useDefault) {
                    x1 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)from).floatValue());
                    x2 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)to).floatValue());
                } else {
                    x1 = from * 100 / this.sequenceUnit;
                    x2 = to * 100 / this.sequenceUnit;
                }
                this.graphics2D.setColor(color);
                this.graphics2D.draw3DRect(x1, position, x2 - x1, height, true);
                this.graphics2D.fill3DRect(x1, position, x2 - x1, height, true);
                ++n2;
            }
            if (name.equals("OverlapCoverage")) continue;
            ++yIndex;
        }
    }

    private void drawGeneExon() {
        int length = 140000;
        this.graphics2D.setColor(GENE_COLOR);
        this.graphics2D.draw3DRect(30, 50, 50, 10, true);
        this.graphics2D.fill3DRect(30, 50, 50, 10, true);
        this.graphics2D.setColor(Color.DARK_GRAY);
        this.graphics2D.drawString("Gene", 90, 60);
        this.graphics2D.setColor(EXON_COLOR);
        this.graphics2D.draw3DRect(30, 70, 50, 10, true);
        this.graphics2D.fill3DRect(30, 70, 50, 10, true);
        this.graphics2D.setColor(Color.DARK_GRAY);
        this.graphics2D.drawString("Exon", 90, 80);
        String name2 = null;
        int yIndex = 0;
        for (String name2 : this.geneExonMap.keySet()) {
            int[] positions = this.geneExonMap.get(name2);
            int from = positions[0] - 0;
            int to = positions[1] - 0;
            if (to == 0) continue;
            int x1 = 0;
            int x2 = 0;
            if (this.useDefault) {
                x1 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)from).floatValue());
                x2 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)to).floatValue());
            } else {
                x1 = from * 100 / this.sequenceUnit;
                x2 = to * 100 / this.sequenceUnit;
            }
            if (name2.startsWith("Exon")) {
                this.graphics2D.setColor(EXON_COLOR);
                this.graphics2D.draw3DRect(x1, this.bufferedImage.getHeight() - 100, x2 - x1, 10, true);
                this.graphics2D.fill3DRect(x1, this.bufferedImage.getHeight() - 100, x2 - x1, 10, true);
            } else {
                this.graphics2D.setColor(GENE_COLOR);
                this.graphics2D.draw3DRect(x1, this.bufferedImage.getHeight() - 100, x2 - x1, 10, true);
                this.graphics2D.fill3DRect(x1, this.bufferedImage.getHeight() - 100, x2 - x1, 10, true);
                this.graphics2D.setColor(Color.DARK_GRAY);
                this.graphics2D.drawString(name2, x1, this.bufferedImage.getHeight() - 100 - 10);
            }
            ++yIndex;
        }
    }

    private void drawSequence() {
        int length = 140000;
        this.graphics2D.setColor(Color.LIGHT_GRAY);
        this.graphics2D.draw3DRect(0, this.bufferedImage.getHeight() - 100, this.bufferedImage.getWidth(), 10, true);
        this.graphics2D.fill3DRect(0, this.bufferedImage.getHeight() - 100, this.bufferedImage.getWidth(), 10, true);
        this.graphics2D.setColor(Color.BLACK);
        this.graphics2D.drawLine(1, this.bufferedImage.getHeight() - 100, 1, this.bufferedImage.getHeight() - 100 + 10);
        this.graphics2D.drawString("1", 1, this.bufferedImage.getHeight() - 74);
        this.graphics2D.drawLine(this.bufferedImage.getWidth() - 1, this.bufferedImage.getHeight() - 100, this.bufferedImage.getWidth() - 1, this.bufferedImage.getHeight() - 100 + 10);
        this.graphics2D.drawString(new Integer(length + 0).toString(), this.bufferedImage.getWidth() - new Integer(length).toString().length() * 8, this.bufferedImage.getHeight() - 74);
        int x = 0;
        int index = 0;
        int i = 1;
        while (i <= this.num) {
            if (this.useDefault) {
                x = Math.round(new Float(new Double(this.imageWidth) / new Double(length) * this.unit * (double)i).floatValue());
                index = new Double(this.unit * (double)i).intValue();
            } else {
                x = 100 * i;
                index = this.sequenceUnit * i;
            }
            this.graphics2D.drawLine(x, this.bufferedImage.getHeight() - 100, x, this.bufferedImage.getHeight() - 100 + 10);
            if (i < this.num || i == this.num && ((double)length - this.unit * (double)this.num >= this.unit / 2.0 && this.useDefault || length - this.sequenceUnit * this.num >= this.sequenceUnit / 2 && !this.useDefault)) {
                this.graphics2D.drawString(String.valueOf(index + 0), x, this.bufferedImage.getHeight() - 74);
            }
            ++i;
        }
    }

    private void initializeBufferedImage() {
        this.imageWidth = 1000;
        this.unit = 100.0;
        this.useDefault = true;
        this.num = 0;
        this.imageWidth = 1400;
        this.useDefault = false;
        this.num = new Double(14.0).intValue();
        this.sequenceUnit = 10000;
        if (this.imageWidth > 65500) {
            this.imageWidth /= 2;
            this.sequenceUnit = 20000;
            this.num = new Double(140000 / this.sequenceUnit).intValue();
        }
        this.bufferedImage = new BufferedImage(this.imageWidth, 500, 9);
    }

    private void initializeGraphics2D() {
        this.graphics2D = this.bufferedImage.createGraphics();
        this.graphics2D.setBackground(Color.white);
        this.graphics2D.clearRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        this.graphics2D.setClip(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    /*
     * Unable to fully structure code
     */
    private static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }
}

