/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreateAmbPrimerSetupFiles {
    private static final String EMPTY_AMPLICON = "EmptyAmplicon";
    private static final String EMPTY_PRIMER = "EmptyF";
    private static final String HLA_A = "HLA-A";
    private static final String HLA_B_SINGLE = "HLA-B-Single";
    private static final String HLAC = "HLAC";
    private static String[] COORDINATE_X = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
    private static String[] COORDINATE_Y = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final int MAX_NUMBER = 4;
    private static final String GEMS_PRIMER_TRUE = "N";
    private static final String GEMS_PRIMER_TRUE2 = "A";
    private static final String PROTOCOL_HLA_A = "HLA-A";
    private static final String PROTOCOL_HLA_B_SINGLE = "HLA-B (CG)";
    private static final String PROTOCOL_HLA_C = "HLA-C";
    private static final String NO_HARP = "No HARP";
    public static String PRIMER_AVAILABLE = "1";
    public static String EMPTY = "";

    public static void main(String[] args) {
        String projectName = args[0];
        File ausFile = new File(args[1]);
        File gemsAFile = new File(args[2]);
        File gemsBFile = new File(args[3]);
        File gemsCFile = new File(args[4]);
        File outputDir = new File(args[5]);
        File labSetUpFile = new File(outputDir, "labSetUp.csv");
        File gemsFile = new File(outputDir, "GeMS.csv");
        File seqMMCoordFile = new File(outputDir, "seqMMCoord.csv");
        File associationFile = new File(outputDir, "association.csv");
        String[] ausData = FileManager.readTextFile(ausFile).split("\n");
        String[] gemsAData = FileManager.readTextFile(gemsAFile).split("\n");
        String[] gemsBData = FileManager.readTextFile(gemsBFile).split("\n");
        String[] gemsCData = FileManager.readTextFile(gemsCFile).split("\n");
        LinkedHashMap<String, List<String>> ausAMap = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> ausBMap = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> ausCMap = new LinkedHashMap<String, List<String>>();
        CreateAmbPrimerSetupFiles.parseAUSData(ausData, ausAMap, ausBMap, ausCMap);
        int maxASize = CreateAmbPrimerSetupFiles.getMaxPrimerSize(ausAMap);
        int maxBSize = CreateAmbPrimerSetupFiles.getMaxPrimerSize(ausBMap);
        int maxCSize = CreateAmbPrimerSetupFiles.getMaxPrimerSize(ausCMap);
        int maxAusSize = Math.max(maxASize, Math.max(maxBSize, maxCSize));
        List<String> coordLists = CreateAmbPrimerSetupFiles.getCoordinates();
        Map<String, List<String>> gemsAMap = CreateAmbPrimerSetupFiles.parseGemsData(gemsAData, "HLA-A");
        Map<String, List<String>> gemsBMap = CreateAmbPrimerSetupFiles.parseGemsData(gemsBData, HLA_B_SINGLE);
        Map<String, List<String>> gemsCMap = CreateAmbPrimerSetupFiles.parseGemsData(gemsCData, HLAC);
        List<String> allACellLinePresent = CreateAmbPrimerSetupFiles.getAllCellLine(ausAMap, gemsAMap);
        List<String> allBCellLinePresent = CreateAmbPrimerSetupFiles.getAllCellLine(ausBMap, gemsBMap);
        List<String> allCCellLinePresent = CreateAmbPrimerSetupFiles.getAllCellLine(ausCMap, gemsCMap);
        CreateAmbPrimerSetupFiles.sizeCheck(ausAMap, gemsAMap, "A Type");
        CreateAmbPrimerSetupFiles.sizeCheck(ausBMap, gemsBMap, "B Type");
        CreateAmbPrimerSetupFiles.sizeCheck(ausCMap, gemsCMap, "C Type");
        List<String> aPrimerList = CreateAmbPrimerSetupFiles.getPrimerList(gemsAData[0]);
        List<String> bPrimerList = CreateAmbPrimerSetupFiles.getPrimerList(gemsBData[0]);
        List<String> cPrimerList = CreateAmbPrimerSetupFiles.getPrimerList(gemsCData[0]);
        StringBuilder labSetUpData = new StringBuilder();
        StringBuilder gemsData = new StringBuilder();
        StringBuilder SeqMMCordData = new StringBuilder();
        StringBuilder associationData = new StringBuilder();
        int counter = CreateAmbPrimerSetupFiles.addLabSetUpAPart(allACellLinePresent, projectName, ausAMap, maxAusSize, coordLists, gemsAMap, aPrimerList, labSetUpData);
        int counter2 = CreateAmbPrimerSetupFiles.addGemsAPart(allACellLinePresent, projectName, ausAMap, maxAusSize, coordLists, gemsAMap, aPrimerList, gemsData);
        int counter3 = CreateAmbPrimerSetupFiles.addSeqCoordAPart(allACellLinePresent, projectName, ausAMap, maxAusSize, coordLists, gemsAMap, aPrimerList, SeqMMCordData);
        counter = CreateAmbPrimerSetupFiles.addLabSetUpBPart(allBCellLinePresent, projectName, ausBMap, maxAusSize, coordLists, gemsBMap, bPrimerList, labSetUpData, counter);
        counter2 = CreateAmbPrimerSetupFiles.addGemsBPart(allBCellLinePresent, projectName, ausBMap, maxAusSize, coordLists, gemsBMap, bPrimerList, gemsData, counter2);
        counter3 = CreateAmbPrimerSetupFiles.addSeqCoordBPart(allBCellLinePresent, projectName, ausBMap, maxAusSize, coordLists, gemsBMap, bPrimerList, SeqMMCordData, counter3);
        CreateAmbPrimerSetupFiles.addLabSetUpCPart(allCCellLinePresent, projectName, ausCMap, maxAusSize, coordLists, gemsCMap, cPrimerList, labSetUpData, counter);
        CreateAmbPrimerSetupFiles.addGemsCPart(allCCellLinePresent, projectName, ausCMap, maxAusSize, coordLists, gemsCMap, cPrimerList, gemsData, counter2);
        CreateAmbPrimerSetupFiles.addSeqCoordCPart(allCCellLinePresent, projectName, ausCMap, maxAusSize, coordLists, gemsCMap, cPrimerList, SeqMMCordData, counter3);
        CreateAmbPrimerSetupFiles.buildAssociationData(allACellLinePresent, allBCellLinePresent, allCCellLinePresent, projectName, ausAMap, ausBMap, ausCMap, coordLists, gemsAMap, gemsBMap, gemsCMap, associationData);
        FileManager.writeTextFile(labSetUpFile, labSetUpData.toString(), true);
        FileManager.writeTextFile(gemsFile, gemsData.toString(), true);
        FileManager.writeTextFile(seqMMCoordFile, SeqMMCordData.toString(), true);
        FileManager.writeTextFile(associationFile, associationData.toString(), true);
        System.out.println("done");
    }

    private static String fixName(String name) {
        return name.split("-")[0];
    }

    private static void buildAssociationData(List<String> allACellLinePresent, List<String> allBCellLinePresent, List<String> allCCellLinePresent, String projectName, Map<String, List<String>> ausAMap, Map<String, List<String>> ausBMap, Map<String, List<String>> ausCMap, List<String> coordLists, Map<String, List<String>> gemsAMap, Map<String, List<String>> gemsBMap, Map<String, List<String>> gemsCMap, StringBuilder associationData) {
        associationData.append("Cell Line,PCR Plate,PCR Coord,Sequencing Plate,Seq Coord,Lab Seq Primer\n");
        String plateName = null;
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        PcrPlateCoord pcrPlateCoord = null;
        int i = 0;
        while (i < 4) {
            int ausSize;
            int coord_index = 0;
            plateName = String.valueOf(CreateAmbPrimerSetupFiles.fixName(projectName)) + "-" + "Resolving" + "_" + (i + 1) + "F";
            for (String cellLine : allACellLinePresent) {
                pcrPlateCoord = CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, "HLA-A", "HLA-A");
                associationData.append(cellLine).append(",");
                associationData.append(pcrPlateCoord.getPlate()).append(",");
                associationData.append(pcrPlateCoord.getCoord()).append(",");
                associationData.append(plateName).append(",");
                associationData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, coord_index)).append(",");
                ausPrimers = ausAMap.get(cellLine);
                if (ausPrimers == null) {
                    ausPrimers = new ArrayList<String>();
                    ausPrimers.add(NO_HARP);
                }
                if ((gemsPrimers = gemsAMap.get(cellLine)) == null) {
                    gemsPrimers = new ArrayList<String>();
                }
                if ((ausSize = ausPrimers.size()) > i) {
                    associationData.append(ausPrimers.get(i).equalsIgnoreCase(NO_HARP) ? EMPTY_AMPLICON : ausPrimers.get(i)).append(",");
                } else if (ausSize + gemsPrimers.size() > i) {
                    associationData.append(gemsPrimers.get(i - ausSize)).append(",");
                } else {
                    associationData.append(EMPTY_AMPLICON).append(",");
                }
                associationData.append("\n");
                ++coord_index;
            }
            for (String cellLine : allBCellLinePresent) {
                pcrPlateCoord = CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, HLA_B_SINGLE, PROTOCOL_HLA_B_SINGLE);
                associationData.append(cellLine).append(",");
                associationData.append(pcrPlateCoord.getPlate()).append(",");
                associationData.append(pcrPlateCoord.getCoord()).append(",");
                associationData.append(plateName).append(",");
                associationData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, coord_index)).append(",");
                ausPrimers = ausBMap.get(cellLine);
                if (ausPrimers == null) {
                    ausPrimers = new ArrayList<String>();
                    ausPrimers.add(NO_HARP);
                }
                if ((gemsPrimers = gemsBMap.get(cellLine)) == null) {
                    gemsPrimers = new ArrayList<String>();
                }
                if ((ausSize = ausPrimers.size()) > i) {
                    associationData.append(ausPrimers.get(i).equalsIgnoreCase(NO_HARP) ? EMPTY_AMPLICON : ausPrimers.get(i)).append(",");
                } else if (ausSize + gemsPrimers.size() > i) {
                    associationData.append(gemsPrimers.get(i - ausSize)).append(",");
                } else {
                    associationData.append(EMPTY_AMPLICON).append(",");
                }
                associationData.append("\n");
                ++coord_index;
            }
            for (String cellLine : allCCellLinePresent) {
                pcrPlateCoord = CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, HLAC, PROTOCOL_HLA_C);
                associationData.append(cellLine).append(",");
                associationData.append(pcrPlateCoord.getPlate()).append(",");
                associationData.append(pcrPlateCoord.getCoord()).append(",");
                associationData.append(plateName).append(",");
                associationData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, coord_index)).append(",");
                ausPrimers = ausCMap.get(cellLine);
                if (ausPrimers == null) {
                    ausPrimers = new ArrayList<String>();
                    ausPrimers.add(NO_HARP);
                }
                if ((gemsPrimers = gemsCMap.get(cellLine)) == null) {
                    gemsPrimers = new ArrayList<String>();
                }
                if ((ausSize = ausPrimers.size()) > i) {
                    associationData.append(ausPrimers.get(i).equalsIgnoreCase(NO_HARP) ? EMPTY_AMPLICON : ausPrimers.get(i)).append(",");
                } else if (ausSize + gemsPrimers.size() > i) {
                    associationData.append(gemsPrimers.get(i - ausSize)).append(",");
                } else {
                    associationData.append(EMPTY_AMPLICON).append(",");
                }
                associationData.append("\n");
                ++coord_index;
            }
            ++i;
        }
    }

    private static List<String> getAllCellLine(Map<String, List<String>> ausMap, Map<String, List<String>> gemsMap) {
        ArrayList<String> list = new ArrayList<String>();
        CreateAmbPrimerSetupFiles.addToList(ausMap, list);
        CreateAmbPrimerSetupFiles.addToList(gemsMap, list);
        return list;
    }

    private static void addToList(Map<String, List<String>> map, List<String> list) {
        for (String cellLine : map.keySet()) {
            if (list.contains(cellLine)) continue;
            list.add(cellLine);
        }
    }

    private static void addSeqCoordCPart(List<String> allCCellLinePresent, String projectName, Map<String, List<String>> ausCMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsCMap, List<String> cPrimerList, StringBuilder seqCoordData, int counter) {
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        for (String cellLine : allCCellLinePresent) {
            gemsPrimers = gemsCMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
            }
            if ((ausPrimers = ausCMap.get(cellLine)) == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
            }
            for (String primer : ausPrimers) {
                if (primer.equalsIgnoreCase(NO_HARP) || primer.equalsIgnoreCase("")) {
                    seqCoordData.append(EMPTY).append(",");
                } else {
                    seqCoordData.append(PRIMER_AVAILABLE).append(",");
                }
                seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
            }
            int i = 0;
            while (i < Math.min(4 - ausPrimers.size(), gemsPrimers.size())) {
                seqCoordData.append(PRIMER_AVAILABLE).append(",");
                seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (ausPrimers.size() + gemsPrimers.size() < 4) {
                i = 0;
                while (i < 4 - ausPrimers.size() - gemsPrimers.size()) {
                    seqCoordData.append(EMPTY).append(",");
                    seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            seqCoordData.append("\n");
            ++counter;
        }
    }

    private static void addGemsCPart(List<String> allCCellLinePresent, String projectName, Map<String, List<String>> ausCMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsCMap, List<String> cPrimerList, StringBuilder gemsData, int counter) {
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        for (String cellLine : allCCellLinePresent) {
            gemsPrimers = gemsCMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
                gemsData.append(",");
            } else {
                gemsData.append(cellLine).append(",");
            }
            ausPrimers = ausCMap.get(cellLine);
            if (ausPrimers == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
                gemsData.append(",");
            } else {
                gemsData.append(cellLine).append(",");
            }
            gemsData.append(cellLine).append(",");
            gemsData.append(HLAC).append(",");
            gemsData.append(CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, HLAC, PROTOCOL_HLA_C).getCoord()).append(",");
            for (String primer : ausPrimers) {
                gemsData.append(primer.equals("") ? EMPTY_PRIMER : primer).append(",");
                gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
            }
            int i = 0;
            while (i < Math.min(4 - ausPrimers.size(), gemsPrimers.size())) {
                gemsData.append(gemsPrimers.get(i)).append(",");
                gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (ausPrimers.size() + gemsPrimers.size() < 4) {
                i = 0;
                while (i < 4 - ausPrimers.size() - gemsPrimers.size()) {
                    gemsData.append(EMPTY_PRIMER).append(",");
                    gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            gemsData.append("\n");
            ++counter;
        }
    }

    private static void addLabSetUpCPart(List<String> allCCellLinePresent, String projectName, Map<String, List<String>> ausCMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsCMap, List<String> cPrimerList, StringBuilder labSetUpData, int counter) {
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        labSetUpData.append(",,,,,");
        int i = 0;
        while (i < maxAusSize) {
            labSetUpData.append(",,");
            ++i;
        }
        for (String primer : cPrimerList) {
            labSetUpData.append(primer).append(",,");
        }
        labSetUpData.append("\n");
        for (String cellLine : allCCellLinePresent) {
            gemsPrimers = gemsCMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
                labSetUpData.append(",");
            } else {
                labSetUpData.append(cellLine).append(",");
            }
            ausPrimers = ausCMap.get(cellLine);
            if (ausPrimers == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
                labSetUpData.append(",");
            } else {
                labSetUpData.append(cellLine).append(",");
            }
            labSetUpData.append(cellLine).append(",");
            labSetUpData.append(HLAC).append(",");
            labSetUpData.append(CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, HLAC, PROTOCOL_HLA_C).getCoord()).append(",");
            int i2 = 0;
            while (i2 < maxAusSize) {
                labSetUpData.append(ausPrimers.size() > i2 ? ausPrimers.get(i2) : "").append(",");
                labSetUpData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i2;
            }
            gemsPrimers = gemsCMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
            }
            for (String cPrimer : cPrimerList) {
                if (gemsPrimers.contains(cPrimer)) {
                    int index = CreateAmbPrimerSetupFiles.getAusPrimerSize(ausPrimers) + gemsPrimers.indexOf(cPrimer) + 1;
                    if (index > 4) {
                        labSetUpData.append(",");
                    } else {
                        labSetUpData.append(index).append(",");
                    }
                } else {
                    labSetUpData.append(",");
                }
                labSetUpData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
            }
            labSetUpData.append("\n");
            ++counter;
        }
    }

    private static int addSeqCoordBPart(List<String> allBCellLinePresent, String projectName, Map<String, List<String>> ausBMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsBMap, List<String> bPrimerList, StringBuilder seqCoordData, int counter) {
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        for (String cellLine : allBCellLinePresent) {
            gemsPrimers = gemsBMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
            }
            if ((ausPrimers = ausBMap.get(cellLine)) == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
            }
            for (String primer : ausPrimers) {
                if (primer.equalsIgnoreCase(NO_HARP) || primer.equalsIgnoreCase("")) {
                    seqCoordData.append(EMPTY).append(",");
                } else {
                    seqCoordData.append(PRIMER_AVAILABLE).append(",");
                }
                seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
            }
            int i = 0;
            while (i < Math.min(4 - ausPrimers.size(), gemsPrimers.size())) {
                seqCoordData.append(PRIMER_AVAILABLE).append(",");
                seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (ausPrimers.size() + gemsPrimers.size() < 4) {
                i = 0;
                while (i < 4 - ausPrimers.size() - gemsPrimers.size()) {
                    seqCoordData.append(EMPTY).append(",");
                    seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            seqCoordData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static int addGemsBPart(List<String> allBCellLinePresent, String projectName, Map<String, List<String>> ausBMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsBMap, List<String> bPrimerList, StringBuilder gemsData, int counter) {
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        for (String cellLine : allBCellLinePresent) {
            gemsPrimers = gemsBMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
                gemsData.append(",");
            } else {
                gemsData.append(cellLine).append(",");
            }
            ausPrimers = ausBMap.get(cellLine);
            if (ausPrimers == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
                gemsData.append(",");
            } else {
                gemsData.append(cellLine).append(",");
            }
            gemsData.append(cellLine).append(",");
            gemsData.append(HLA_B_SINGLE).append(",");
            gemsData.append(CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, HLA_B_SINGLE, PROTOCOL_HLA_B_SINGLE).getCoord()).append(",");
            for (String primer : ausPrimers) {
                gemsData.append(primer.equals("") ? EMPTY_PRIMER : primer).append(",");
                gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
            }
            int i = 0;
            while (i < Math.min(4 - ausPrimers.size(), gemsPrimers.size())) {
                gemsData.append(gemsPrimers.get(i)).append(",");
                gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (ausPrimers.size() + gemsPrimers.size() < 4) {
                i = 0;
                while (i < 4 - ausPrimers.size() - gemsPrimers.size()) {
                    gemsData.append(EMPTY_PRIMER).append(",");
                    gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            gemsData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static int addLabSetUpBPart(List<String> allBCellLinePresent, String projectName, Map<String, List<String>> ausBMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsBMap, List<String> bPrimerList, StringBuilder labSetUpData, int counter) {
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        labSetUpData.append(",,,,,");
        int i = 0;
        while (i < maxAusSize) {
            labSetUpData.append(",,");
            ++i;
        }
        for (String primer : bPrimerList) {
            labSetUpData.append(primer).append(",,");
        }
        labSetUpData.append("\n");
        for (String cellLine : allBCellLinePresent) {
            gemsPrimers = gemsBMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
                labSetUpData.append(",");
            } else {
                labSetUpData.append(cellLine).append(",");
            }
            ausPrimers = ausBMap.get(cellLine);
            if (ausPrimers == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
                labSetUpData.append(",");
            } else {
                labSetUpData.append(cellLine).append(",");
            }
            labSetUpData.append(cellLine).append(",");
            labSetUpData.append(HLA_B_SINGLE).append(",");
            labSetUpData.append(CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, HLA_B_SINGLE, PROTOCOL_HLA_B_SINGLE).getCoord()).append(",");
            int i2 = 0;
            while (i2 < maxAusSize) {
                labSetUpData.append(ausPrimers.size() > i2 ? ausPrimers.get(i2) : "").append(",");
                labSetUpData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i2;
            }
            for (String bPrimer : bPrimerList) {
                if (gemsPrimers.contains(bPrimer)) {
                    int index = CreateAmbPrimerSetupFiles.getAusPrimerSize(ausPrimers) + gemsPrimers.indexOf(bPrimer) + 1;
                    if (index > 4) {
                        labSetUpData.append(",");
                    } else {
                        labSetUpData.append(index).append(",");
                    }
                } else {
                    labSetUpData.append(",");
                }
                labSetUpData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
            }
            labSetUpData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static int addSeqCoordAPart(List<String> allACellLinePresent, String projectName, Map<String, List<String>> ausAMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsAMap, List<String> aPrimerList, StringBuilder seqCoordData) {
        seqCoordData.append(",,,,,,,,\n");
        seqCoordData.append(",Plate1,,plate2,,Plate3,,Plate4,\n");
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        int counter = 0;
        for (String cellLine : allACellLinePresent) {
            gemsPrimers = gemsAMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
            }
            if ((ausPrimers = ausAMap.get(cellLine)) == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
            }
            if (ausPrimers.size() == 0) {
                ausPrimers.add(NO_HARP);
            }
            int i = 0;
            while (i < ausPrimers.size()) {
                if (ausPrimers.get(0).equalsIgnoreCase(NO_HARP) || ausPrimers.get(0).equalsIgnoreCase("")) {
                    seqCoordData.append(EMPTY).append(",");
                } else {
                    seqCoordData.append(PRIMER_AVAILABLE).append(",");
                }
                seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            i = 0;
            while (i < Math.min(4 - ausPrimers.size(), gemsPrimers.size())) {
                seqCoordData.append(PRIMER_AVAILABLE).append(",");
                seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (ausPrimers.size() + gemsPrimers.size() < 4) {
                i = 0;
                while (i < 4 - ausPrimers.size() - gemsPrimers.size()) {
                    seqCoordData.append(EMPTY).append(",");
                    seqCoordData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            seqCoordData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static int addGemsAPart(List<String> allACellLinePresent, String projectName, Map<String, List<String>> ausAMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsAMap, List<String> aPrimerList, StringBuilder gemsData) {
        gemsData.append("Lab,AUS,Combined,,PCR Coord,");
        int i = 0;
        while (i < 4) {
            gemsData.append(",Seq Coord,");
            ++i;
        }
        gemsData.append("\n");
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        Object aPrimer = null;
        int counter = 0;
        for (String cellLine : allACellLinePresent) {
            gemsPrimers = gemsAMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
                gemsData.append(",");
            } else {
                gemsData.append(cellLine).append(",");
            }
            ausPrimers = ausAMap.get(cellLine);
            if (ausPrimers == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
                gemsData.append(",");
            } else {
                gemsData.append(cellLine).append(",");
            }
            gemsData.append(cellLine).append(",");
            gemsData.append("HLA-A").append(",");
            gemsData.append(CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, "HLA-A", "HLA-A").getCoord()).append(",");
            int i2 = 0;
            while (i2 < ausPrimers.size()) {
                gemsData.append(ausPrimers.get(i2).equals("") ? EMPTY_PRIMER : ausPrimers.get(i2)).append(",");
                gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i2;
            }
            i2 = 0;
            while (i2 < Math.min(4 - ausPrimers.size(), gemsPrimers.size())) {
                gemsData.append(gemsPrimers.get(i2)).append(",");
                gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i2;
            }
            if (ausPrimers.size() + gemsPrimers.size() < 4) {
                i2 = 0;
                while (i2 < 4 - ausPrimers.size() - gemsPrimers.size()) {
                    gemsData.append(EMPTY_PRIMER).append(",");
                    gemsData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                    ++i2;
                }
            }
            gemsData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static int addLabSetUpAPart(List<String> allACellLinePresent, String projectName, Map<String, List<String>> ausAMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsAMap, List<String> aPrimerList, StringBuilder labSetUpData) {
        labSetUpData.append("Lab,AUS,Combined,,PCR Coord,");
        int i = 0;
        while (i < maxAusSize) {
            labSetUpData.append(",Seq Coord,");
            ++i;
        }
        for (String primer : aPrimerList) {
            labSetUpData.append(primer).append(",Seq Coord,");
        }
        labSetUpData.append("\n");
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        int counter = 0;
        for (String cellLine : allACellLinePresent) {
            gemsPrimers = gemsAMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
                labSetUpData.append(",");
            } else {
                labSetUpData.append(cellLine).append(",");
            }
            ausPrimers = ausAMap.get(cellLine);
            if (ausPrimers == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
                labSetUpData.append(",");
            } else {
                labSetUpData.append(cellLine).append(",");
            }
            labSetUpData.append(cellLine).append(",");
            labSetUpData.append("HLA-A").append(",");
            labSetUpData.append(CreateAmbPrimerSetupFiles.getPCRCoordinate(projectName, cellLine, "HLA-A", "HLA-A").getCoord()).append(",");
            int i2 = 0;
            while (i2 < maxAusSize) {
                labSetUpData.append(ausPrimers.size() > i2 ? ausPrimers.get(i2) : "").append(",");
                labSetUpData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
                ++i2;
            }
            for (String aPrimer : aPrimerList) {
                if (gemsPrimers.contains(aPrimer)) {
                    int index = CreateAmbPrimerSetupFiles.getAusPrimerSize(ausPrimers) + gemsPrimers.indexOf(aPrimer) + 1;
                    if (index > 4) {
                        labSetUpData.append(",");
                    } else {
                        labSetUpData.append(index).append(",");
                    }
                } else {
                    labSetUpData.append(",");
                }
                labSetUpData.append(CreateAmbPrimerSetupFiles.getThisCoordinate(coordLists, counter)).append(",");
            }
            labSetUpData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static String getThisCoordinate(List<String> coordLists, int counter) {
        if (counter >= coordLists.size()) {
            return "Unknown Coord";
        }
        return coordLists.get(counter);
    }

    private static int getAusPrimerSize(List<String> primers) {
        if (primers.size() == 1 && primers.get(0).equalsIgnoreCase(NO_HARP)) {
            return 1;
        }
        return primers.size();
    }

    private static List<String> getCoordinates() {
        ArrayList<String> coordLists = new ArrayList<String>();
        String[] stringArray = COORDINATE_Y;
        int n = COORDINATE_Y.length;
        int n2 = 0;
        while (n2 < n) {
            String y = stringArray[n2];
            String[] stringArray2 = COORDINATE_X;
            int n3 = COORDINATE_X.length;
            int n4 = 0;
            while (n4 < n3) {
                String x = stringArray2[n4];
                coordLists.add(String.valueOf(x) + y);
                ++n4;
            }
            ++n2;
        }
        return coordLists;
    }

    private static PcrPlateCoord getPCRCoordinate(String projectName, String cellLine, String amplicon, String pcrProtocolName) {
        String url = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        String query1 = "select distinct parent_experiment_id, parent_coordinate_id from pcr.chromat_report_mv where cell_line_name ilike ? and project_name=? and amplicon_name=? and pcr_protocol_name=?";
        String query2 = "select plate_name from pcr.experiment where experiment_id=?";
        String query3 = "select coordinate from pcr.plate_coord where plate_coord_id = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement3 = null;
        ResultSet resultSet3 = null;
        PcrPlateCoord pcrPlateCoord = new PcrPlateCoord();
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            preparedStatement = db.prepareStatement(query1);
            preparedStatement.setString(1, cellLine);
            preparedStatement.setString(2, projectName);
            preparedStatement.setString(3, amplicon);
            preparedStatement.setString(4, pcrProtocolName);
            resultSet = preparedStatement.executeQuery();
            String parent_experiment_id = null;
            String parent_coordinate_id = null;
            if (resultSet.next()) {
                parent_experiment_id = resultSet.getString(1);
                parent_coordinate_id = resultSet.getString(2);
                preparedStatement2 = db.prepareStatement(query2);
                preparedStatement2.setString(1, parent_experiment_id);
                resultSet2 = preparedStatement2.executeQuery();
                preparedStatement3 = db.prepareStatement(query3);
                preparedStatement3.setString(1, parent_coordinate_id);
                resultSet3 = preparedStatement3.executeQuery();
                if (resultSet2.next()) {
                    pcrPlateCoord.setPlate(resultSet2.getString(1));
                }
                if (resultSet3.next()) {
                    pcrPlateCoord.setCoord(resultSet3.getString(1));
                }
            } else {
                System.out.println("Error : no pcr coordinate record for " + cellLine + " " + amplicon);
            }
            if (resultSet.next()) {
                System.out.println("Error : multiple pcr coordinate record for " + cellLine + " " + amplicon);
            }
            CreateAmbPrimerSetupFiles.closeResources(resultSet3, preparedStatement3, null);
            CreateAmbPrimerSetupFiles.closeResources(resultSet2, preparedStatement2, null);
            CreateAmbPrimerSetupFiles.closeResources(resultSet, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        return pcrPlateCoord;
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }

    private static void sizeCheck(Map<String, List<String>> map1, Map<String, List<String>> map2, String type) {
        if (map1.size() != map2.size()) {
            System.out.println("Warning: sample size different in " + type + " " + map1.size() + " : " + map2.size());
        }
    }

    private static List<String> getPrimerList(String headerLine) {
        String[] info;
        ArrayList<String> primers = new ArrayList<String>();
        String[] stringArray = info = headerLine.split(",");
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String primer = stringArray[n2];
            if (primer.trim().length() > 0) {
                primers.add(primer.trim());
            }
            ++n2;
        }
        return primers;
    }

    private static int getMaxPrimerSize(Map<String, List<String>> ausMap) {
        int max = 0;
        for (List<String> list : ausMap.values()) {
            if (list.size() <= max) continue;
            max = list.size();
        }
        return max;
    }

    private static void parseAUSData(String[] ausData, Map<String, List<String>> ausAMap, Map<String, List<String>> ausBMap, Map<String, List<String>> ausCMap) {
        String[] stringArray = ausData;
        int n = ausData.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] info = line.split(",");
                if (info.length < 2) {
                    System.out.println("skip line in aus file: " + line);
                } else if (line.indexOf("HLA-A") > 0) {
                    CreateAmbPrimerSetupFiles.addAusEntry(info, ausAMap);
                } else if (line.indexOf(HLA_B_SINGLE) > 0) {
                    CreateAmbPrimerSetupFiles.addAusEntry(info, ausBMap);
                } else if (line.indexOf(HLAC) > 0) {
                    CreateAmbPrimerSetupFiles.addAusEntry(info, ausCMap);
                } else {
                    System.out.println("Error : unknown HLA type > " + line.indexOf(HLA_B_SINGLE) + " " + line);
                }
            }
            ++n2;
        }
    }

    private static void addAusEntry(String[] info, Map<String, List<String>> ausMap) {
        ausMap.put(info[0].trim(), new ArrayList());
        if (info.length >= 3) {
            int i = 2;
            while (i < info.length) {
                if (info[i].trim().length() > 0) {
                    ausMap.get(info[0].trim()).add(info[i].trim());
                }
                ++i;
            }
        }
    }

    private static Map<String, List<String>> parseGemsData(String[] gemsData, String amplicon) {
        LinkedHashMap<String, List<String>> gemsMap = new LinkedHashMap<String, List<String>>();
        String[] header = gemsData[0].split(",");
        int i = 1;
        while (i < gemsData.length) {
            if (gemsData[i].indexOf(amplicon) < 0) {
                System.out.println("Warning skip b/c no " + amplicon + " find " + gemsData[i]);
            } else {
                String[] info = gemsData[i].split(",");
                gemsMap.put(info[0].trim(), new ArrayList());
                int j = 2;
                while (j < info.length) {
                    if (info[j].trim().equals(GEMS_PRIMER_TRUE) || info[j].trim().equals(GEMS_PRIMER_TRUE2)) {
                        ((List)gemsMap.get(info[0].trim())).add(header[j].trim());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return gemsMap;
    }
}

