/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComplarePoly {
    public static final double PEAK_CUTOFF = 0.2;
    public static int SHIFT = 5;
    public static int INSERTION = 1;
    public static int DELETION = -1;
    public static int MATCH = 0;
    private static final String UTF_8 = "UTF-8";

    public static void main(String[] args) throws Exception {
        File amp_list = new File(args[0]);
        File phredSnpDir = new File(args[1]);
        File snpDir = new File(args[2]);
        String[] amps = ComplarePoly.readTextFile(amp_list).split("\n");
        File phredPolyOutputDir = null;
        File polyOutputDir = null;
        File phredAllFastaDir = null;
        File allFastaDir = null;
        Map phredTrims = null;
        Map trims = null;
        int allcomparedBaseCount = 0;
        int allfpCount = 0;
        int allfnCount = 0;
        int allinsertionCount = 0;
        int alldeletionCount = 0;
        int alltotalDiffCount = 0;
        int alldiffPrimaryCount = 0;
        int index = 0;
        while (index < amps.length) {
            String amp = amps[index].trim();
            System.out.println(String.valueOf(index) + " " + amp);
            phredPolyOutputDir = new File(phredSnpDir + "/" + amp + "/" + "poly_dir/");
            polyOutputDir = new File(snpDir + "/" + amp + "/" + "poly_dir/");
            phredAllFastaDir = new File(phredSnpDir + "/" + amp + "/" + "snp_data_dir/");
            allFastaDir = new File(snpDir + "/" + amp + "/" + "snp_data_dir/");
            phredTrims = ComplarePoly.getTrimPositions(phredAllFastaDir);
            trims = ComplarePoly.getTrimPositions(allFastaDir);
            Map phredQuality = ComplarePoly.getQuality(phredAllFastaDir);
            Map quality = ComplarePoly.getQuality(allFastaDir);
            File[] phredPolyFiles = phredPolyOutputDir.listFiles();
            File[] polyFiles = polyOutputDir.listFiles();
            File phredPoly = null;
            File poly = null;
            int comparedBaseCount = 0;
            int fpCount = 0;
            int fnCount = 0;
            int totalDiffCount = 0;
            int insertionCount = 0;
            int deletionCount = 0;
            int diffPrimaryCount = 0;
            int diffSecondaryCount = 0;
            int diffQ10Parcent = 0;
            int diffQ20Parcent = 0;
            int diffQ40Parcent = 0;
            int diffQ55Parcent = 0;
            int i = 0;
            while (i < phredPolyFiles.length) {
                phredPoly = phredPolyFiles[i];
                if (phredPoly.getName().contains("poly") && (poly = new File(polyOutputDir, phredPoly.getName())).exists()) {
                    String name = phredPoly.getName().substring(0, phredPoly.getName().length() - 5);
                    int[] stats = ComplarePoly.comparePoly(phredPoly, poly, (String)phredQuality.get(name), (String)quality.get(name), (int[])phredTrims.get(name), (int[])trims.get(name));
                    comparedBaseCount += stats[0];
                    fpCount += stats[1];
                    fnCount += stats[2];
                    totalDiffCount += stats[3];
                    insertionCount += stats[4];
                    deletionCount += stats[5];
                    diffPrimaryCount += stats[6];
                    diffSecondaryCount += stats[7];
                    diffQ10Parcent += stats[8];
                    diffQ20Parcent += stats[9];
                    diffQ40Parcent += stats[10];
                    diffQ55Parcent += stats[11];
                }
                ++i;
            }
            allcomparedBaseCount += comparedBaseCount;
            allfpCount += fpCount;
            allfnCount += fnCount;
            allinsertionCount += insertionCount;
            alldeletionCount += deletionCount;
            alldiffPrimaryCount += diffPrimaryCount;
            alltotalDiffCount += totalDiffCount;
            System.out.println("\n\n**************Summary**************\n");
            System.out.println("Total bases " + comparedBaseCount);
            System.out.println("False Positives " + fpCount);
            System.out.println("False Negatives " + fnCount);
            System.out.println("Phred Insertions " + insertionCount);
            System.out.println("Phred Deletions " + deletionCount);
            System.out.println("Primary peak difference " + diffPrimaryCount);
            System.out.println("Total difference " + totalDiffCount);
            System.out.println("Average Q10 Diff " + diffQ10Parcent / phredPolyFiles.length);
            System.out.println("Average Q20 Diff " + diffQ20Parcent / phredPolyFiles.length);
            System.out.println("Average Q40 Diff " + diffQ40Parcent / phredPolyFiles.length);
            System.out.println("Average Q55 Diff " + diffQ55Parcent / phredPolyFiles.length);
            System.out.println("\n\n");
            ++index;
        }
        System.out.println("\n\n**************Overall Summary**************\n");
        System.out.println("Total bases " + allcomparedBaseCount);
        System.out.println("False Positives " + allfpCount);
        System.out.println("False Negatives " + allfnCount);
        System.out.println("Total Phred Insertions " + allinsertionCount);
        System.out.println("Total Phred Deletions " + alldeletionCount);
        System.out.println("Total Primary peak difference " + alldiffPrimaryCount);
        System.out.println("Total difference " + alltotalDiffCount);
    }

    private static Map getQuality(File dir) throws IOException {
        System.out.println(dir.getAbsolutePath());
        File allQuality = new File(dir, "allfasta.qual");
        Map qMap = ComplarePoly.getQualityMap(allQuality);
        return qMap;
    }

    private static Map getQualityMap(File file) throws IOException {
        ComplarePoly.qualityCorrect(file, new File(file + ".tmp"));
        HashMap<String, String> map = new HashMap<String, String>();
        String[] data = FileManager.readTextFile(new File(file + ".tmp")).split("\n");
        int i = 0;
        while (i < data.length - 1) {
            if (data[i].trim().startsWith(">")) {
                map.put(data[i].split("\\s+")[0].substring(1), data[i + 1].trim());
            }
            ++i;
        }
        return map;
    }

    public static void qualityCorrect(File fasta, File out) throws IOException {
        StringBuffer newData = new StringBuffer();
        String[] data = FileManager.readTextFile(fasta).split("\n");
        int i = 0;
        while (i < data.length) {
            String line1 = data[i];
            if (line1.trim().length() > 0 && line1.substring(0, 1).equals(">")) {
                newData.append(String.valueOf(line1) + "\n");
                String seq = "";
                int j = i + 1;
                while (j < data.length) {
                    String line2 = data[j];
                    if (line2.trim().length() <= 0 || line2.substring(0, 1).equals(">")) break;
                    seq = String.valueOf(seq) + line2.trim() + " ";
                    ++j;
                }
                newData.append(String.valueOf(seq.trim()) + "\n");
            }
            ++i;
        }
        FileManager.writeTextFile(out, newData.toString(), true);
    }

    private static Map getTrimPositions(File dir) throws IOException {
        System.out.println(dir.getAbsolutePath());
        File allFasta = new File(dir, "allfasta");
        File allFastaTrim = new File(dir, "allfasta_trim");
        Map fastaMap = ComplarePoly.getFastaMap(allFasta);
        Map trimedMap = ComplarePoly.getFastaMap(allFastaTrim);
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        for (String name : fastaMap.keySet()) {
            String fasta = (String)fastaMap.get(name);
            String trimedfasta = (String)trimedMap.get(name);
            int[] position = new int[2];
            if (trimedfasta != null) {
                position[0] = fasta.indexOf(trimedfasta) + 1;
                position[1] = position[0] + trimedfasta.length();
            }
            map.put(name, position);
        }
        return map;
    }

    public static void fastaCorrect(File fasta, File out) throws IOException {
        StringBuffer newData = new StringBuffer();
        String[] data = ComplarePoly.readTextFile(fasta).split("\n");
        int i = 0;
        while (i < data.length) {
            String line1 = data[i].trim();
            if (line1.length() > 0 && line1.substring(0, 1).equals(">")) {
                newData.append(String.valueOf(line1) + "\n");
                String seq = "";
                int j = i + 1;
                while (j < data.length) {
                    String line2 = data[j].trim();
                    if (line2.length() <= 0 || line2.substring(0, 1).equals(">")) break;
                    seq = String.valueOf(seq) + line2.trim();
                    ++j;
                }
                newData.append(String.valueOf(seq) + "\n");
            }
            ++i;
        }
        ComplarePoly.writeTextFile(out, newData.toString());
    }

    private static Map getFastaMap(File file) throws IOException {
        ComplarePoly.fastaCorrect(file, new File(file + ".tmp"));
        HashMap<String, String> map = new HashMap<String, String>();
        String[] data = ComplarePoly.readTextFile(new File(file + ".tmp")).split("\n");
        int i = 0;
        while (i < data.length - 1) {
            if (data[i].trim().startsWith(">")) {
                map.put(data[i].split("\\s+")[0].substring(1), data[i + 1].trim());
            }
            ++i;
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    private static int[] compareMatchedLine(String phredInfo, String info, int i) {
        block8: {
            block9: {
                block5: {
                    block7: {
                        block6: {
                            fps = 0;
                            fns = 0;
                            diffMajor = 0;
                            inconsistant = 0;
                            phredLine = phredInfo.split("\\s+");
                            line = info.split("\\s+");
                            if (!phredLine[0].trim().equals("N") && line[0].trim().equals("N")) {
                                System.out.println("!!!!!! N call at line " + i);
                                ++inconsistant;
                            }
                            if (phredLine[0].trim().equals("N")) break block5;
                            if (phredLine[4].trim().equals("N")) break block6;
                            v0 = new Float(phredLine[7]);
                            if (!((double)v0.floatValue() < 0.2)) break block5;
                        }
                        if (line[0].trim().equals("N")) break block5;
                        if (line[4].trim().equals("N")) break block7;
                        v1 = new Float(line[7]);
                        if (!((double)v1.floatValue() < 0.2)) break block5;
                    }
                    if (phredLine[0].trim().equals(line[0].trim())) break block5;
                    System.out.println("!!!!!!!!!!!!!!! Inconsistant major peak at line " + i);
                    System.out.println(phredInfo);
                    System.out.println(info);
                    break block8;
                }
                if (!phredLine[4].trim().equals("N") || line[4].trim().equals("N")) break block9;
                v2 = new Float(line[7]);
                if (!((double)v2.floatValue() > 0.2)) break block9;
                System.out.println("+++++++++++ False positive at line " + i);
                System.out.println(phredInfo);
                System.out.println(info);
                break block8;
            }
            if (phredLine[4].trim().equals("N") || !line[4].trim().equals("N")) ** GOTO lbl-1000
            v3 = new Float(phredLine[7]);
            if ((double)v3.floatValue() > 0.2) {
                System.out.println("----------- False negative at line " + i);
                System.out.println(phredInfo);
                System.out.println(info);
            } else if (!phredLine[4].trim().equals("N")) {
                v4 = new Float(phredLine[7]);
                if (!(!((double)v4.floatValue() > 0.2) || phredLine[0].equals(line[0]) && phredLine[4].equals(line[4]) || phredLine[0].equals(line[4]) && phredLine[4].equals(line[0]))) {
                    System.out.println("xxxxxxxxxxx Inconsistant double peak at line " + i);
                    System.out.println(phredInfo);
                    System.out.println(info);
                }
            }
        }
        ret = new int[]{++fps, ++fns, ++inconsistant, ++diffMajor};
        return ret;
    }

    private static int testInsertionDeletion(String[] phredInfo, String[] info) {
        int pos;
        int phredPos = new Integer(phredInfo[1]);
        if (phredPos - (pos = new Integer(info[1]).intValue()) > SHIFT) {
            return DELETION;
        }
        if (pos - phredPos > SHIFT) {
            return INSERTION;
        }
        return MATCH;
    }

    private static int[] comparePoly(File phredPoly, File poly, String phredQuality, String quality, int[] phredTrimPositions, int[] trimPositions) throws IOException {
        System.out.println("\n\n------------------------------\n" + phredPoly.getName());
        int comparedBaseCount = 0;
        int fpCount = 0;
        int fnCount = 0;
        int diffPrimary = 0;
        int diffSecondary = 0;
        int insertionCount = 0;
        int deletionCount = 0;
        int totalDiffCount = 0;
        LinkedHashMap<Integer, String> insertionMap = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, String> deletionMap = new LinkedHashMap<Integer, String>();
        String[] phredData = FileManager.readTextFile(phredPoly).split("\n");
        String[] data = FileManager.readTextFile(poly).split("\n");
        int phredQ10 = ComplarePoly.countQ(phredQuality, 10);
        int phredQ20 = ComplarePoly.countQ(phredQuality, 20);
        int phredQ40 = ComplarePoly.countQ(phredQuality, 40);
        int phredQ55 = ComplarePoly.countQ(phredQuality, 55);
        int q10 = ComplarePoly.countQ(quality, 10);
        int q20 = ComplarePoly.countQ(quality, 20);
        int q40 = ComplarePoly.countQ(quality, 40);
        int q55 = ComplarePoly.countQ(quality, 55);
        if (phredTrimPositions[0] == 0 || trimPositions == null) {
            int[] nArray = new int[12];
            nArray[0] = comparedBaseCount;
            nArray[1] = fpCount;
            nArray[2] = fnCount;
            nArray[3] = totalDiffCount;
            nArray[4] = insertionCount;
            nArray[5] = deletionCount;
            nArray[6] = diffPrimary;
            nArray[7] = diffSecondary;
            int[] ret = nArray;
            return ret;
        }
        int[] startPoints = ComplarePoly.findStartComparePoint(phredData, data, trimPositions[0]);
        int[] endPoints = ComplarePoly.findEndComparePoint(phredData, data, trimPositions[1]);
        if (startPoints[0] == 0) {
            int[] nArray = new int[12];
            nArray[0] = comparedBaseCount;
            nArray[1] = fpCount;
            nArray[2] = fnCount;
            nArray[3] = totalDiffCount;
            nArray[4] = insertionCount;
            nArray[5] = deletionCount;
            nArray[6] = diffPrimary;
            nArray[7] = diffSecondary;
            int[] ret = nArray;
            return ret;
        }
        System.out.println("PHRED_Trim : " + phredTrimPositions[0] + " " + phredTrimPositions[1]);
        System.out.println("CALLER_Trim: " + trimPositions[0] + " " + trimPositions[1]);
        System.out.println("PHRED Q10: " + phredQ10 + " PHRED Q20: " + phredQ20 + " Q40: " + phredQ40 + " Q55: " + phredQ55);
        System.out.println("CALLER Q10: " + q10 + " CALLER Q20: " + q20 + " Q40: " + q40 + " Q55: " + q55);
        comparedBaseCount = endPoints[0] - startPoints[0] + 1;
        int q10Diff = phredQ10 > 0 ? Math.round(Math.abs(phredQ10 - q10) * 100 / phredQ10) : 0;
        int q20Diff = phredQ20 > 0 ? Math.round(Math.abs(phredQ20 - q20) * 100 / phredQ20) : 0;
        int q40Diff = phredQ40 > 0 ? Math.round(Math.abs(phredQ40 - q40) * 100 / phredQ40) : 0;
        int q55Diff = phredQ55 > 0 ? Math.round(Math.abs(phredQ55 - q55) * 100 / phredQ55) : 0;
        comparedBaseCount = Math.min(endPoints[0], phredTrimPositions[1]) - Math.max(startPoints[0], phredTrimPositions[0]) + 1;
        int baseCallerOffset = startPoints[1];
        int i = Math.max(startPoints[0], phredTrimPositions[0]);
        while (i <= Math.min(endPoints[0], phredTrimPositions[1])) {
            String[] info;
            if (baseCallerOffset >= data.length) break;
            String[] phredInfo = phredData[i].split("\\s+");
            int test2 = ComplarePoly.testInsertionDeletion(phredInfo, info = data[baseCallerOffset].split("\\s+"));
            if (test2 == INSERTION) {
                insertionMap.put(new Integer(i + 1), phredData[i]);
            } else if (test2 == DELETION) {
                deletionMap.put(new Integer(i + 1), data[baseCallerOffset]);
                --i;
                ++baseCallerOffset;
            } else {
                int[] diffs = ComplarePoly.compareMatchedLine(phredData[i], data[baseCallerOffset], i + 1);
                fpCount += diffs[0];
                fnCount += diffs[1];
                diffSecondary += diffs[2];
                diffPrimary += diffs[3];
                totalDiffCount += diffs[0] + diffs[1] + diffs[2] + diffs[3];
                ++baseCallerOffset;
            }
            ++i;
        }
        Integer pos12 = null;
        String base1 = null;
        String base2 = null;
        Iterator it = insertionMap.keySet().iterator();
        while (it.hasNext()) {
            pos12 = (Integer)it.next();
            base1 = ((String)insertionMap.get(pos12)).split("\\s+")[0].trim();
            if (deletionMap.containsKey(pos12)) {
                base2 = ((String)deletionMap.get(pos12)).split("\\s+")[0].trim();
                if (!base1.equals(base2)) continue;
                it.remove();
                deletionMap.remove(pos12);
                continue;
            }
            if (!deletionMap.containsKey(new Integer(pos12 + 1)) || !base1.equals(base2 = ((String)deletionMap.get(new Integer(pos12 + 1))).split("\\s+")[0].trim())) continue;
            it.remove();
            deletionMap.remove(new Integer(pos12 + 1));
        }
        for (Integer pos12 : insertionMap.keySet()) {
            System.out.println(">>>>>>>>>> phred has insertion at : " + pos12);
            System.out.println(insertionMap.get(pos12));
            ++insertionCount;
            ++totalDiffCount;
        }
        for (Integer pos12 : deletionMap.keySet()) {
            System.out.println("<<<<<<<<<< phred has deletion at : " + pos12);
            System.out.println(deletionMap.get(pos12));
            ++deletionCount;
            ++totalDiffCount;
        }
        int[] ret = new int[]{comparedBaseCount, fpCount, fnCount, totalDiffCount, insertionCount, deletionCount, diffPrimary, diffSecondary, q10Diff, q20Diff, q40Diff, q55Diff};
        return ret;
    }

    private static int countQ(String quality, int cutoff) {
        int count = 0;
        if (quality == null || quality.length() == 0) {
            return 0;
        }
        String[] qualities = quality.split("\\s+");
        int i = 0;
        while (i < qualities.length) {
            int q = new Integer(qualities[i]);
            if (q >= cutoff) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int[] findEndComparePoint(String[] phredData, String[] data, int callerEnd) {
        int phredPos = 0;
        int[] ends = new int[2];
        int i = callerEnd;
        while (i > 1) {
            int thisPos;
            String[] info = data[i].split("\\s+");
            if (!info[0].equals("N") && (phredPos = ComplarePoly.findThisPosFromEnd(thisPos = new Integer(info[1]).intValue(), phredData)) > 0) {
                ends[0] = phredPos;
                ends[1] = i;
                return ends;
            }
            --i;
        }
        return ends;
    }

    private static int[] findStartComparePoint(String[] phredData, String[] data, int callerStart) {
        int[] starts = new int[2];
        int phredPos = 0;
        int i = callerStart;
        while (i < data.length) {
            int thisPos;
            String[] info = data[i].split("\\s+");
            if (!info[0].equals("N") && (phredPos = ComplarePoly.findThisPos(thisPos = new Integer(info[1]).intValue(), phredData)) > 0) {
                starts[0] = phredPos;
                starts[1] = i;
                return starts;
            }
            ++i;
        }
        return starts;
    }

    private static void resetPos(int[] pos) {
        int j = 0;
        while (j < 5) {
            pos[j] = 0;
            ++j;
        }
    }

    private static int findThisPos(int phredPos, String[] data) {
        int i = 1;
        while (i < data.length) {
            String[] info = data[i].split("\\s+");
            if (!info[0].equals("N")) {
                int pos = new Integer(info[1]);
                if (Math.abs(pos - phredPos) <= SHIFT) {
                    return i;
                }
                if (pos - phredPos > 6) {
                    return 0;
                }
            }
            ++i;
        }
        return 0;
    }

    private static int findThisPosFromEnd(int phredPos, String[] data) {
        int i = data.length - 1;
        while (i > 5) {
            String[] info = data[i].split("\\s+");
            if (!info[0].equals("N")) {
                int pos = new Integer(info[1]);
                if (Math.abs(pos - phredPos) <= SHIFT) {
                    return i;
                }
                if (pos - phredPos < 6) {
                    return 0;
                }
            }
            --i;
        }
        return 0;
    }

    private static boolean writeTextFile(File dest, String srcData) throws IOException {
        AbstractInterruptibleChannel destFileChannel = null;
        try {
            try {
                destFileChannel = new FileOutputStream(dest).getChannel();
                ((FileChannel)destFileChannel).write(ByteBuffer.wrap(srcData.getBytes(UTF_8)));
            }
            catch (IOException e) {
                e.printStackTrace();
                destFileChannel.close();
            }
        }
        finally {
            destFileChannel.close();
        }
        return true;
    }

    private static String readTextFile(File src) throws IOException {
        AbstractInterruptibleChannel srcFileChannel = null;
        ByteBuffer byteBuffer = null;
        String data = null;
        try {
            try {
                srcFileChannel = new FileInputStream(src).getChannel();
                byteBuffer = ByteBuffer.allocate((int)((FileChannel)srcFileChannel).size());
                ((FileChannel)srcFileChannel).read(byteBuffer);
                data = new String(byteBuffer.array(), UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
                srcFileChannel.close();
            }
        }
        finally {
            srcFileChannel.close();
        }
        return data;
    }
}

