/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompareHLATypingResult {
    public static String[] TYPES = new String[]{"A", "B", "Cw"};

    public static void main(String[] args) throws Exception {
        File ausFile = new File(args[0]);
        File gemsFile = new File(args[1]);
        Map<String, Map<String, String>> ausResultMap = CompareHLATypingResult.parseResultFile(ausFile);
        Map<String, Map<String, String>> gemsResultMap = CompareHLATypingResult.parseResultFile(gemsFile);
        CompareHLATypingResult.findDiscrepencies(ausResultMap, gemsResultMap);
    }

    private static void findDiscrepencies(Map<String, Map<String, String>> ausResultMap, Map<String, Map<String, String>> gemsResultMap) {
        StringBuilder builder = new StringBuilder();
        Map<String, String> ausCellResultMap = null;
        Map<String, String> gemsCellResultMap = null;
        String formatedCellLine = null;
        String gemsResult = null;
        String ausResult = null;
        for (String cellLine : gemsResultMap.keySet()) {
            builder.append(cellLine).append(",");
            gemsCellResultMap = gemsResultMap.get(cellLine);
            if (ausResultMap.containsKey(cellLine)) {
                builder.append(cellLine).append(",");
                ausCellResultMap = ausResultMap.get(cellLine);
            } else {
                formatedCellLine = cellLine.substring(0, cellLine.length() - 1);
                if (!ausResultMap.containsKey(formatedCellLine)) {
                    System.out.println("No cellline " + cellLine);
                }
                builder.append(formatedCellLine).append(",");
                ausCellResultMap = ausResultMap.get(formatedCellLine);
            }
            for (String type : gemsCellResultMap.keySet()) {
                if (ausCellResultMap == null) {
                    builder.append(type).append(",");
                    builder.append(gemsCellResultMap.get(type)).append(",");
                    builder.append("?").append(",");
                    builder.append(CompareHLATypingResult.compareResult(gemsCellResultMap.get(type), "?")).append("\n");
                    continue;
                }
                builder.append(type).append(",");
                gemsResult = gemsCellResultMap.get(type);
                ausResult = ausCellResultMap.get(type);
                if (ausResult == null) {
                    System.out.println(String.valueOf(cellLine) + " " + type);
                    for (String t : ausCellResultMap.keySet()) {
                        System.out.println("ava types " + t);
                    }
                    ausResult = "?";
                }
                builder.append(gemsResult).append(",");
                builder.append(ausResult).append(",");
                builder.append(CompareHLATypingResult.compareResult(gemsResult, ausResult)).append("\n");
            }
        }
        System.out.println(builder.toString());
    }

    private static String compareResult(String gemsResult, String ausResult) {
        if (ausResult.equals("?")) {
            return "NOT COMPARED";
        }
        if (gemsResult.equals(ausResult)) {
            return "TRUE";
        }
        String[] gemsEntry = gemsResult.split(" OR ");
        String[] ausEntry = ausResult.split(" OR ");
        boolean isAnyInCommon = false;
        boolean isAllInCommon = true;
        String[] stringArray = gemsEntry;
        int n = gemsEntry.length;
        int n2 = 0;
        while (n2 < n) {
            String entry1 = stringArray[n2];
            String[] stringArray2 = ausEntry;
            int n3 = ausEntry.length;
            int n4 = 0;
            while (n4 < n3) {
                String entry2 = stringArray2[n4];
                if (entry1.equals(entry2)) {
                    isAnyInCommon = true;
                } else {
                    isAllInCommon = false;
                }
                ++n4;
            }
            ++n2;
        }
        if (gemsEntry.length == gemsEntry.length && isAllInCommon) {
            return "TRUE";
        }
        if (isAnyInCommon) {
            return "TRUE";
        }
        return "FALSE";
    }

    private static Map<String, Map<String, String>> parseResultFile(File resutlFile) {
        LinkedHashMap<String, Map<String, String>> resultMap = new LinkedHashMap<String, Map<String, String>>();
        String[] lines = FileManager.readTextFile(resutlFile).trim().split("\n");
        String cellLine = null;
        String type = null;
        String result = null;
        int i = 1;
        while (i < lines.length) {
            if (lines[i].trim().length() > 0) {
                String[] items = lines[i].split(",");
                cellLine = items[0].trim();
                type = CompareHLATypingResult.formatType(items[1].trim());
                result = CompareHLATypingResult.formatResult(items);
                if (!resultMap.containsKey(cellLine)) {
                    resultMap.put(cellLine, new HashMap());
                }
                ((Map)resultMap.get(cellLine)).put(type, result);
            }
            ++i;
        }
        return resultMap;
    }

    private static String formatResult(String[] items) {
        StringBuilder result = new StringBuilder();
        String item = null;
        int i = 2;
        while (i < items.length) {
            item = items[i].trim();
            if (item.length() > 0) {
                result.append(item.replaceAll("No data\\+", "").replaceAll(" \\+No data", "").replaceAll("\\+No data", "").replaceAll(" \\+ ", "\\+")).append(" OR ");
            }
            ++i;
        }
        return result.toString().substring(0, result.toString().length() - 4);
    }

    private static String formatType(String item) {
        String type = null;
        type = item.indexOf("-") == -1 ? String.valueOf(item.charAt(3)) : item.split("-")[1];
        if (type.equals("C")) {
            type = TYPES[2];
        }
        if (!(type.equals(TYPES[0]) || type.equals(TYPES[1]) || type.equals(TYPES[2]))) {
            System.out.println("ERROR : Unknown type " + type);
        }
        return type;
    }
}

