/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckPrimerBindingMap {
    public static void main(String[] args) throws Exception {
        File ambiguityFile = new File(args[0]);
        File resolvingFile = new File(args[1]);
        File bindingFile = new File(args[2]);
        String[] ambiguities = FileManager.readTextFile(ambiguityFile).split("\n");
        Map<String, List<String>> primerResolvingMap = CheckPrimerBindingMap.getResolvingMap(resolvingFile);
        Map<String, List<String>> bindingMap = CheckPrimerBindingMap.getBindingMap(bindingFile);
        CheckPrimerBindingMap.ErrorChecking(ambiguities, primerResolvingMap, bindingMap);
    }

    private static void ErrorChecking(String[] ambiguities, Map<String, List<String>> primerResolvingMap, Map<String, List<String>> bindingMap) {
        for (String primer : primerResolvingMap.keySet()) {
            if (!bindingMap.containsKey(primer)) {
                System.out.println("error " + primer);
            }
            for (String ambiguity : primerResolvingMap.get(primer)) {
                String[] pairs;
                String thisAmbiguities = TestAmbiguityPrimer0620.findAmbiguity(ambiguities, ambiguity.trim());
                if (thisAmbiguities == null) {
                    System.out.println("can not find ambiguities " + ambiguity);
                    continue;
                }
                String[] stringArray = pairs = thisAmbiguities.trim().split(",");
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] data = pair.trim().split("\\+");
                    if (bindingMap.get(primer).contains(data[0]) && bindingMap.get(primer).contains(data[1])) {
                        System.out.println("trouble determin which should bind " + pair + " " + primer);
                    } else if (!bindingMap.get(primer).contains(data[0]) && !bindingMap.get(primer).contains(data[1])) {
                        System.out.println("None bind " + pair + " " + primer);
                    }
                    ++n2;
                }
            }
        }
    }

    private static Map<String, List<String>> getBindingMap(File bindingFile) {
        String[] lines = FileManager.readTextFile(bindingFile).split("\n");
        HashMap<String, List<String>> primerMap = new HashMap<String, List<String>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String primer = line.trim().split("=")[0];
                primerMap.put(primer, new ArrayList());
                String[] items = line.trim().split("=")[1].split(",");
                int i = 0;
                while (i < items.length) {
                    if (items[i].trim().length() != 0) {
                        ((List)primerMap.get(primer)).add(items[i]);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return primerMap;
    }

    private static Map<String, List<String>> getResolvingMap(File resolvingFile) {
        String[] lines;
        HashMap<String, List<String>> primerMap = new HashMap<String, List<String>>();
        String[] stringArray = lines = FileManager.readTextFile(resolvingFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split(",");
                int i = 1;
                while (i < items.length) {
                    String primer = items[i];
                    if (primer.trim().length() != 0) {
                        if (!primerMap.containsKey(primer)) {
                            primerMap.put(primer, new ArrayList());
                        }
                        ((List)primerMap.get(primer)).add(items[0]);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return primerMap;
    }
}

