% The code below produce results & plots for figure2, can uncomment line
% 19, 21, 23, 25, or 27 to run different model.

% Define a list for varying consumer-resource mass-ratio 
m = -9:0.5:9;
% number of iteration for each mass-ratio, can change to 1000.
pos = 200;
rep = 200;
% empty list/matrix to hold model results
dat = [];
diag_hold = [];
diag_sum = zeros(93,1); % here 93 is the species number
diag_tot = [];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for kk = m
    for jj = 1:rep
        % Uncomment the line below to run BMM model
        %temp = BMM(93,-3.86,3,kk,1,285,2);
        % Uncomment the line below to run RM model
        %temp = RM(93,-3.86,3,kk,1,285,2);
        % Uncomment the line below to run BTCM model
        %temp = BTCM(93,-3.86,3,kk,1,285,2);
        % Uncomment the line below to run BSRM model
        %temp = BSRM(93,-3.86,3,kk,1,285,2);
        % Uncomment the line below to run ART model
        %temp = ART(93,-3.86,3,kk,1,285,2);
        
        diag_hold = full(spones(diag(temp.CM)));
        diag_sum = diag_sum + diag_hold;
        holder1 = temp.count;

        if length(holder1) == 1
            pos = pos - 1;
        end
    end
    dat = cat(1,dat,[kk pos/rep]);
    pos = 200;
    diag_tot = [diag_tot,diag_sum];
    diag_sum = zeros(93,1);
end

h = figure('DefaultAxesFontSize',18);

plot(dat(:,1),dat(:,2),'--o','LineWidth',2,'MarkerEdgeColor','r','MarkerFaceColor','r','MarkerSize',8)
xlabel('log_{10}(Mean Optimum Resource-Consumer Mass Ratio)','FontSize',18)
ylabel('Probability of Stability','FontSize',18)
