% The code below produce results & plots for figure3a&b

% define a list for varying consumer-resource mass-ratio
m = -9:0.5:9;
% define empty list to hold results
is_mean = [];
mean_is = [];
mean_diag = [];
mean_diag_tot = [];
dat_mean = [];
dat_std = [];
m_tot = [];
dat_var = [];
cn_mean = [];
cn_std = [];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for kk = m
    is_mean = [];
    mean_is = [];
    mean_diag = [];
    is_var = [];
    cn = [];
    for jj = 1:200
        temp = ART(93,-3.86,3,kk,1,285,2);
        temp_pos = temp.CM(temp.CM>0);
        if ~isempty(temp_pos)
            diag_t = diag(temp.CM);
            diag_nzero = diag_t(diag_t<0);
            cn_count = nnz(temp.CM);
            cn = [cn, cn_count/8649];
            is_mean = [is_mean, log10(mean(temp_pos/0.4))];
            mean_diag = [mean_diag, log10(mean(-diag_nzero))];
        end
    end
    dat_mean = [dat_mean, mean(is_mean)];
    dat_std = [dat_std, std(is_mean)];
    mean_diag_tot = [mean_diag_tot, mean(mean_diag)];
    cn_mean = [cn_mean, mean(cn)];
    cn_std = [cn_std, std(cn)];
end

% plot connectance vs. size-ratio
figure;errorbar(m,cn_mean,cn_std)
% plot interaction strength vs. size-ratio
figure;errorbar(m,dat_mean,dat_std)