function out = RM(num_spe,a0,b0,a2,b2,conn,D)
% define the inputs:cler

% a2 and b2 are the parameters for the distribution we used
% to model the likelihood of interaction between species.

% sample distribution from beta or lognormal pdf, this will give you a list of
% species with size sampled from a lognormal distribution with
% parameters a1 and b1.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% here we try sample species from just one distribution:

total_list = sample_norm_logspace(num_spe,a0,b0);

total_list = sort(total_list,'descend');

% Approximates the mass abundance for sampled species using Damuth's rule:

ma = 10^4.23*total_list.^0.25;

dim = length(total_list); %fix the bug that lognormal might sample out of range.

%Next, create place holder for both interaction and adjacency matrix.

CM = zeros(dim); %adjacency matrix

%First, create the block matrix:

X = -15:0.01:15;
Y = normpdf(X,a2,b2);
nmax = max(Y);
temp_hol = [];
id = 1;
ratio_dat = [];

for i = 1:dim
    for j = 1:dim
        
        if i == j
            CM(i,j) = -1; %We set self-regulation to -1 for now.
        else
            temp_hol = [i j total_list(i) total_list(j) id];
            ratio_dat = cat(1,ratio_dat,temp_hol);
            id = id + 1;
        end
        
    end
end

fix_inter = [];
samp_size = conn*2;

fix_inter = datasample(ratio_dat,samp_size,'Replace',false);

% Let's define our parameters first:
if D == 2
    a0 = 10^-3.08;      %10^-3.08 for 2D and 10^-1.77 for 3D
    R0 = 0.05;           %0.01-1 for 2D and 3-300 for 3D (K0 also)
    pd = 0.21;          %0.21 for 2D and 0.2 for 3D
    d = 2;              %dimensionality, 2 or 3.
elseif D == 3
    a0 = 10^-1.77;      %10^-3.08 for 2D and 10^-1.77 for 3D
    R0 = 200;           %0.01-1 for 2D and 3-300 for 3D (K0 also)
    pd = 0.2;          %0.21 for 2D and 0.2 for 3D
    d = 3;              %dimensionality, 2 or 3.
end
r0 = 1.71*10^-6;    %Scaling constant for resource biomass production rate.
pv = 0.26;
bx = 0.75;          
gamma = 1;          %1-4
h0 = 1;             
bh = 0.75;          
b = 0.75;           %Exponent for metabolic scaling with body mass
e = 0.5;            
z0 = 4.15*10^-8;
is_list = [];

%And then we calculate interaction strength for each entry:
for ii = 1:samp_size
    delta = 0;
    mc = 0;
    mr = 0;
    k = 0;
    mc = fix_inter(ii,3); % mass of consumer
    mr = fix_inter(ii,4); % mass of resource
    k = mr/mc;            % mass ratio
    delta = a0*R0*mc^(pv+2*pd*(d-1))*mr^(1-bx)*(k^(pd*(d-1))/(1 + k^gamma));
    is_list = [is_list, (delta/(1 + h0*mc^(-bh)*delta))*ma(fix_inter(ii,1))];
end

is_max_log = log10(max(is_list));
is_min_log = log10(min(is_list));
r = (is_max_log-is_min_log).*rand(1000,1) + is_min_log;
r_off = [-10.^r;e*10.^r];

out.r = r;
out.off = r_off;

for ii = 1:samp_size
    CM(fix_inter(ii,1),fix_inter(ii,2)) = datasample(r_off,1);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Do the stability analysis.

ev = eig(CM);

count = real(max(ev(ev>0)));

out.count = count;
out.CM = CM;
out.ev = ev;

[cl,rl] = find(CM>0);

out.el = [cl,rl];
out.nl = total_list;

return
