% The code below produces model connectance prediction (model output in figure4)

% Here we just want to start with full connectance and then let the model
% run and at the end capture the final connectance and repeat that for n
% times.

% First the network parameters (size, mass, mass ratio) based on empirical
% data:

size_range = round(logspace(0.4771,2.1847,20));

dim = 2;

con_final = [];
con_dat_log = [];
con_dat = [];
con_dat_final = [];

for jj = size_range
    con_tot = [];
    for ii = 1:200
        full_conn = jj^2;
        initial_c = round(0.9*jj*(jj-1)/2);
        
        a = ART(jj,-3.86,3,-1,1,initial_c,2);
        
        connectance = (nnz(a.CM))/full_conn;
        con_tot = cat(1, con_tot, [jj connectance]);
        if connectance ~= 0
            con_dat_log = cat(1,con_dat_log, [log(jj) log(connectance)]);
            con_dat = cat(1,con_dat, [jj connectance]);
        end
    end
    indices = find(con_tot(:,2)==0);
    con_tot(indices,:) = [];
    con_tot_log = log(con_tot);
    con_mean = mean(con_tot_log(:,2));
    con_std = std(con_tot_log(:,2));
    con_dat_mean = mean(con_tot(:,2));
    con_dat_std = std(con_tot(:,2));
    
    con_final = cat(1, con_final, [log(jj) con_mean con_std]);
    con_dat_final = cat(1, con_dat_final, [jj con_dat_mean con_dat_std]);
end

figure;errorbar(con_final(:,1),con_final(:,2),con_final(:,3))