function out = BSRM(num_spe,a0,b0,a2,b2,conn,D)
% define the inputs:cler

% a2 and b2 are the parameters for the distribution we used
% to model the likelihood of interaction between species.

% sample distribution from beta or lognormal pdf, this will give you a list of
% species with size sampled from a lognormal distribution with
% parameters a1 and b1.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% here we try sample species from just one distribution:

total_list = sample_norm_logspace(num_spe,a0,b0);

total_list = sort(total_list,'descend');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dim = length(total_list); %fix the bug that lognormal might sample out of range.

%Next, create place holder for both interaction and adjacency matrix.

CM = zeros(dim); %adjacency matrix

%First, create the block matrix:
temp_hol = [];
id = 1;
ratio_dat = [];

for i = 1:dim
    for j = 1:dim
        
        if i == j
            CM(i,j) = 0;
        else
            ratio_sb = log10(total_list(j)/total_list(i));
            link_prob = normpdf(ratio_sb,a2,b2);
            temp_hol = [i j total_list(i) total_list(j) ratio_sb id link_prob];
            ratio_dat = cat(1,ratio_dat,temp_hol);
            id = id + 1;
        end
        
    end
end

fix_inter = [];
samp_size = conn;

fix_inter = datasample(ratio_dat,samp_size,'Replace',false,'Weights',ratio_dat(:,7));

% Let's define our parameters first:
if D == 2
    a0 = 10^-3.08;      %10^-3.08 for 2D and 10^-1.77 for 3D
    R0 = 0.05;           %0.01-1 for 2D and 3-300 for 3D (K0 also)
    pd = 0.21;          %0.21 for 2D and 0.2 for 3D
    d = 2;              %dimensionality, 2 or 3.
elseif D == 3
    a0 = 10^-1.77;      %10^-3.08 for 2D and 10^-1.77 for 3D
    R0 = 200;           %0.01-1 for 2D and 3-300 for 3D (K0 also)
    pd = 0.2;          %0.21 for 2D and 0.2 for 3D
    d = 3;              %dimensionality, 2 or 3.
end
r0 = 1.71*10^-6;    %Scaling constant for resource biomass production rate.
pv = 0.26;
bx = 0.75;          
gamma = 1;          %1-4

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h0 = 0;             %0-10^4       MAKE THIS 0 for TYPE I FUNCTIONAL RESPONSE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bh = 0.75;          
b = 0.75;           %Exponent for metabolic scaling with body mass
e = 0.9;            
z0 = 10^-6.62499;

%And then we calculate interaction strength for each entry:
for ii = 1:samp_size
    delta = 0;
    mc = 0;
    mr = 0;
    k = 0;
    if fix_inter(ii,1) ~= fix_inter(ii,2)
        mc = fix_inter(ii,3); % mass of consumer
        mr = fix_inter(ii,4); % mass of resource
        k = mr/mc;            % mass ratio
        delta = a0*R0*mc^(pv+2*pd*(d-1))*mr^(1-bx)*(k^(pd*(d-1))/(1 + k^gamma));
        CM(fix_inter(ii,2),fix_inter(ii,1)) = -delta/(1 + h0*mc^(-bh)*delta); % Enter interaction strength here, which should be -c
        % below is consumption rate times efficiency
        CM(fix_inter(ii,1),fix_inter(ii,2)) = -e*CM(fix_inter(ii,2),fix_inter(ii,1)); % should be e*c
    else
        CM(fix_inter(ii,1),fix_inter(ii,2)) = 0;
    end 
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The line below describes percentage of species that self regulates. One
% can change it to 0 to represent self-regulation free model.
psr = 0.7; % the default values we are using is 0.75...
nsr = round(num_spe*psr);
si = 1:num_spe;
srw = r0*total_list.^-0.5/R0;
srind = datasample(si,nsr,'Replace',false,'Weights',srw);


for jj = 1:length(CM)
    mc = total_list(jj);
    
    % This part is adding the self-regulation terms.
    if ismember(jj,srind)
       CM(jj,jj) = -r0*mc^-0.5/R0;
    end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Do the stability analysis.

ev = eig(CM);

count = real(max(ev(ev>0)));

out.count = count;
out.CM = CM;
out.ev = ev;

[cl,rl] = find(CM>0);

out.el = [cl,rl];
out.nl = total_list;

return
