\name{DataCheck}
\alias{DataCheck}
\title{A function to check the input data file for a Bayesian Survival Trajectory Analysis on ZIMS data (BaSTA.ZIMS).}

\description{This function performs some basic error checking on the input files for a BaSTA.ZIMS analysis. A number of checks are performed including; (1) individuals dying before the observation window starts; (2) individuals with no observations of any kind (i.e. phantom individuals); (3) individuals with birth date recorded as being after death date; (4) individuals with observations recorded after death; (5) individuals with observations before birth; (6) years of birth must appear as 0 in the observation matrix; (7) years of death must appear as 0 in the observation matrix.}

\usage{DataCheck(object, silent = FALSE)}

\arguments{

  \item{object }{A data.frame to be used as an input data file for BaSTA.ZIMS. See details.}

  \item{silent }{A logical argument indicating whether to print a detailed report to the screen or not.}

}

\details{
The input data \code{object} requires at least five dates columns, namely \dQuote{Birth.Date}, \dQuote{Min.Birth.Date}, \dQuote{Max.Birth.Date}, \dQuote{Entry.Date}, and \dQuote{Depart.Date}. All dates need to be format as \dQuote{\%Y-\%m-\%d}. In addition, a \dQuote{Depart.Type} column is required with two types of departures \dQuote{C} for Censored and \dQuote{D} for dead.
}

\value{

}

\author{Fernando Colchero \email{colchero@imada.sdu.dk}}

\seealso{\code{\link{bastaZIMS}}}


