class OPT_TRAIN:
    def __init__(self, data = 'data/USPTO-50K/USPTO-50K', reverse = False):
        self.accum_count=4
        self.adagrad_accumulator_init=0
        self.adam_beta1=0.9
        self.adam_beta2=0.998
        self.audio_enc_pooling='1'
        self.batch_size=4096
        self.batch_type='tokens'
        self.bridge=False
        self.brnn=None
        self.c_val=0.0
        self.cnn_kernel_width=3
        self.context_gate=None
        self.copy_attn=False
        self.copy_attn_force=False
        self.copy_loss_by_seqlength=False
        self.coverage_attn=False
        self.data=data
        self.dec_layers=2
        self.dec_rnn_size=500
        self.decay_method='noam'
        self.decay_steps=10000
        self.decoder_type='transformer'
        self.dropout=0.1
        self.enc_layers=2
        self.enc_rnn_size=500
        self.encoder_type='transformer'
        self.epochs=0
        self.exp=''
        self.exp_host=''
        self.feat_merge='concat'
        self.feat_vec_exponent=0.7
        self.feat_vec_size=-1
        self.fix_word_vecs_dec=False
        self.fix_word_vecs_enc=False
        self.generator_function='log_softmax'
        self.global_attention='general'
        self.global_attention_function='softmax'
        self.gpu_backend='nccl'
        self.gpu_ranks=[2, 3, 4]
        self.gpu_verbose_level=0
        self.gpuid=[]
        self.heads=8
        self.image_channel_size=3
        self.input_feed=1
        self.keep_checkpoint=20
        self.label_smoothing=0.0
        self.lambda_coverage=1
        self.layers=13
        self.learning_rate=2.0
        self.learning_rate_decay=0.5
        self.log_file=''
        self.master_ip='localhost'
        self.master_port=10000
        self.max_generator_batches=32
        self.max_grad_norm=0.0
        self.model_type='text'
        self.normalization='tokens'
        self.optim='adam'
        self.param_init=0.0
        self.param_init_glorot=True
        self.position_encoding=True
        self.pre_word_vecs_dec=None
        self.pre_word_vecs_enc=None
        self.report_every=1000
        self.reuse_copy_attn=False
        self.rnn_size=256
        self.rnn_type='LSTM'
        self.sample_rate=16000
        self.save_checkpoint_steps=10000
        self.save_model='experiments/checkpoints/USPTO-50K/USPTO-50K_model'
        self.seed=42
        self.self_attn_type='scaled-dot'
        self.share_decoder_embeddings=False
        self.share_embeddings=True
        self.src_word_vec_size=500
        self.start_decay_steps=50000
        self.tensorboard=False
        self.tensorboard_log_dir='runs/onmt'
        self.tgt_word_vec_size=500
        self.train_from=''
        self.train_steps=250000
        self.transformer_ff=2048
        self.truncated_decoder=0
        self.valid_batch_size=32
        self.valid_steps=10000
        self.warmup_steps=8000
        self.window_size=0.02
        self.word_vec_size=256
        self.world_size=1

        if reverse:
            data = 'data/USPTO-50K-reverse/USPTO-50K-reverse'
            self.data = data
    
    