import unittest
import test_angles
import test_test
import test_fd_gradient
import test_fd_hess_on_vec
import test_fd_hessian
import test_fd_sym
import test_fragments
import test_interfaces
import test_molecule
import test_pbc_interfaces
import test_projector
import test_ric
# import test_system
import test_unit_cell
import test_vci


def run_suite():
    suite = unittest.TestSuite()

    suite.addTest(test_test.TestTest("test_framework"))

    suite.addTest(test_angles.AngleTest("test_angle_list1"))
    suite.addTest(test_angles.AngleTest("test_angle_list2"))
    suite.addTest(test_angles.AngleTest("test_angle_value"))
    suite.addTest(test_angles.AngleTest("test_dihedral_list1"))
    suite.addTest(test_angles.AngleTest("test_dihedral_list2"))
    suite.addTest(test_angles.AngleTest("test_dihedral_value"))

    suite.addTest(test_fd_gradient.FDGradTest("test_H2"))
    suite.addTest(test_fd_gradient.FDGradTest("test_diamond_pbe"))
    # suite.addTest(test_fd_gradient.FDGradTest("test_Si_pbe"))

    suite.addTest(test_fd_hessian.FDHessianTest("test_H2"))
    suite.addTest(test_fd_hessian.FDHessianTest("test_CH4"))

    suite.addTest(test_fd_hess_on_vec.FDHessVecTest("test_H2"))
    suite.addTest(test_fd_hess_on_vec.FDHessVecTest("test_H2_mweight"))
    suite.addTest(test_fd_hess_on_vec.FDHessVecTest("test_H2_forward"))
    suite.addTest(test_fd_hess_on_vec.FDHessVecTest("test_H2_backward"))
    suite.addTest(test_fd_hess_on_vec.FDHessVecTest("test_H2_fmweight"))

    suite.addTest(test_fd_sym.FDSymTest("test_H2"))

    suite.addTest(test_fragments.FragmentTest("test_bond_list1"))
    suite.addTest(test_fragments.FragmentTest("test_fragment_list1"))
    suite.addTest(test_fragments.FragmentTest("test_fragment_list2"))
    suite.addTest(test_fragments.FragmentTest("test_fragment_list3"))
    suite.addTest(test_fragments.FragmentTest("test_fblist"))

    suite.addTest(test_interfaces.InterfaceTest("test_pyscf"))
    suite.addTest(test_interfaces.InterfaceTest("test_xtb"))
    suite.addTest(test_interfaces.InterfaceTest("test_ase"))
    suite.addTest(test_interfaces.InterfaceTest("test_ase_qchem"))

    suite.addTest(test_molecule.MoleculeTest("test_He"))
    suite.addTest(test_molecule.MoleculeTest("test_atoms"))
    suite.addTest(test_molecule.MoleculeTest("test_xyz"))
    # suite.addTest(test_molecule.MoleculeTest("test_h5py"))
    suite.addTest(test_molecule.MoleculeTest("test_ase"))

    suite.addTest(test_pbc_interfaces.PBCInterfaceTest("test_pyscf_lda"))
    suite.addTest(test_pbc_interfaces.PBCInterfaceTest("test_pyscf_hf"))

    suite.addTest(test_projector.ProjectorTest("test_H2"))
    suite.addTest(test_projector.ProjectorTest("test_H2O"))

    suite.addTest(test_ric.RICTest("test_H2"))
    suite.addTest(test_ric.RICTest("test_H2O"))

    # suite.addTest(test_system.SystemTest("test_sys_h5py"))

    suite.addTest(test_unit_cell.UnitCellTest("test_input_diamond"))
    suite.addTest(test_unit_cell.UnitCellTest("test_supercell"))
    suite.addTest(test_unit_cell.UnitCellTest("test_h5py"))
    suite.addTest(test_unit_cell.UnitCellTest("test_ase"))

    suite.addTest(test_vci.VCITest("test_N2H2_1"))
    suite.addTest(test_vci.VCITest("test_N2H2_2"))
    suite.addTest(test_vci.VCITest("test_N2H2_3"))
    suite.addTest(test_vci.VCITest("test_N2H2_4"))

    return suite


if __name__ == '__main__':
    import logging
    logging.basicConfig(
        format='%(levelname)s:%(message)s',
        level=logging.WARNING)
    runner = unittest.TextTestRunner()
    runner = unittest.TextTestRunner()
    runner.run(run_suite())
