import numpy


def get_phonons(natom, masses, coords, F2q):
    Mi2 = 1.0/numpy.sqrt(numpy.asarray(masses))
    F2qm = numpy.einsum('ij,i,j->ij', F2q, Mi2, Mi2)
    e, v = numpy.linalg.eigh(F2qm)
    w = numpy.zeros(e.shape)
    for i, ei in enumerate(e):
        w[i] = numpy.sqrt(ei) if ei > 0 else -numpy.sqrt(abs(ei))
    return w


def get_phonons_supercell(natom, masses, coords, supercell, coords_s, F2, q):
    np = 3*natom
    N = supercell[0]*supercell[1]*supercell[2]
    F2x = F2[:np]
    F2q = numpy.zeros((np, np), dtype=complex)
    for i in range(N):
        phases = numpy.zeros((np, np), dtype=complex)
        for u in range(natom):
            for v in range(natom):
                R = numpy.asarray(coords[u]) - numpy.asarray(coords_s[i*natom + v])
                phase = numpy.exp(-1.j*numpy.dot(q, R))
                phases[3*u:3*(u + 1), 3*v:3*(v + 1)] = phase*numpy.ones((3, 3))
        F2q += F2x[:np, i*np:(i + 1)*np]*phases
    F2q = 0.5*(F2q + numpy.conj(F2q.transpose((1, 0))))

    return get_phonons(natom, masses, coords, F2q)
