import logging
import numpy
from .optimizer import Optimizer


class Newton(Optimizer):
    def __init__(self, maxstep=None):
        self.maxstep = maxstep
        self.maxderiv = 2

    def step(self, E, g, hess):
        assert(E is not None)
        assert(g is not None)
        assert(hess is not None)
        hinv = numpy.linalg.pinv(hess, rcond=1e-9)
        step = -numpy.matmul(hinv, g)
        sd = numpy.linalg.norm(step)/numpy.sqrt(step.shape[0])
        if sd > self.maxstep:
            scale = self.maxstep/sd
            logging.info("   Newton stepsize exceeds maximum, scaling by {}".format(scale))
            step *= scale
        return step
