class ComputerInterface(object):
    """Computer interface base class."""
    def max_deriv(self):
        """Return maximum available derivative order."""
        raise NotImplementedError

    def energy(self, mol):
        """Return the energy of the given molecule."""
        raise NotImplementedError

    def gradient(self, mol):
        """Return the gradient of the given molecule."""
        raise NotImplementedError

    def hessian(self, mol):
        """Return the hessian of the given molecule."""
        raise NotImplementedError

    def d3(self, mol):
        """Return the 3rd derivatives of the given molecule."""
        raise NotImplementedError

    def d4(self, mol):
        """Return the 4th derivatives of the given molecule."""
        raise NotImplementedError

    def d5(self, mol):
        """Return the 5th derivatives of the given molecule."""
        raise NotImplementedError

    def d6(self, mol):
        """Return the 6th derivatives of the given molecule."""
        raise NotImplementedError


class PBCComputerInterface(object):
    """PBC computer interface base class."""
    def energy(self, cell):
        """Return the energy of the given unit cell (per primitive cell)."""
        raise NotImplementedError

    def forces(self, cell):
        """Return the forces on the atoms in the primitive unit cell."""
        raise NotImplementedError
