import logging
import numpy


def get_step(mol, ic, x):
    max_iter = 100
    B = ic.bmatrix_gen(mol.coords)
    c0 = numpy.asarray(mol.coords)
    xi = numpy.zeros((x.shape))
    xc = numpy.zeros((3*mol.natom))
    for i in range(max_iter):
        residual = numpy.linalg.norm(x - xi)/numpy.sqrt(x.shape[0])
        logging.debug("{:4d}: {:.4e}".format(i, residual))
        if residual < 1e-6:
            break
        Binv = numpy.linalg.pinv(B.transpose((1, 0)), rcond=1e-6)
        xc = xc + numpy.matmul(Binv.transpose((1, 0)), x - xi)

        # form new ics and B matrix
        xi = ic.evaluate(c0 + xc.reshape(mol.natom, 3)) - ic.evaluate(c0)
        B = ic.bmatrix_gen(c0 + xc.reshape(mol.natom, 3))
    if i == (max_iter - 1):
        logging.warning("Failed to solve for cartesian step!")
    else:
        logging.debug("Found cartesian step in {} iterations".format(i))
    return xc
