pro_to_el = 1.8361526738917E3
amu_to_el = 1.82288848619253E3
bohr_to_angstrom = 0.52917721067
angstrom_to_bohr = 1.0 / bohr_to_angstrom
hartree_to_cm_1 = 219474.631370213
hartree_to_kcal = 627.50947415
hartree_to_ev = 27.2113860217
au_to_pa = 2.942191219E13  # atomic unit of pressure in Pa
kb = 8.617330350e-5  # in eV

elements = [
        "H",
        "He",
        "Li",
        "Be",
        "B",
        "C",
        "N",
        "O",
        "F",
        "Ne",
        "Na",
        "Mg",
        "Al",
        "Si",
        "P",
        "S",
        "Cl",
        "Ar",
        "K",
        "Ca",
        "Sc",
        "Ti",
        "V",
        "Cr",
        "Mn",
        "Fe",
        "Co",
        "Ni",
        "Cu",
        "Zn",
        "Ga",
        "Ge",
        "As",
        "Se",
        "Br",
        "Kr"
]

# Atomic masses (amu) of most abundant isotope
atomic_masses = [
        1.007825,   # H
        3.016029,   # He
        6.015122,   # Li
        9.012182,   # Be
        10.012937,  # B
        12.000000,  # C
        14.003074,  # N
        15.994915,  # O
        18.998403,  # F
        19.992440,  # Ne
        22.989769,  # Na
        23.985042,  # Mg
        26.981539,  # Al
        27.976927,  # Si
        30.973762,  # P
        31.972071,  # S
        34.968853,  # Cl
        39.962383,  # Ar
        38.963706,  # K
        39.962591,  # Ca
        44.955908,  # Sc
        47.947942,  # Ti
        50.943957,  # V
        51.940506,  # Cr
        54.938044,  # Mn
        55.934936,  # Fe
        58.933194,  # Co
        57.935342,  # Ni
        62.929598,  # Cu
        63.929142,  # Zn
        68.925574,  # Ga
        73.921178,  # Ge
        74.921595,  # As
        79.916522,  # Se
        78.918338,  # Br
        83.911498   # Kr
]

charges = [
        1.0,
        2.0,
        3.0,
        4.0,
        5.0,
        6.0,
        7.0,
        8.0,
        9.0,
        10.0,
        11.0,
        12.0,
        13.0,
        14.0,
        15.0,
        16.0,
        17.0,
        18.0,
        19.0,
        20.0,
        21.0,
        22.0,
        23.0,
        24.0,
        25.0,
        26.0,
        27.0,
        28.0,
        29.0,
        30.0,
        31.0,
        32.0,
        33.0,
        34.0,
        35.0,
        36.0
]

# Covalent radii (max) in pm from:
# Cordero, et al, Dalton Trans, 21, 2821 (2008)
# https://doi.org/10.1039/B801115J
covalent_radius = [
        31.0,   # H
        28.0,   # He
        128,    # Li
        96.0,   # Be
        84.0,   # B
        76.0,   # C
        71.0,   # N
        66.0,   # O
        57.0,   # F
        58.0,   # Ne
        166.0,  # Na
        141.0,  # Mg
        121.0,  # Al
        111.0,  # Si
        107.0,  # P
        105.0,  # S
        102.0,  # Cl
        106.0,  # Ar
        203.0,  # K
        176.0,  # Ca
        170.0,  # Sc
        160.0,  # Ti
        153.0,  # V
        139.0,  # Cr
        161.0,  # Mn
        152.0,  # Fe
        150.0,  # Co
        124.0,  # Ni
        132.0,  # Cu
        122.0,  # Zn
        122.0,  # Ga
        120.0,  # Ge
        119.0,  # As
        120.0,  # Se
        120.0,  # Br
        116.0   # Kr
]
