from .constants import bohr_to_angstrom
from .interface import ComputerInterface


class ASEInterface(ComputerInterface):
    def __init__(self, calc):
        self.calc = calc
        self.maxderiv = 1

    def max_deriv(self):
        return self.maxderiv

    def energy(self, mol):
        atoms = mol.get_ase()
        atoms.set_calculator(self.calc)
        return atoms.get_potential_energy()

    def gradient(self, mol):
        atoms = mol.get_ase()
        atoms.set_calculator(self.calc)
        E = atoms.get_potential_energy()
        F1 = atoms.get_forces()
        return E, -1.0*F1.reshape(-1)*bohr_to_angstrom
