import sys
import logging
from omega.system import *
from omega.thermochemistry import HO_RR_analysis
from omega.vci import VCI
from omega import constants

logging.basicConfig(
    format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)
sys = MolSystem(filename="h5/h2o_b3lyp_ccpvdz_100.h5")
sys.get_normal_modes()
HO_RR_analysis(sys)

ci = VCI(sys, 2)
ci.print_basis()
e = ci.solve()
print((e - e[0])*constants.hartree_to_cm_1)
