import sys
import logging
from omega.system import *
from omega.pyscf_interface import PyscfInterface, Options

logging.basicConfig(
    format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)
mol = get_mol_from_xyz("xyz/h2o_b3lyp_ccpvdz.xyz")

op = Options()
op.method = "b3lyp"
op.basis = "ccpvdz"
computer = PyscfInterface(op)

sys = MolSystem(mol=mol)
sys.compute_forces(computer, order=4, delta=0.001)
print("Total energy: {}".format(sys.E))
sys.get_normal_modes()
sys.save("h5/h2o_b3lyp_ccpvdz_100.h5")
