import logging
from omega.system import *
import omega.thermochemistry as thermo
from omega.pyscf_interface import PyscfInterface, Options

logging.basicConfig(format='%(levelname)s:%(message)s', level=logging.INFO)
mol = get_mol_from_xyz("xyz/h2_b3lyp_ccpvtz.xyz")

op = Options()
op.method = "b3lyp"
op.charge = 0
op.spin = 0
op.basis = "ccpvtz"
computer = PyscfInterface(op)

sys = MolSystem(mol=mol)
sys.compute_forces(computer)
print("Total energy: {}".format(sys.E))
sys.get_normal_modes()
thermo.HO_RR_analysis(sys)
