import logging
from omega.system import *
from omega.pyscf_interface import PyscfInterface, Options
from omega.opt import optimize

logging.basicConfig(format='%(levelname)s:%(message)s', level=logging.INFO)
op = Options()
op.method = "HF"
op.charge = 0
op.spin = 0
op.basis = "def2-svp"
computer = PyscfInterface(op)

# start from B3lyp, sto-3g geometry
mol = get_mol_from_xyz("xyz/Benzene_b3lyp_sto3g.xyz")
omol = optimize(mol, computer, method="RIC")
