import sys
import logging
from omega.system import *
import omega.thermochemistry as thermo
from omega.pyscf_interface import PyscfInterface, Options

logging.basicConfig(
    format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)
op = Options()
op.method = "b3lyp"
op.charge = 0
op.spin = 0
op.basis = "sto3g"
computer = PyscfInterface(op)

sys = MolSystem(filename="xyz/Benzene_b3lyp_sto3g.xyz")
sys.compute_forces(computer)
print("Total energy: {}".format(sys.E))
sys.get_normal_modes()
thermo.HO_RR_analysis(sys)
